/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;

class UdpReceiver
implements Runnable {
    private List m_eventsIn;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context;
    private String m_logPrefix;

    UdpReceiver(DatagramSocket sock, List xchange) {
        this.m_eventsIn = xchange;
        this.m_stop = false;
        this.m_dgSock = sock;
        this.m_logPrefix = "OpenNMS.Eventd";
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stopping and joining thread context " + this.m_context.getName()));
            }
            this.m_context.interrupt();
            this.m_context.join();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Thread context stopped and joined");
            }
        }
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_context = Thread.currentThread();
        ThreadCategory.setPrefix((String)this.m_logPrefix);
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isTracing = log.isDebugEnabled();
        if (this.m_stop) {
            if (isTracing) {
                log.debug((Object)"Stop flag set before thread started, exiting");
            }
            return;
        }
        if (isTracing) {
            log.debug((Object)"Thread context started");
        }
        int length = 65535;
        byte[] buffer = new byte[65535];
        DatagramPacket pkt = new DatagramPacket(buffer, 65535);
        try {
            if (isTracing) {
                log.debug((Object)"Setting socket timeout to 500ms");
            }
            this.m_dgSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            log.warn((Object)"An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            if (isTracing) {
                log.debug((Object)"Setting receive buffer size to 65535");
            }
            this.m_dgSock.setReceiveBufferSize(65535);
        }
        catch (SocketException e) {
            log.info((Object)"Failed to set the receive buffer to 65535", (Throwable)e);
        }
        boolean ioInterrupted = false;
        while (!this.m_stop) {
            if (this.m_context.isInterrupted()) {
                if (!isTracing) break;
                log.debug((Object)"Thread context interrupted");
                break;
            }
            try {
                if (isTracing && !ioInterrupted) {
                    log.debug((Object)"Wating on a datagram to arrive");
                }
                this.m_dgSock.receive(pkt);
                ioInterrupted = false;
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
                continue;
            }
            catch (IOException e) {
                log.error((Object)"An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                break;
            }
            try {
                if (isTracing) {
                    log.debug((Object)"Sending received packet to processor");
                }
                UdpReceivedEvent re = UdpReceivedEvent.make(pkt);
                List list = this.m_eventsIn;
                synchronized (list) {
                    this.m_eventsIn.add(re);
                    this.m_eventsIn.notify();
                }
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"Failed to convert received XML event, discarding", (Throwable)e);
            }
            pkt = new DatagramPacket(buffer, 65535);
        }
        if (isTracing) {
            log.debug((Object)"Thread context exiting");
        }
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

