/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.SQLException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.Persist;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;

final class EventWriter
extends Persist {
    public EventWriter(String getNextEventIdStr) throws SQLException {
        this.m_getSvcIdStmt = this.m_dsConn.prepareStatement("SELECT serviceID FROM service WHERE serviceName = ?");
        this.m_getHostNameStmt = this.m_dsConn.prepareStatement("SELECT ipHostname FROM ipinterface WHERE ipAddr = ?");
        this.m_getNextIdStmt = this.m_dsConn.prepareStatement(getNextEventIdStr);
        this.m_insStmt = this.m_dsConn.prepareStatement("INSERT into events (eventID, eventUei, nodeID, eventTime, eventHost, ipAddr, eventDpName, eventSnmpHost, serviceID, eventSnmp, eventParms, eventCreateTime, eventDescr, eventLoggroup, eventLogmsg, eventLog, eventDisplay, eventSeverity, eventPathOutage, eventCorrelation, eventSuppressedCount, eventOperInstruct, eventAutoAction, eventOperAction, eventOperActionMenuText, eventNotification, eventTticket, eventTticketState, eventForward, eventMouseOverText, eventAckUser, eventAckTime, eventSource) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try {
            this.m_dsConn.setAutoCommit(false);
        }
        catch (SQLException se) {
            ThreadCategory.getInstance(EventWriter.class).warn((Object)"Unable to set auto commit mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.m_getSvcIdStmt.close();
            this.m_getHostNameStmt.close();
            this.m_getNextIdStmt.close();
            this.m_insStmt.close();
        }
        catch (SQLException sqle) {
            ThreadCategory.getInstance(EventWriter.class).warn((Object)"SQLException while closing prepared statements", (Throwable)sqle);
        }
        finally {
            super.close();
        }
    }

    public void persistEvent(Header eventHeader, Event event) throws SQLException {
        if (event != null) {
            Category log = ThreadCategory.getInstance(EventWriter.class);
            String logdest = event.getLogmsg().getDest();
            if (logdest.equals("donotpersist")) {
                log.debug((Object)("EventWriter: uei '" + event.getUei() + "' marked as 'doNotPersist'."));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("EventWriter dbRun for : " + event.getUei() + " nodeid: " + event.getNodeid() + " ipaddr: " + event.getInterface() + " serviceid: " + event.getService()));
            }
            try {
                this.insertEvent(eventHeader, event);
                this.m_dsConn.commit();
            }
            catch (SQLException e) {
                log.warn((Object)"Error inserting event into the datastore", (Throwable)e);
                try {
                    this.m_dsConn.rollback();
                }
                catch (Exception e2) {
                    log.warn((Object)"Rollback of transaction failed!", (Throwable)e2);
                }
                throw e;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("EventWriter finished for : " + event.getUei()));
            }
        }
    }
}

