/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.eventd.datablock.EventConfData;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;

public final class EventConfigurationManager {
    private static EventConfData m_eventConf;
    private static volatile boolean m_loaded;
    private static volatile String[] m_secureTags;

    public static boolean isConfigured() {
        return m_loaded;
    }

    public static void init() throws MarshalException, ValidationException, IOException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
        EventConfigurationManager.loadConfiguration(configFile.getPath());
    }

    public static void reload() throws MarshalException, ValidationException, IOException {
        EventConfigurationManager.init();
    }

    public static void loadConfiguration(String file) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(file);
        if (cfgIn == null) {
            throw new IOException("Failed to load/locate events conf file: " + file);
        }
        InputStreamReader rdr = new InputStreamReader(cfgIn);
        EventConfigurationManager.loadConfiguration(rdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfiguration(Reader rdr) throws IOException, MarshalException, ValidationException {
        Category log = ThreadCategory.getInstance();
        EventConfData eventConfData = m_eventConf;
        synchronized (eventConfData) {
            Events toplevel = null;
            toplevel = (Events)Unmarshaller.unmarshal(Events.class, (Reader)rdr);
            m_eventConf.clear();
            Enumeration e = toplevel.enumerateEvent();
            while (e.hasMoreElements()) {
                Event event = (Event)e.nextElement();
                m_eventConf.put(event);
            }
            m_secureTags = toplevel.getGlobal().getSecurity().getDoNotOverride();
            Enumeration e2 = toplevel.enumerateEventFile();
            while (e2.hasMoreElements()) {
                String eventfile = (String)e2.nextElement();
                FileInputStream fileIn = new FileInputStream(eventfile);
                if (fileIn == null) {
                    throw new IOException("Eventconf: Failed to load/locate events file: " + eventfile);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Eventconf: Loading event file: " + eventfile));
                }
                InputStreamReader filerdr = new InputStreamReader(fileIn);
                Events filelevel = null;
                filelevel = (Events)Unmarshaller.unmarshal(Events.class, (Reader)filerdr);
                Enumeration efile = filelevel.enumerateEvent();
                while (efile.hasMoreElements()) {
                    Event event = (Event)efile.nextElement();
                    m_eventConf.put(event);
                }
            }
            try {
                rdr.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        m_loaded = true;
    }

    public static void mergeConfiguration(String file) throws IOException, MarshalException, ValidationException {
        FileReader rdr = new FileReader(file);
        EventConfigurationManager.mergeConfiguration(rdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeConfiguration(Reader rdr) throws MarshalException, ValidationException {
        EventConfData eventConfData = m_eventConf;
        synchronized (eventConfData) {
            Events toplevel = null;
            toplevel = (Events)Unmarshaller.unmarshal(Events.class, (Reader)rdr);
            Enumeration e = toplevel.enumerateEvent();
            while (e.hasMoreElements()) {
                Event event = (Event)e.nextElement();
                m_eventConf.put(event);
            }
            m_secureTags = toplevel.getGlobal().getSecurity().getDoNotOverride();
            try {
                rdr.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        m_loaded = true;
    }

    public static Event getByUei(String uei) {
        return m_eventConf.getEventByUEI(uei);
    }

    public static Event get(org.opennms.netmgt.xml.event.Event event) {
        return m_eventConf.getEvent(event);
    }

    public static boolean isSecureTag(String name) {
        for (int i = 0; i < m_secureTags.length; ++i) {
            if (!m_secureTags[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    static {
        m_loaded = false;
        m_eventConf = new EventConfData();
    }
}

