/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.SQLException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.Persist;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;

final class AlarmWriter
extends Persist {
    public AlarmWriter(String getNextAlarmIdStr) throws SQLException {
        this.m_getSvcIdStmt = this.m_dsConn.prepareStatement("SELECT serviceID FROM service WHERE serviceName = ?");
        this.m_getHostNameStmt = this.m_dsConn.prepareStatement("SELECT ipHostname FROM ipinterface WHERE ipAddr = ?");
        this.m_getNextIdStmt = this.m_dsConn.prepareStatement(getNextAlarmIdStr);
        this.m_insStmt = this.m_dsConn.prepareStatement("INSERT  INTO alarms (alarmID, eventUei, dpName, nodeID, ipaddr,                serviceID, reductionKey, alarmType, counter, severity,                lastEventID, firstEventTime, lastEventTime, description, logMsg,                operInstruct, tticketID, tticketState, mouseOverText, suppressedUntil,                suppressedUser, suppressedTime, alarmAckUser, alarmAckTime, clearUei,                x733AlarmType, x733ProbableCause, clearKey) VALUES (?,?,?,?,?,        ?,?,?,?,?,        ?,?,?,        ?,?,?,?,        ?,?,?,        ?,?,?,?,?,        ?,?,?)");
        this.m_reductionQuery = this.m_dsConn.prepareStatement("SELECT alarmid   FROM alarms  WHERE reductionKey = ?");
        this.m_upDateStmt = this.m_dsConn.prepareStatement("UPDATE alarms    SET counter = counter+1, lastEventID = ?, lastEventTime = ?  WHERE reductionKey = ?");
        this.m_updateEventStmt = this.m_dsConn.prepareStatement("UPDATE events    SET alarmid = ?  WHERE eventid = ?");
        try {
            this.m_dsConn.setAutoCommit(false);
        }
        catch (SQLException se) {
            ThreadCategory.getInstance(AlarmWriter.class).warn((Object)"Unable to set auto commit mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.m_getSvcIdStmt.close();
            this.m_getHostNameStmt.close();
            this.m_getNextIdStmt.close();
            this.m_insStmt.close();
        }
        catch (SQLException sqle) {
            ThreadCategory.getInstance(AlarmWriter.class).warn((Object)"SQLException while closing prepared statements", (Throwable)sqle);
        }
        finally {
            super.close();
        }
    }

    public void persistAlarm(Header eventHeader, Event event) throws SQLException {
        if (event != null) {
            Category log = ThreadCategory.getInstance(AlarmWriter.class);
            String logdest = event.getLogmsg().getDest();
            if (logdest.equals("donotpersist") || event.getAlarmData() == null) {
                log.debug((Object)("AlarmWriter: uei '" + event.getUei() + "' marked as 'doNotPersist' or reductionKey is null."));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("AlarmWriter dbRun for : " + event.getUei() + " nodeid: " + event.getNodeid() + " ipaddr: " + event.getInterface() + " serviceid: " + event.getService()));
            }
            boolean notUpdated = true;
            for (int attempt = 1; attempt <= 2 && notUpdated; ++attempt) {
                try {
                    this.insertOrUpdateAlarm(eventHeader, event);
                    this.m_dsConn.commit();
                    notUpdated = false;
                    continue;
                }
                catch (SQLException e) {
                    try {
                        this.m_dsConn.rollback();
                        this.m_dsConn.setAutoCommit(false);
                    }
                    catch (Exception e2) {
                        log.warn((Object)"Rollback of transaction failed!", (Throwable)e2);
                    }
                    if (attempt > 1) {
                        log.warn((Object)("Error in attempt: " + attempt + " inserting alarm into the datastore"), (Throwable)e);
                        throw e;
                    }
                    log.info((Object)("Retrying insertOrUpdate statement after first attempt: " + e.getMessage()));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("AlarmWriter finished for : " + event.getUei()));
            }
        }
    }
}

