/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Category;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.discovery.DiscoveryPingResponseCallback;
import org.opennms.netmgt.discovery.IPPollAddress;
import org.opennms.netmgt.discovery.IPPollRange;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.netmgt.ping.Pinger;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Discovery
extends AbstractServiceDaemon
implements EventListener {
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';
    private static final Discovery m_singleton = new Discovery();
    private static final DiscoveryPingResponseCallback cb = new DiscoveryPingResponseCallback();
    private static final int PING_IDLE = 0;
    private static final int PING_RUNNING = 1;
    private static final int PING_FINISHING = 2;
    private Set<String> m_alreadyDiscovered = Collections.synchronizedSet(new HashSet());
    private Collection<ExcludeRange> m_excluded;
    private DiscoveryConfigFactory m_discoveryFactory;
    private DiscoveryConfiguration m_discoveryConfiguration;
    private Timer m_timer;
    private long initialSleepTime;
    private long discoveryInterval;
    private int m_xstatus = 0;

    private Discovery() {
        super("OpenNMS.Discovery");
    }

    @Override
    protected void onInit() {
        try {
            DataSourceFactory.init();
        }
        catch (Exception e) {
            this.log().fatal((Object)"Unable to initialize the database factory", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        this.initializeConfiguration();
        this.initialSleepTime = this.m_discoveryConfiguration.getInitialSleepTime();
        this.discoveryInterval = this.m_discoveryConfiguration.getRestartSleepTime();
        EventIpcManagerFactory.init();
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/internal/capsd/discPause");
        ueiList.add("uei.opennms.org/internal/capsd/discResume");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/internal/discoveryConfigChange");
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    private void initializeConfiguration() {
        try {
            DiscoveryConfiguration config;
            DiscoveryConfigFactory.reload();
            this.m_discoveryFactory = DiscoveryConfigFactory.getInstance();
            this.m_discoveryConfiguration = config = this.m_discoveryFactory.getConfiguration();
            this.m_excluded = Collections.synchronizedCollection(config.getExcludeRangeCollection());
        }
        catch (Exception e) {
            this.log().fatal((Object)"Unable to initialize the discovery configuration factory", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void doPings() {
        this.log().debug((Object)"starting ping sweep");
        this.initializeConfiguration();
        int pps = this.m_discoveryConfiguration.getPacketsPerSecond();
        List<IPPollAddress> specifics = this.getSpecifics();
        specifics.addAll(this.getUrlSpecifics());
        List<IPPollRange> ranges = this.getRanges();
        this.m_xstatus = 1;
        this.log().debug((Object)("checking " + specifics.size() + " specific IP addresses"));
        for (IPPollAddress address : specifics) {
            if (this.m_xstatus == 2 || this.m_timer == null) {
                this.m_xstatus = 0;
                return;
            }
            this.pingAddress(address.getAddress(), address.getTimeout(), address.getRetries(), cb);
        }
        this.log().debug((Object)("checking " + ranges.size() + " ranges"));
        block3: for (IPPollRange range : ranges) {
            for (InetAddress address : range.getAddressRange()) {
                if (this.m_xstatus == 2 || this.m_timer == null) {
                    this.m_xstatus = 0;
                    return;
                }
                if (this.isExcluded(address)) continue;
                this.pingAddress(address, range.getTimeout(), range.getRetries(), cb);
                try {
                    Thread.sleep(1000 / pps);
                }
                catch (InterruptedException e) {
                    continue block3;
                }
            }
        }
        this.log().debug((Object)"finished discovery sweep");
        this.m_xstatus = 0;
    }

    private boolean isExcluded(InetAddress address) {
        if (this.m_excluded != null) {
            long laddr = IPSorter.convertToLong((byte[])address.getAddress());
            for (ExcludeRange range : this.m_excluded) {
                try {
                    long begin = IPSorter.convertToLong((byte[])InetAddress.getByName(range.getBegin()).getAddress());
                    long end = IPSorter.convertToLong((byte[])InetAddress.getByName(range.getEnd()).getAddress());
                    if (begin > laddr || laddr > end) continue;
                    return true;
                }
                catch (UnknownHostException ex) {
                    this.log().debug((Object)"isExcluded: failed to convert exclusion address to InetAddress", (Throwable)ex);
                }
            }
        }
        return false;
    }

    private boolean isAlreadyDiscovered(InetAddress address) {
        return this.m_alreadyDiscovered.contains(address.getHostAddress());
    }

    protected void pingAddress(InetAddress address, long timeout, int retries, PingResponseCallback cb) {
        if (address != null && !this.isAlreadyDiscovered(address)) {
            try {
                Pinger.ping((InetAddress)address, (long)timeout, (int)retries, (short)1, (PingResponseCallback)cb);
            }
            catch (IOException e) {
                this.log().debug((Object)("error pinging " + address.getAddress()), (Throwable)e);
            }
        }
    }

    public static Discovery getInstance() {
        return m_singleton;
    }

    private void startTimer() {
        if (this.m_timer != null) {
            this.log().debug((Object)"startTimer() called, but a previous timer exists; making sure it's cleaned up");
            this.m_xstatus = 2;
            this.m_timer.cancel();
        }
        this.log().debug((Object)"scheduling new discovery timer");
        this.m_timer = new Timer("Discovery.Pinger", true);
        TimerTask task = new TimerTask(){

            public void run() {
                Discovery.this.doPings();
            }
        };
        this.m_timer.scheduleAtFixedRate(task, this.initialSleepTime, this.discoveryInterval);
    }

    private void stopTimer() {
        if (this.m_timer != null) {
            this.log().debug((Object)"stopping existing timer");
            this.m_xstatus = 2;
            this.m_timer.cancel();
            this.m_timer = null;
        } else {
            this.log().debug((Object)"stopTimer() called, but there is no existing timer");
        }
    }

    @Override
    protected void onStart() {
        this.startTimer();
    }

    @Override
    protected void onStop() {
        this.stopTimer();
    }

    @Override
    protected void onPause() {
        this.stopTimer();
    }

    @Override
    protected void onResume() {
        this.startTimer();
    }

    private List<IPPollAddress> getUrlSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        Enumeration urlEntries = this.m_discoveryConfiguration.enumerateIncludeUrl();
        while (urlEntries.hasMoreElements()) {
            IncludeUrl url = (IncludeUrl)urlEntries.nextElement();
            long timeout = 800L;
            if (url.hasTimeout()) {
                timeout = url.getTimeout();
            } else if (this.m_discoveryConfiguration.hasTimeout()) {
                timeout = this.m_discoveryConfiguration.getTimeout();
            }
            int retries = 3;
            if (url.hasRetries()) {
                retries = url.getRetries();
            } else if (this.m_discoveryConfiguration.hasRetries()) {
                retries = this.m_discoveryConfiguration.getRetries();
            }
            this.addToSpecificsFromURL(specifics, url.getContent(), timeout, retries);
        }
        return specifics;
    }

    private List<IPPollRange> getRanges() {
        LinkedList<IPPollRange> includes = new LinkedList<IPPollRange>();
        Enumeration includeRangeEntries = this.m_discoveryConfiguration.enumerateIncludeRange();
        while (includeRangeEntries.hasMoreElements()) {
            IncludeRange ir = (IncludeRange)includeRangeEntries.nextElement();
            long timeout = 800L;
            if (ir.hasTimeout()) {
                timeout = ir.getTimeout();
            } else if (this.m_discoveryConfiguration.hasTimeout()) {
                timeout = this.m_discoveryConfiguration.getTimeout();
            }
            int retries = 3;
            if (ir.hasRetries()) {
                retries = ir.getRetries();
            } else if (this.m_discoveryConfiguration.hasRetries()) {
                retries = this.m_discoveryConfiguration.getRetries();
            }
            try {
                includes.add(new IPPollRange(ir.getBegin(), ir.getEnd(), timeout, retries));
            }
            catch (UnknownHostException uhE) {
                this.log().warn((Object)("Failed to convert address range (" + ir.getBegin() + ", " + ir.getEnd() + ")"), (Throwable)uhE);
            }
        }
        return includes;
    }

    private List<IPPollAddress> getSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        Enumeration specificEntries = this.m_discoveryConfiguration.enumerateSpecific();
        while (specificEntries.hasMoreElements()) {
            Specific s = (Specific)specificEntries.nextElement();
            long timeout = 800L;
            if (s.hasTimeout()) {
                timeout = s.getTimeout();
            } else if (this.m_discoveryConfiguration.hasTimeout()) {
                timeout = this.m_discoveryConfiguration.getTimeout();
            }
            int retries = 3;
            if (s.hasRetries()) {
                retries = s.getRetries();
            } else if (this.m_discoveryConfiguration.hasRetries()) {
                retries = this.m_discoveryConfiguration.getRetries();
            }
            try {
                specifics.add(new IPPollAddress(s.getContent(), timeout, retries));
            }
            catch (UnknownHostException uhE) {
                this.log().warn((Object)("Failed to convert address " + s.getContent()), (Throwable)uhE);
            }
        }
        return specifics;
    }

    private boolean addToSpecificsFromURL(List<IPPollAddress> specifics, String url, long timeout, int retries) {
        boolean bRet;
        block10: {
            Category log = ThreadCategory.getInstance();
            bRet = true;
            try {
                URL fileURL = new URL(url);
                InputStream is = fileURL.openStream();
                if (is != null) {
                    BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
                    String ipLine = null;
                    String specIP = null;
                    while ((ipLine = buffer.readLine()) != null) {
                        if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                        int comIndex = ipLine.indexOf(COMMENT_STR);
                        if (comIndex == -1) {
                            specIP = ipLine;
                        } else {
                            specIP = ipLine.substring(0, comIndex);
                            ipLine = ipLine.trim();
                        }
                        try {
                            specifics.add(new IPPollAddress(specIP, timeout, retries));
                        }
                        catch (UnknownHostException e) {
                            log.warn((Object)("Unknown host '" + specIP + "' read from URL '" + url.toString() + "': address ignored"));
                        }
                        specIP = null;
                    }
                    buffer.close();
                    break block10;
                }
                log.warn((Object)("URL does not exist: " + url.toString()));
                bRet = true;
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
            catch (IOException e) {
                log.error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
                bRet = false;
            }
        }
        return bRet;
    }

    @Override
    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface")) {
            this.m_alreadyDiscovered.add(event.getInterface());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added " + event.getInterface() + " as discovered"));
            }
        } else if (eventUei.equals("uei.opennms.org/internal/capsd/discPause")) {
            try {
                Discovery.getInstance().pause();
            }
            catch (IllegalStateException ex) {}
        } else if (eventUei.equals("uei.opennms.org/internal/capsd/discResume")) {
            try {
                Discovery.getInstance().resume();
            }
            catch (IllegalStateException ex) {}
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            this.m_alreadyDiscovered.remove(event.getInterface());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + event.getInterface() + " from known node list"));
            }
        } else if (eventUei.equals("uei.opennms.org/internal/discoveryConfigChange")) {
            this.initializeConfiguration();
            this.stop();
            this.start();
        }
    }
}

