/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.config.viewsdisplay.Viewinfo;

public class ViewsDisplayFactory {
    private static ViewsDisplayFactory m_instance;
    protected File m_viewsDisplayFile;
    protected boolean initialized = false;
    protected long m_lastModified;
    protected Map<String, View> m_viewsMap;
    private Viewinfo m_viewInfo;

    private ViewsDisplayFactory() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        this.reload();
    }

    public ViewsDisplayFactory(String file) throws MarshalException, ValidationException, FileNotFoundException, IOException {
        this.setViewsDisplayFile(new File(file));
        this.reload();
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            ViewsDisplayFactory.setInstance(new ViewsDisplayFactory());
        }
    }

    public static synchronized ViewsDisplayFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call ViewDisplay.init() before calling getInstance().");
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        Reader reader = this.getReader();
        try {
            this.unmarshal(reader);
        }
        finally {
            reader.close();
        }
    }

    private void unmarshal(Reader reader) throws MarshalException, ValidationException {
        this.m_viewInfo = (Viewinfo)Unmarshaller.unmarshal(Viewinfo.class, (Reader)reader);
        HashMap<String, View> viewsMap = new HashMap<String, View>();
        ArrayList viewList = this.m_viewInfo.getViewCollection();
        for (View view : viewList) {
            viewsMap.put(view.getViewName(), view);
        }
        this.m_viewsMap = viewsMap;
    }

    private Reader getReader() throws IOException, FileNotFoundException {
        File viewsDisplayFile = this.getViewsDisplayFile();
        FileReader reader = new FileReader(viewsDisplayFile);
        this.m_lastModified = this.m_viewsDisplayFile.lastModified();
        return reader;
    }

    public void setViewsDisplayFile(File viewsDisplayFile) {
        this.m_viewsDisplayFile = viewsDisplayFile;
    }

    public File getViewsDisplayFile() throws IOException {
        if (this.m_viewsDisplayFile == null) {
            this.m_viewsDisplayFile = ConfigFileConstants.getFile((int)ConfigFileConstants.VIEWS_DISPLAY_CONF_FILE_NAME);
        }
        return this.m_viewsDisplayFile;
    }

    public View getView(String viewName) throws IOException, MarshalException, ValidationException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.updateFromFile();
        View view = this.m_viewsMap.get(viewName);
        return view;
    }

    public View getDefaultView() {
        return this.m_viewsMap.get(this.m_viewInfo.getDefaultView());
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_viewsDisplayFile.lastModified()) {
            this.reload();
        }
    }

    public static void setInstance(ViewsDisplayFactory instance) {
        m_instance = instance;
        ViewsDisplayFactory.m_instance.initialized = true;
    }

    public int getDisconnectTimeout() {
        return this.m_viewInfo.getDisconnectTimeout();
    }
}

