/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.PeerFactory;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.protocols.ip.IPv4Address;

public final class SnmpPeerFactory
extends PeerFactory {
    private static SnmpPeerFactory m_singleton = null;
    private static SnmpConfig m_config;
    private static boolean m_loaded;
    private static final int VERSION_UNSPECIFIED = -1;

    private SnmpPeerFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        m_config = (SnmpConfig)Unmarshaller.unmarshal(SnmpConfig.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public SnmpPeerFactory(Reader rdr) throws IOException, MarshalException, ValidationException {
        m_config = (SnmpConfig)Unmarshaller.unmarshal(SnmpConfig.class, (Reader)rdr);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME);
        SnmpPeerFactory.log().debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new SnmpPeerFactory(cfgFile.getPath());
        m_loaded = true;
    }

    private static Category log() {
        return ThreadCategory.getInstance(SnmpPeerFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        SnmpPeerFactory.init();
    }

    public static synchronized void saveCurrent() throws Exception {
        String marshalledConfig = SnmpPeerFactory.marshallConfig();
        if (marshalledConfig != null) {
            FileWriter fileWriter = new FileWriter(ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME));
            fileWriter.write(marshalledConfig);
            fileWriter.flush();
            fileWriter.close();
        }
        SnmpPeerFactory.reload();
    }

    public static synchronized SnmpPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(SnmpPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public void define(InetAddress ip, String community) throws UnknownHostException {
        Category log = SnmpPeerFactory.log();
        int address = new IPv4Address(ip).getAddress();
        ArrayList<Definition> definitions = new ArrayList<Definition>(m_config.getDefinitionCollection());
        Definition definition = null;
        for (Definition currentDefinition : definitions) {
            if ((currentDefinition.getReadCommunity() == null || !currentDefinition.getReadCommunity().equals(community)) && (currentDefinition.getReadCommunity() != null || m_config.getReadCommunity() == null || !m_config.getReadCommunity().equals(community))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("define: Found existing definition with read-community " + community));
            }
            definition = currentDefinition;
            break;
        }
        if (definition == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"define: Creating new definition");
            }
            definition = new Definition();
            definition.setReadCommunity(community);
            definitions.add(definition);
        }
        definition.addSpecific(ip.getHostAddress());
        for (Definition currentDefinition : definitions) {
            if (currentDefinition == definition) continue;
            while (currentDefinition.removeSpecific(ip.getHostAddress())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("define: Removed an existing specific element with IP " + ip));
            }
            ArrayList<Range> ranges = new ArrayList<Range>(currentDefinition.getRangeCollection());
            Range[] rangesArray = currentDefinition.getRange();
            for (int rangesArrayIndex = 0; rangesArrayIndex < rangesArray.length; ++rangesArrayIndex) {
                Range range = rangesArray[rangesArrayIndex];
                int begin = new IPv4Address(range.getBegin()).getAddress();
                int end = new IPv4Address(range.getEnd()).getAddress();
                if (address < begin || address > end) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("define: Splitting range element with begin " + range.getBegin() + " and " + "end " + range.getEnd()));
                }
                if (begin == end) {
                    ranges.remove(range);
                    continue;
                }
                if (address == begin) {
                    range.setBegin(IPv4Address.addressToString((int)(address + 1)));
                    continue;
                }
                if (address == end) {
                    range.setEnd(IPv4Address.addressToString((int)(address - 1)));
                    continue;
                }
                Range head = new Range();
                head.setBegin(range.getBegin());
                head.setEnd(IPv4Address.addressToString((int)(address - 1)));
                Range tail = new Range();
                tail.setBegin(IPv4Address.addressToString((int)(address + 1)));
                tail.setEnd(range.getEnd());
                ranges.remove(range);
                ranges.add(head);
                ranges.add(tail);
            }
            currentDefinition.setRangeCollection(ranges);
        }
        m_config.setDefinitionCollection(definitions);
    }

    public synchronized SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, -1);
    }

    public synchronized SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        Definition def;
        if (m_config == null) {
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            if (requestedSnmpVersion == -1) {
                agentConfig.setVersion(1);
            } else {
                agentConfig.setVersion(requestedSnmpVersion);
            }
            return agentConfig;
        }
        SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
        this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
        Enumeration edef = m_config.enumerateDefinition();
        block4: while (edef.hasMoreElements()) {
            def = (Definition)edef.nextElement();
            Enumeration espec = def.enumerateSpecific();
            while (espec.hasMoreElements()) {
                String saddr = ((String)espec.nextElement()).trim();
                try {
                    InetAddress addr = InetAddress.getByName(saddr);
                    if (!addr.equals(agentConfig.getAddress())) continue;
                    this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                    break block4;
                }
                catch (UnknownHostException e) {
                    Category log = ThreadCategory.getInstance(this.getClass());
                    log.warn((Object)("SnmpPeerFactory: could not convert host " + saddr + " to InetAddress"), (Throwable)e);
                }
            }
            long lhost = SnmpPeerFactory.toLong(agentConfig.getAddress());
            Enumeration erange = def.enumerateRange();
            while (erange.hasMoreElements()) {
                Range rng = (Range)erange.nextElement();
                try {
                    InetAddress begin = InetAddress.getByName(rng.getBegin());
                    InetAddress end = InetAddress.getByName(rng.getEnd());
                    long start = SnmpPeerFactory.toLong(begin);
                    long stop = SnmpPeerFactory.toLong(end);
                    if (start > lhost || lhost > stop) continue;
                    this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                    break block4;
                }
                catch (UnknownHostException e) {
                    Category log = ThreadCategory.getInstance(this.getClass());
                    log.warn((Object)("SnmpPeerFactory: could not convert host(s) " + rng.getBegin() + " - " + rng.getEnd() + " to InetAddress"), (Throwable)e);
                }
            }
            Enumeration eMatch = def.enumerateIpMatch();
            while (eMatch.hasMoreElements()) {
                String ipMatch = (String)eMatch.nextElement();
                if (!SnmpPeerFactory.verifyIpMatch(agentInetAddress.getHostAddress(), ipMatch)) continue;
                this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
                break block4;
            }
        }
        if (agentConfig == null) {
            def = new Definition();
            this.setSnmpAgentConfig(agentConfig, def, requestedSnmpVersion);
        }
        return agentConfig;
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.determineVersion(def, requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(this.determineSecurityLevel(def));
        agentConfig.setSecurityName(this.determineSecurityName(def));
        agentConfig.setAuthProtocol(this.determineAuthProtocol(def));
        agentConfig.setAuthPassPhrase(this.determineAuthPassPhrase(def));
        agentConfig.setPrivPassPhrase(this.determinePrivPassPhrase(def));
        agentConfig.setPrivProtocol(this.determinePrivProtocol(def));
        agentConfig.setReadCommunity(this.determineReadCommunity(def));
        agentConfig.setWriteCommunity(this.determineWriteCommunity(def));
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(this.determinePort(def));
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setMaxRequestSize(this.determineMaxRequestSize(def));
        agentConfig.setMaxVarsPerPdu(this.determineMaxVarsPerPdu(def));
        agentConfig.setMaxRepetitions(this.determineMaxRepetitions(def));
        InetAddress proxyHost = this.determineProxyHost(def);
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(this.determineProxyHost(def));
        }
    }

    private int determineMaxRepetitions(Definition def) {
        return def.getMaxRepetitions() == 0 ? (m_config.getMaxRepetitions() == 0 ? 2 : m_config.getMaxRepetitions()) : def.getMaxRepetitions();
    }

    private InetAddress determineProxyHost(Definition def) {
        String address;
        InetAddress inetAddr = null;
        Object object = def.getProxyHost() == null ? (m_config.getProxyHost() == null ? null : m_config.getProxyHost()) : (address = def.getProxyHost());
        if (address != null) {
            try {
                inetAddr = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                SnmpPeerFactory.log().error((Object)"determineProxyHost: Problem converting proxy host string to InetAddress", (Throwable)e);
            }
        }
        return inetAddr;
    }

    private int determineMaxVarsPerPdu(Definition def) {
        return def.getMaxVarsPerPdu() == 0 ? (m_config.getMaxVarsPerPdu() == 0 ? 10 : m_config.getMaxVarsPerPdu()) : def.getMaxVarsPerPdu();
    }

    private String determineReadCommunity(Definition def) {
        return def.getReadCommunity() == null ? (m_config.getReadCommunity() == null ? "public" : m_config.getReadCommunity()) : def.getReadCommunity();
    }

    private String determineWriteCommunity(Definition def) {
        return def.getWriteCommunity() == null ? (m_config.getWriteCommunity() == null ? "private" : m_config.getWriteCommunity()) : def.getWriteCommunity();
    }

    private int determineMaxRequestSize(Definition def) {
        return def.getMaxRequestSize() == 0 ? (m_config.getMaxRequestSize() == 0 ? 65535 : m_config.getMaxRequestSize()) : def.getMaxRequestSize();
    }

    private String determineSecurityName(Definition def) {
        String securityName;
        String string = securityName = def.getSecurityName() == null ? m_config.getSecurityName() : def.getSecurityName();
        if (securityName == null) {
            securityName = "opennmsUser";
        }
        return securityName;
    }

    private String determineAuthProtocol(Definition def) {
        String authProtocol;
        String string = authProtocol = def.getAuthProtocol() == null ? m_config.getAuthProtocol() : def.getAuthProtocol();
        if (authProtocol == null) {
            authProtocol = "MD5";
        }
        return authProtocol;
    }

    private String determineAuthPassPhrase(Definition def) {
        String authPassPhrase;
        String string = authPassPhrase = def.getAuthPassphrase() == null ? m_config.getAuthPassphrase() : def.getAuthPassphrase();
        if (authPassPhrase == null) {
            authPassPhrase = "0p3nNMSv3";
        }
        return authPassPhrase;
    }

    private String determinePrivPassPhrase(Definition def) {
        String privPassPhrase;
        String string = privPassPhrase = def.getPrivacyPassphrase() == null ? m_config.getPrivacyPassphrase() : def.getPrivacyPassphrase();
        if (privPassPhrase == null) {
            privPassPhrase = "0p3nNMSv3";
        }
        return privPassPhrase;
    }

    private String determinePrivProtocol(Definition def) {
        String authPrivProtocol;
        String string = authPrivProtocol = def.getPrivacyProtocol() == null ? m_config.getPrivacyProtocol() : def.getPrivacyProtocol();
        if (authPrivProtocol == null) {
            authPrivProtocol = "DES";
        }
        return authPrivProtocol;
    }

    private int determineSecurityLevel(Definition def) {
        String privPassPhrase;
        int securityLevel = 1;
        String authPassPhrase = def.getAuthPassphrase() == null ? m_config.getAuthPassphrase() : def.getAuthPassphrase();
        String string = privPassPhrase = def.getPrivacyPassphrase() == null ? m_config.getPrivacyPassphrase() : def.getPrivacyPassphrase();
        securityLevel = authPassPhrase == null ? 1 : (privPassPhrase == null ? 2 : 3);
        return securityLevel;
    }

    private int determinePort(Definition def) {
        int port = 161;
        return def.getPort() == 0 ? (m_config.getPort() == 0 ? port : m_config.getPort()) : def.getPort();
    }

    private long determineTimeout(Definition def) {
        long timeout = 3000L;
        return def.getTimeout() == 0 ? (m_config.getTimeout() == 0 ? timeout : (long)m_config.getTimeout()) : (long)def.getTimeout();
    }

    private int determineRetries(Definition def) {
        int retries = 1;
        return def.getRetry() == 0 ? (m_config.getRetry() == 0 ? retries : m_config.getRetry()) : def.getRetry();
    }

    private int determineVersion(Definition def, int requestedSnmpVersion) {
        int version = 1;
        String cfgVersion = "v1";
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (m_config.getVersion() == null) {
                    return version;
                }
                cfgVersion = m_config.getVersion();
            } else {
                cfgVersion = def.getVersion();
            }
        } else {
            return requestedSnmpVersion;
        }
        if (cfgVersion.equals("v1")) {
            version = 1;
        } else if (cfgVersion.equals("v2c")) {
            version = 2;
        } else if (cfgVersion.equals("v3")) {
            version = 3;
        }
        return version;
    }

    public static synchronized SnmpConfig getSnmpConfig() {
        return m_config;
    }

    public static synchronized void setSnmpConfig(SnmpConfig m_config) {
        SnmpPeerFactory.m_config = m_config;
    }

    public static String toIpAddr(long ip) {
        StringBuffer sb = new StringBuffer(15);
        for (int shift = 24; shift > 0; shift -= 8) {
            sb.append(Long.toString(ip >>> shift & 0xFFL));
            sb.append('.');
        }
        sb.append(Long.toString(ip & 0xFFL));
        return sb.toString();
    }

    public synchronized void define(SnmpEventInfo info) throws UnknownHostException {
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        mgr.mergeIntoConfig(info.createDef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String marshallConfig() {
        String marshalledConfig = null;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            Marshaller.marshal((Object)m_config, (Writer)writer);
            marshalledConfig = writer.toString();
        }
        catch (MarshalException e) {
            SnmpPeerFactory.log().error((Object)"marshallConfig: Error marshalling configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            SnmpPeerFactory.log().error((Object)"marshallConfig: Error validating configuration", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                SnmpPeerFactory.log().error((Object)"marshallConfig: I/O Error closing string writer!", (Throwable)e);
            }
        }
        return marshalledConfig;
    }

    static {
        m_loaded = false;
    }
}

