/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.nsclient.NsclientCollection;
import org.opennms.netmgt.config.nsclient.NsclientDatacollectionConfig;
import org.opennms.netmgt.model.RrdRepository;

public class NSClientDataCollectionConfigFactory {
    private static NSClientDataCollectionConfigFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    private static NsclientDatacollectionConfig m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSClientDataCollectionConfigFactory(String configFile) throws MarshalException, ValidationException, IOException {
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(configFile));
        try {
            this.initialize(rdr);
        }
        finally {
            rdr.close();
        }
    }

    public NSClientDataCollectionConfigFactory(Reader rdr) throws MarshalException, ValidationException {
        this.initialize(rdr);
    }

    private void initialize(Reader rdr) throws MarshalException, ValidationException {
        this.log().debug((Object)"initialize: initializing NSCLient collection config factory.");
        m_config = (NsclientDatacollectionConfig)Unmarshaller.unmarshal(NsclientDatacollectionConfig.class, (Reader)rdr);
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_COLLECTION_CONFIG_FILE_NAME);
            m_instance = new NSClientDataCollectionConfigFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized NSClientDataCollectionConfigFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call NSClientCollectionConfigFactory.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(NSClientDataCollectionConfigFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        NSClientDataCollectionConfigFactory.init();
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        File surveillanceViewsFile;
        if (m_loadedFromFile && m_lastModified != (surveillanceViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_COLLECTION_CONFIG_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized NsclientDatacollectionConfig getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(NsclientDatacollectionConfig m_config) {
        NSClientDataCollectionConfigFactory.m_config = m_config;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    public NsclientCollection getNSClientCollection(String collectionName) {
        NsclientCollection coll;
        NsclientCollection[] collections = m_config.getNsclientCollection();
        NsclientCollection collection = null;
        int i$ = 0;
        NsclientCollection[] arr$ = collections;
        int len$ = arr$.length;
        if (i$ < len$ && (coll = arr$[i$]).getName().equalsIgnoreCase(collectionName)) {
            collection = coll;
        }
        if (collection == null) {
            throw new IllegalArgumentException("getNSClientCollection: collection name: " + collectionName + " specified in collectd configuration not found in nsclient collection configuration.");
        }
        return collection;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    public int getStep(String cName) {
        NsclientCollection collection = this.getNSClientCollection(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    public List getRRAList(String cName) {
        NsclientCollection collection = this.getNSClientCollection(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    public String getRrdPath() {
        String rrdPath = m_config.getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }

    static {
        m_loadedFromFile = false;
    }
}

