/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.MergeableRange;
import org.opennms.netmgt.config.MergeableSpecific;
import org.opennms.netmgt.config.RangeComparator;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.SpecificComparator;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.config.snmp.Definition;

final class MergeableDefinition {
    private final Definition m_snmpConfigDef;

    public MergeableDefinition(Definition def) {
        this.m_snmpConfigDef = def;
    }

    public boolean equals(Definition def) {
        boolean compares = false;
        Definition matchingDef = def;
        if (this.compareStrings(this.getConfigDef().getReadCommunity(), matchingDef.getReadCommunity()) && this.compareStrings(this.getConfigDef().getVersion(), matchingDef.getVersion()) && this.getConfigDef().getPort() == matchingDef.getPort() && this.getConfigDef().getRetry() == matchingDef.getRetry() && this.getConfigDef().getTimeout() == matchingDef.getTimeout() && this.compareStrings(this.getConfigDef().getVersion(), matchingDef.getVersion())) {
            compares = true;
        }
        return compares;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj == null) {
            equals = false;
        } else if (obj instanceof Definition) {
            equals = this.equals((Definition)obj);
        }
        return equals;
    }

    public int hashCode() {
        return 0;
    }

    protected void mergeMatchingAttributeDef(Definition eventDef) {
        if (this.defIsSpecific(eventDef)) {
            this.handleSpecificMerge(eventDef);
        } else {
            this.handleRangeMerge(eventDef);
        }
    }

    public boolean isSpecific() {
        boolean specific = false;
        if (this.getConfigDef().getRangeCount() == 0) {
            specific = true;
        }
        return specific;
    }

    public boolean defIsSpecific(Definition eventDef) {
        boolean specificDef = false;
        if (eventDef.getRangeCount() == 0) {
            specificDef = true;
        }
        return specificDef;
    }

    private void handleSpecificMerge(Definition eventDef) {
        if (this.hasRangeMatchingSpecific(eventDef.getSpecific(0))) {
            this.log().error((Object)("handleSpecificMerge: definition already contains a range that matches requested SNMP specific change: " + this));
        } else if (this.hasMatchingSpecific(eventDef.getSpecific(0))) {
            this.log().error((Object)("handleSpecificMerge: definition already contains a specific that matches requested SNMP specific change: " + this));
        } else {
            this.getConfigDef().addSpecific(eventDef.getSpecific(0));
            this.sortSpecifics();
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void handleRangeMerge(Definition eventDef) {
        while (this.hasSpecificMatchingNewRange(eventDef.getRange(0))) {
            String spec = this.findSpecificMatchingNewRange(eventDef.getRange(0));
            this.getConfigDef().removeSpecific(spec);
        }
        this.mergeNewRangeIntoDef(eventDef.getRange(0));
    }

    public boolean hasMatchingSpecific(String specific) {
        boolean specificMatches = false;
        Enumeration specEnum = this.getConfigDef().enumerateSpecific();
        while (specEnum.hasMoreElements()) {
            String defSpecific = (String)specEnum.nextElement();
            if (!defSpecific.equals(specific)) continue;
            specificMatches = true;
            break;
        }
        return specificMatches;
    }

    public boolean hasRangeMatchingSpecific(String specific) {
        return this.findRangeMatchingSpecific(specific) != null;
    }

    public Range findRangeMatchingSpecific(String specific) {
        Range matchingRange = null;
        Enumeration erange = this.getConfigDef().enumerateRange();
        while (erange.hasMoreElements()) {
            MergeableRange range = new MergeableRange((Range)erange.nextElement());
            if (!range.coversSpecific(specific)) continue;
            matchingRange = range.getRange();
            break;
        }
        return matchingRange;
    }

    public void mergeNewRangeIntoDef(Range newRange) {
        this.purgeEclipsedRangesInDef(newRange);
        if (this.getConfigDef().getRangeCount() == 0) {
            this.getConfigDef().addRange(newRange);
        } else {
            boolean overlapped = this.mergeOverlappingRanges(newRange);
            if (!overlapped) {
                this.getConfigDef().addRange(newRange);
            }
        }
    }

    public void purgeEclipsedRangesInDef(Range range) {
        Range[] ranges = this.getConfigDef().getRange();
        MergeableRange newRange = new MergeableRange(range);
        for (int i = 0; i < ranges.length; ++i) {
            Range rng = ranges[i];
            if (!newRange.eclipses(rng)) continue;
            this.getConfigDef().removeRange(rng);
        }
    }

    public boolean mergeOverlappingRanges(Range range) {
        boolean overlapped = false;
        this.sortRanges();
        MergeableRange newRange = new MergeableRange(range);
        Range[] ranges = this.getConfigDef().getRange();
        for (int i = 0; i < ranges.length; ++i) {
            Range defRange = ranges[i];
            if (newRange.equals(defRange)) {
                overlapped = true;
                continue;
            }
            if (newRange.overlapsBegin(defRange)) {
                defRange.setBegin(newRange.getRange().getBegin());
                overlapped = true;
                continue;
            }
            if (newRange.overlapsEnd(defRange)) {
                defRange.setEnd(newRange.getRange().getEnd());
                overlapped = true;
                continue;
            }
            if (!newRange.eclipses(defRange)) continue;
            defRange.setBegin(newRange.getRange().getBegin());
            defRange.setEnd(newRange.getRange().getEnd());
            overlapped = true;
        }
        this.sortRanges();
        return overlapped;
    }

    public void sortSpecifics() {
        String[] specifics = this.getConfigDef().getSpecific();
        Arrays.sort(specifics, new SpecificComparator());
        this.getConfigDef().setSpecific(specifics);
    }

    public void sortRanges() {
        Range[] ranges = this.getConfigDef().getRange();
        Arrays.sort(ranges, new RangeComparator());
        this.getConfigDef().setRange(ranges);
    }

    public boolean hasSpecificMatchingNewRange(Range eventRange) {
        return this.findSpecificMatchingNewRange(eventRange) != null;
    }

    public String findSpecificMatchingNewRange(Range eventRange) {
        String matchingSpecific = null;
        Enumeration specEnum = this.getConfigDef().enumerateSpecific();
        while (specEnum.hasMoreElements()) {
            MergeableRange range = new MergeableRange(eventRange);
            String spec = (String)specEnum.nextElement();
            if (!range.coversSpecific(spec)) continue;
            matchingSpecific = spec;
            break;
        }
        return matchingSpecific;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Definition getConfigDef() {
        Definition definition = this.m_snmpConfigDef;
        synchronized (definition) {
            return this.m_snmpConfigDef;
        }
    }

    private final boolean compareStrings(String str1, String str2) {
        boolean match = false;
        if (str1 == null && str2 == null) {
            match = true;
        } else if (str1 == null || str2 == null) {
            match = false;
        } else if (str1.equals(str2)) {
            match = true;
        }
        return match;
    }

    public void purgeSpecificFromDef(String specific) {
        String[] specs = this.getConfigDef().getSpecific();
        for (int i = 0; i < specs.length; ++i) {
            String spec = specs[i];
            if (!spec.equals(specific)) continue;
            this.getConfigDef().removeSpecific(spec);
        }
        Range[] ranges = this.getConfigDef().getRange();
        for (int i = 0; i < ranges.length; ++i) {
            Range newRange;
            MergeableRange range = new MergeableRange(ranges[i]);
            if (!range.coversSpecific(specific) || (newRange = range.removeSpecificFromRange(specific)) == null) continue;
            this.getConfigDef().addRange(newRange);
        }
    }

    public void optimizeSpecifics() {
        this.adjustRangesWithAdjacentSpecifics();
        this.removeSpecificsEclipsedByRanges();
        this.convertAdjacentSpecficsIntoRange();
    }

    private void adjustRangesWithAdjacentSpecifics() {
        this.sortSpecifics();
        this.sortRanges();
        String[] specifics = this.getConfigDef().getSpecific();
        for (int i = 0; i < specifics.length; ++i) {
            MergeableSpecific specific = new MergeableSpecific(specifics[i]);
            for (Range range : this.getConfigDef().getRangeCollection()) {
                if (specific.compareTo(range.getBegin()) == -1) {
                    this.getConfigDef().removeSpecific(specific.getSpecific());
                    range.setBegin(specific.getSpecific());
                    continue;
                }
                if (specific.compareTo(range.getEnd()) != 1) continue;
                this.getConfigDef().removeSpecific(specific.getSpecific());
                range.setEnd(specific.getSpecific());
            }
        }
        this.sortSpecifics();
        this.sortRanges();
    }

    private void removeSpecificsEclipsedByRanges() {
        this.sortSpecifics();
        String[] specifics = this.getConfigDef().getSpecific();
        for (int i = 0; i < specifics.length; ++i) {
            String specific = specifics[i];
            if (!this.hasRangeMatchingSpecific(specific)) continue;
            this.getConfigDef().removeSpecific(specific);
        }
        this.sortSpecifics();
    }

    private void convertAdjacentSpecficsIntoRange() {
        this.sortSpecifics();
        ArrayList specificList = new ArrayList(new LinkedHashSet(this.getConfigDef().getSpecificCollection()));
        List<Range> definedRanges = Arrays.asList(this.getConfigDef().getRange());
        ArrayList<Range> newRanges = new ArrayList<Range>();
        if (specificList.size() > 1) {
            ListIterator it = specificList.listIterator();
            while (it.hasNext()) {
                MergeableSpecific specific = new MergeableSpecific((String)it.next());
                Range newRange = new Range();
                newRange.setBegin(specific.getSpecific());
                while (it.hasNext()) {
                    String nextSpecific = (String)it.next();
                    if (specific.compareTo(nextSpecific) == -1) {
                        newRange.setEnd(nextSpecific);
                        this.getConfigDef().removeSpecific(specific.getSpecific());
                        this.getConfigDef().removeSpecific(nextSpecific);
                        specific.setSpecific(nextSpecific);
                        continue;
                    }
                    it.previous();
                    break;
                }
                if (newRange.getEnd() == null) continue;
                newRanges.add(newRange);
            }
            newRanges.addAll(definedRanges);
            this.getConfigDef().setRangeCollection(newRanges);
            this.sortRanges();
        }
    }

    public void purgeRangeFromDef(Range eventRange) {
        MergeableRange range = new MergeableRange(eventRange);
        this.sortSpecifics();
        String[] specs = this.getConfigDef().getSpecific();
        for (int i = 0; i < specs.length; ++i) {
            String spec = specs[i];
            if (!range.coversSpecific(spec)) continue;
            this.getConfigDef().removeSpecific(spec);
        }
        this.sortRanges();
        Range[] ranges = this.getConfigDef().getRange();
        for (int i = 0; i < ranges.length; ++i) {
            Range defRng = ranges[i];
            if (range.eclipses(defRng)) {
                this.getConfigDef().removeRange(defRng);
                continue;
            }
            if (range.withInRange(defRng)) {
                Range newRange = new Range();
                newRange.setBegin(SnmpPeerFactory.toIpAddr(range.getLast().getValue() + 1L));
                newRange.setEnd(defRng.getEnd());
                this.getConfigDef().addRange(newRange);
                defRng.setEnd(SnmpPeerFactory.toIpAddr(range.getFirst().getValue() - 1L));
                continue;
            }
            if (range.overlapsBegin(defRng)) {
                defRng.setBegin(SnmpPeerFactory.toIpAddr(range.getLast().getValue() + 1L));
                continue;
            }
            if (!range.overlapsEnd(defRng)) continue;
            defRng.setEnd(SnmpPeerFactory.toIpAddr(range.getFirst().getValue() - 1L));
        }
    }

    public void optimizeRanges() {
        this.sortRanges();
        Range[] ranges = this.getConfigDef().getRange();
        for (int i = 0; i < ranges.length - 1; ++i) {
            Range firstRange = ranges[i];
            Range nextRange = ranges[i + 1];
            this.optimizeAdjacentRanges(firstRange, nextRange);
        }
        this.optimizeZeroLengthRanges();
    }

    public void optimizeZeroLengthRanges() {
        Range[] ranges = this.getConfigDef().getRange();
        for (int i = 0; i < ranges.length; ++i) {
            Range range = ranges[i];
            if (!range.getBegin().equals(range.getEnd())) continue;
            if (!this.hasMatchingSpecific(range.getBegin())) {
                this.getConfigDef().addSpecific(range.getBegin());
            }
            this.getConfigDef().removeRange(range);
        }
    }

    private void optimizeAdjacentRanges(Range previousRange, Range nextRange) {
        MergeableRange range = new MergeableRange(previousRange);
        if (range.equals(nextRange)) {
            this.getConfigDef().removeRange(previousRange);
        } else if (range.eclipses(nextRange)) {
            nextRange.setBegin(previousRange.getBegin());
            nextRange.setEnd(previousRange.getEnd());
            this.getConfigDef().removeRange(previousRange);
        } else if (range.isAdjacentToBegin(nextRange) || range.overlapsBegin(nextRange)) {
            nextRange.setBegin(previousRange.getBegin());
            this.getConfigDef().removeRange(previousRange);
        } else if (range.isAdjacentToEnd(nextRange) || range.overlapsEnd(nextRange)) {
            nextRange.setEnd(previousRange.getEnd());
            this.getConfigDef().removeRange(previousRange);
        }
    }
}

