/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.config.kscReports.ReportsList;

public class KSC_PerformanceReportFactory {
    private static KSC_PerformanceReportFactory instance;
    private static File KSC_PerformanceReportFile;
    private static ReportsList m_config;
    private static InputStream configIn;
    private static boolean initialized;
    private static long m_lastModified;
    public final String[] timespan_options = new String[]{"1_hour", "2_hour", "4_hour", "8_hour", "1_day", "2_day", "7_day", "1_month", "6_month", "1_year", "Today", "Yesterday", "This Week", "Last Week", "This Month", "Last Month", "This Quarter", "Last Quarter", "This Year", "Last Year"};
    private Report working_report = null;
    private int working_index = -1;
    private Graph working_graph = null;
    private int graph_index = -1;

    private KSC_PerformanceReportFactory() {
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (instance == null) {
            instance = new KSC_PerformanceReportFactory();
            KSC_PerformanceReportFactory.reload();
            initialized = true;
        }
    }

    public static synchronized KSC_PerformanceReportFactory getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("KSC_PerformanceReportFactory.init() must be called before KSC_PerformanceReportFactory.getInstance().");
        }
        return instance;
    }

    public static synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        KSC_PerformanceReportFile = ConfigFileConstants.getFile((int)ConfigFileConstants.KSC_REPORT_FILE_NAME);
        FileInputStream configIn = new FileInputStream(KSC_PerformanceReportFile);
        m_lastModified = KSC_PerformanceReportFile.lastModified();
        m_config = (ReportsList)Unmarshaller.unmarshal(ReportsList.class, (Reader)new InputStreamReader(configIn));
    }

    public synchronized void saveCurrent() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (instance == null) {
            throw new IllegalStateException("KSC_PerformanceReportFactory.init() must be called before KSC_PerformanceReportFactory.saveCurrent().");
        }
        this.sortByTitle();
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            FileWriter fileWriter = new FileWriter(KSC_PerformanceReportFile);
            fileWriter.write(stringWriter.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        KSC_PerformanceReportFactory.reload();
    }

    public void sortByTitle() {
        Report[] report_array = m_config.getReport();
        for (int j = 0; j < report_array.length; ++j) {
            for (int i = j + 1; i < report_array.length; ++i) {
                if (report_array[i].getTitle().compareTo(report_array[j].getTitle()) >= 0) continue;
                Report temp_report = report_array[j];
                report_array[j] = report_array[i];
                report_array[i] = temp_report;
            }
        }
        m_config.setReport(report_array);
    }

    public static ReportsList getConfiguration() {
        return m_config;
    }

    public void deleteReportAndSave(int index) throws ArrayIndexOutOfBoundsException, IOException, FileNotFoundException, MarshalException, ValidationException {
        int total_reports = m_config.getReportCount();
        if (index < 0 || index >= total_reports) {
            throw new ArrayIndexOutOfBoundsException("Reports List index to be deleted is out of bounds.");
        }
        Report removee = m_config.getReport(index);
        m_config.removeReport(removee);
        this.saveCurrent();
        KSC_PerformanceReportFactory.reload();
    }

    public Report getWorkingReport() {
        return this.working_report;
    }

    public void loadWorkingReport(Report source_report) throws MarshalException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)source_report, (Writer)stringWriter);
        StringReader stringReader = new StringReader(stringWriter.toString());
        this.working_report = (Report)Unmarshaller.unmarshal(Report.class, (Reader)stringReader);
    }

    public void loadWorkingReport(int index) throws MarshalException, ValidationException {
        int total_reports = m_config.getReportCount();
        this.working_index = index;
        if (this.working_index < 0 || this.working_index >= total_reports) {
            this.working_report = KSC_PerformanceReportFactory.getNewReport();
            this.working_index = -1;
        } else {
            this.loadWorkingReport(m_config.getReport(this.working_index));
        }
    }

    public void unloadWorkingReport() throws MarshalException, ValidationException {
        int total_reports = m_config.getReportCount();
        if (this.working_index < 0 || this.working_index >= total_reports) {
            m_config.addReport(this.working_report);
        } else {
            m_config.setReport(this.working_index, this.working_report);
        }
        this.working_report = KSC_PerformanceReportFactory.getNewReport();
        this.working_index = -1;
    }

    public static Report getNewReport() {
        Report new_report = new Report();
        new_report.setTitle("New Report Title");
        new_report.setShow_graphtype_button(false);
        new_report.setShow_timespan_button(false);
        return new_report;
    }

    public int getWorkingReportIndex() {
        return this.working_index;
    }

    public void setWorkingReportIndex(int v_index) {
        this.working_index = v_index;
    }

    public Graph getWorkingGraph() {
        return this.working_graph;
    }

    public int getWorkingGraphIndex() {
        return this.graph_index;
    }

    public static Graph getNewGraph() {
        Graph new_graph = new Graph();
        new_graph.setTitle("");
        new_graph.setTimespan("7_day");
        return new_graph;
    }

    public void loadWorkingGraph(int index) throws MarshalException, ValidationException {
        int total_graphs = this.working_report.getGraphCount();
        this.graph_index = index;
        if (this.graph_index < 0 || this.graph_index >= total_graphs) {
            this.working_graph = KSC_PerformanceReportFactory.getNewGraph();
            this.graph_index = -1;
        } else {
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)this.working_report.getGraph(this.graph_index), (Writer)stringWriter);
            StringReader stringReader = new StringReader(stringWriter.toString());
            this.working_graph = (Graph)Unmarshaller.unmarshal(Graph.class, (Reader)stringReader);
        }
    }

    public void unloadWorkingGraph(int requested_graphnum) throws MarshalException, ValidationException {
        int total_graphs = this.working_report.getGraphCount();
        int insert_location = requested_graphnum--;
        boolean replace_graph = false;
        if (this.graph_index >= 0 && this.graph_index < total_graphs) {
            this.working_report.removeGraph(this.working_report.getGraph(this.graph_index));
        }
        if (insert_location < 0 || insert_location >= total_graphs) {
            this.working_report.addGraph(this.working_graph);
        } else {
            this.working_report.addGraph(insert_location, this.working_graph);
        }
        this.working_graph = KSC_PerformanceReportFactory.getNewGraph();
        this.graph_index = -1;
    }

    public static synchronized void getBeginEndTime(String interval, Calendar begin_time, Calendar end_time) throws IllegalArgumentException {
        if (interval.equals("1_hour")) {
            begin_time.add(10, -1);
        } else if (interval.equals("2_hour")) {
            begin_time.add(10, -2);
        } else if (interval.equals("4_hour")) {
            begin_time.add(10, -4);
        } else if (interval.equals("8_hour")) {
            begin_time.add(10, -8);
        } else if (interval.equals("1_day")) {
            begin_time.add(5, -1);
        } else if (interval.equals("2_day")) {
            begin_time.add(5, -2);
        } else if (interval.equals("7_day")) {
            begin_time.add(5, -7);
        } else if (interval.equals("1_month")) {
            begin_time.add(5, -30);
        } else if (interval.equals("6_month")) {
            begin_time.add(5, -183);
        } else if (interval.equals("1_year")) {
            begin_time.add(5, -365);
        } else {
            begin_time.set(11, 0);
            begin_time.set(12, 0);
            begin_time.set(13, 0);
            end_time.set(11, 0);
            end_time.set(12, 0);
            end_time.set(13, 0);
            if (interval.equals("Today")) {
                end_time.add(5, 1);
            } else if (interval.equals("Yesterday")) {
                begin_time.add(5, -1);
            } else if (interval.equals("This Week") || interval.equals("Last Week")) {
                begin_time.set(7, 1);
                end_time.set(7, 7);
                end_time.set(11, 23);
                end_time.set(12, 59);
                if (interval.equals("Last Week")) {
                    begin_time.add(5, -7);
                    end_time.add(5, -7);
                }
            } else if (interval.equals("This Month")) {
                begin_time.set(5, 1);
                end_time.add(2, 1);
                end_time.set(5, 1);
            } else if (interval.equals("Last Month")) {
                begin_time.add(2, -1);
                begin_time.set(5, 1);
                end_time.set(5, 1);
            } else if (interval.equals("This Quarter") || interval.equals("Last Quarter")) {
                begin_time.set(5, 1);
                end_time.set(5, 1);
                switch (begin_time.get(2)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        begin_time.set(2, 0);
                        end_time.set(2, 3);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        begin_time.set(2, 3);
                        end_time.set(2, 6);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        begin_time.set(2, 6);
                        end_time.set(2, 9);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        begin_time.set(2, 9);
                        end_time.set(2, 0);
                        end_time.add(1, 1);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid Calendar Month " + begin_time.get(2));
                    }
                }
                if (interval.equals("Last Quarter")) {
                    begin_time.add(2, -3);
                    end_time.add(2, -3);
                }
            } else if (interval.equals("This Year")) {
                begin_time.set(2, 0);
                begin_time.set(5, 1);
                end_time.set(2, 0);
                end_time.set(5, 1);
                end_time.add(1, 1);
            } else if (interval.equals("Last Year")) {
                begin_time.set(2, 0);
                begin_time.set(5, 1);
                begin_time.add(1, -1);
                end_time.set(2, 0);
                end_time.set(5, 1);
            } else {
                throw new IllegalArgumentException("Unknown graph timespan: " + interval);
            }
        }
    }

    static {
        initialized = false;
    }
}

