/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.Mask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventconfFactory {
    private static EventconfFactory instance;
    private static File m_rootConfigFile;
    private static File m_programmaticStoreFile;
    private static Map<File, Events> m_eventFiles;
    private static boolean initialized;

    private EventconfFactory() {
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (!initialized) {
            m_rootConfigFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
            m_programmaticStoreFile = new File(m_rootConfigFile.getParent() + File.separator + "events/programmatic.events.xml");
            EventconfFactory.reload();
            initialized = true;
        }
    }

    public static synchronized void reinit() throws MarshalException, ValidationException, IOException {
        initialized = false;
        EventconfFactory.init();
    }

    public static synchronized EventconfFactory getInstance() {
        if (!initialized) {
            return null;
        }
        if (instance == null) {
            instance = new EventconfFactory();
        }
        return instance;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        FileInputStream configIn = new FileInputStream(m_rootConfigFile);
        Events events = (Events)Unmarshaller.unmarshal(Events.class, (Reader)new InputStreamReader(configIn));
        m_eventFiles = new HashMap<File, Events>();
        m_eventFiles.put(m_rootConfigFile, events);
        ArrayList eventFiles = new ArrayList(events.getEventFileCollection());
        for (int i = 0; i < eventFiles.size(); ++i) {
            FileInputStream fileIn;
            String eventFilePath = (String)eventFiles.get(i);
            File eventFile = new File(eventFilePath);
            if (!eventFile.isAbsolute()) {
                File tempFile = new File(m_rootConfigFile.getParent() + File.separator + eventFile.getPath());
                eventFile = tempFile.getCanonicalFile();
            }
            if ((fileIn = new FileInputStream(eventFile)) == null) {
                throw new IOException("Eventconf: Failed to load/locate events file: " + eventFile);
            }
            InputStreamReader filerdr = new InputStreamReader(fileIn);
            Events filelevel = null;
            filelevel = (Events)Unmarshaller.unmarshal(Events.class, (Reader)filerdr);
            m_eventFiles.put(eventFile, filelevel);
            if (filelevel.getEventFileCount() <= 0) continue;
            eventFiles.addAll(filelevel.getEventFileCollection());
        }
        initialized = true;
    }

    public List<Event> getEvents(String uei) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Events fileEvents : m_eventFiles.values()) {
            for (int i = 0; i < fileEvents.getEventCount(); ++i) {
                Event event = fileEvents.getEvent(i);
                if (!event.getUei().equals(uei)) continue;
                events.add(event);
            }
        }
        if (events.size() > 0) {
            return events;
        }
        return null;
    }

    public Event getEvent(String uei, Mask mask) {
        List<Event> ueiMatches = this.getEvents(uei);
        Event curEvent = null;
        for (int i = 0; i < ueiMatches.size(); ++i) {
        }
        return curEvent;
    }

    public List<String> getEventUEIs() {
        ArrayList<String> eventUEIs = new ArrayList<String>();
        for (Events fileEvents : m_eventFiles.values()) {
            for (int i = 0; i < fileEvents.getEventCount(); ++i) {
                Event event = fileEvents.getEvent(i);
                eventUEIs.add(event.getUei());
            }
        }
        return eventUEIs;
    }

    public Map getEventLabels() {
        TreeMap<String, String> eventLabels = new TreeMap<String, String>();
        for (Events fileEvents : m_eventFiles.values()) {
            for (int i = 0; i < fileEvents.getEventCount(); ++i) {
                Event event = fileEvents.getEvent(i);
                eventLabels.put(event.getUei(), event.getEventLabel());
            }
        }
        return eventLabels;
    }

    public String getEventLabel(String uei) {
        for (Events fileEvents : m_eventFiles.values()) {
            for (int i = 0; i < fileEvents.getEventCount(); ++i) {
                Event event = fileEvents.getEvent(i);
                if (!event.getUei().equals(uei)) continue;
                return event.getEventLabel();
            }
        }
        return "No label found for " + uei;
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        for (File file : m_eventFiles.keySet()) {
            Events fileEvents = m_eventFiles.get(file);
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)fileEvents, (Writer)stringWriter);
            if (stringWriter.toString() == null) continue;
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(stringWriter.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        if (m_programmaticStoreFile.exists() && !m_eventFiles.containsKey(m_programmaticStoreFile)) {
            m_programmaticStoreFile.delete();
        }
        EventconfFactory.reload();
    }

    public List getEventsByLabel() {
        ArrayList list = new ArrayList();
        for (Events fileEvents : m_eventFiles.values()) {
            list.addAll(fileEvents.getEventCollection());
        }
        Collections.sort(list, new EventLabelComparator());
        return list;
    }

    public void addEvent(Event event) {
        Events events = m_eventFiles.get(m_rootConfigFile);
        events.addEvent(event);
    }

    public void addEventToProgrammaticStore(Event event) {
        if (!m_eventFiles.containsKey(m_programmaticStoreFile)) {
            m_eventFiles.put(m_programmaticStoreFile, new Events());
        }
        Events root = m_eventFiles.get(m_rootConfigFile);
        String programmaticStorePath = m_programmaticStoreFile.getAbsolutePath();
        if (!root.getEventFileCollection().contains(programmaticStorePath)) {
            root.addEventFile(programmaticStorePath);
        }
        Events events = m_eventFiles.get(m_programmaticStoreFile);
        events.addEvent(event);
    }

    public boolean removeEventFromProgrammaticStore(Event event) {
        if (!m_eventFiles.containsKey(m_programmaticStoreFile)) {
            return false;
        }
        Events events = m_eventFiles.get(m_programmaticStoreFile);
        boolean result = events.removeEvent(event);
        if (events.getEventCount() == 0) {
            m_eventFiles.remove(m_programmaticStoreFile);
            Events root = m_eventFiles.get(m_rootConfigFile);
            root.removeEventFile(m_programmaticStoreFile.getAbsolutePath());
        }
        return result;
    }

    static {
        initialized = false;
    }

    private static class EventLabelComparator
    implements Comparator {
        private EventLabelComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Event)o1).getEventLabel().compareToIgnoreCase(((Event)o2).getEventLabel());
        }
    }
}

