/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.dhcpd.DhcpdConfiguration;

public final class DhcpdConfigFactory {
    private static DhcpdConfigFactory m_singleton = null;
    private DhcpdConfiguration m_config;
    private static boolean m_loaded = false;

    private DhcpdConfigFactory(File configFile) throws IOException, MarshalException, ValidationException {
        FileReader cfgIn = new FileReader(configFile);
        this.m_config = (DhcpdConfiguration)Unmarshaller.unmarshal(DhcpdConfiguration.class, (Reader)cfgIn);
        ((Reader)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DHCPD_CONFIG_FILE_NAME);
        m_singleton = new DhcpdConfigFactory(configFile);
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        DhcpdConfigFactory.init();
    }

    public static synchronized DhcpdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized int getPort() {
        return this.m_config.getPort();
    }

    public synchronized String getMacAddress() {
        return this.m_config.getMacAddress();
    }

    public synchronized String getMyIpAddress() {
        return this.m_config.getMyIpAddress();
    }

    public synchronized String getRequestIpAddress() {
        return this.m_config.getRequestIpAddress();
    }

    public synchronized String getExtendedMode() {
        return this.m_config.getExtendedMode();
    }
}

