/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.snmp.SnmpInstId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceType {
    private CollectionAgent m_agent;
    private OnmsSnmpCollection m_snmpCollection;
    private Collection<AttributeType> m_attributeTypes;

    public ResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
    }

    public CollectionAgent getAgent() {
        return this.m_agent;
    }

    protected String getCollectionName() {
        return this.m_snmpCollection.getName();
    }

    protected OnmsSnmpCollection getCollection() {
        return this.m_snmpCollection;
    }

    public final Collection<AttributeType> getAttributeTypes() {
        if (this.m_attributeTypes == null) {
            this.m_attributeTypes = this.loadAttributeTypes();
        }
        return this.m_attributeTypes;
    }

    protected abstract Collection<AttributeType> loadAttributeTypes();

    protected boolean hasDataToCollect() {
        return !this.getAttributeTypes().isEmpty();
    }

    public abstract CollectionResource findResource(SnmpInstId var1);

    public abstract CollectionResource findAliasedResource(SnmpInstId var1, String var2);

    public abstract Collection<? extends CollectionResource> getResources();

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

