/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.model.OnmsIpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsSnmpCollection {
    private ServiceParameters m_params;
    private NodeResourceType m_nodeResourceType;
    private IfResourceType m_ifResourceType;
    private IfAliasResourceType m_ifAliasResourceType;
    private Map<String, ResourceType> m_genericIndexResourceTypes;
    private int m_maxVarsPerPdu;
    private DataCollectionConfig m_dataCollectionConfig;
    private List<AttributeType> m_nodeAttributeTypes;
    private List<AttributeType> m_indexedAttributeTypes;
    private List<AttributeType> m_aliasAttributeTypes;

    public OnmsSnmpCollection(CollectionAgent agent, ServiceParameters params) {
        this(agent, params, null);
    }

    public OnmsSnmpCollection(CollectionAgent agent, ServiceParameters params, DataCollectionConfig config) {
        this.m_dataCollectionConfig = config;
        this.m_params = params;
        this.m_maxVarsPerPdu = this.determineMaxVarsPerPdu(agent);
        if (Boolean.getBoolean("org.opennms.netmgt.collectd.OnmsSnmpCollection.loadResourceTypesInInit")) {
            this.getResourceTypes(agent);
        }
    }

    public ServiceParameters getServiceParameters() {
        return this.m_params;
    }

    public String getName() {
        return this.m_params.getCollectionName();
    }

    public int getSnmpPort() {
        return this.m_params.getSnmpPort();
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    private int determineMaxVarsPerPdu(CollectionAgent agent) {
        int maxVarsPerPdu = this.getDataCollectionConfig().getMaxVarsPerPdu(this.getName());
        if (maxVarsPerPdu == 0) {
            this.log().info((Object)("determineMaxVarsPerPdu: using agent's configured value: " + agent.getMaxVarsPerPdu()));
            maxVarsPerPdu = agent.getMaxVarsPerPdu();
        } else {
            this.log().info((Object)("determineMaxVarsPerPdu: using data collection configured value: " + maxVarsPerPdu));
        }
        return maxVarsPerPdu;
    }

    private DataCollectionConfig getDataCollectionConfig() {
        if (this.m_dataCollectionConfig == null) {
            this.initializeDataCollectionConfig();
        }
        return this.m_dataCollectionConfig;
    }

    public void setDataCollectionConfig(DataCollectionConfig config) {
        this.m_dataCollectionConfig = config;
    }

    private void initializeDataCollectionConfig() {
        this.setDataCollectionConfig(DataCollectionConfigFactory.getInstance());
    }

    public String getStorageFlag() {
        String collectionName = this.getName();
        String storageFlag = this.getDataCollectionConfig().getSnmpStorageFlag(collectionName);
        if (storageFlag == null) {
            this.log().warn((Object)("getStorageFlag: Configuration error, failed to retrieve SNMP storage flag for collection: " + collectionName));
            storageFlag = SnmpCollector.SNMP_STORAGE_PRIMARY;
        }
        return storageFlag;
    }

    public String toString() {
        return this.getName();
    }

    public CollectionSet createCollectionSet(CollectionAgent agent) {
        return new CollectionSet(agent, this);
    }

    private List<AttributeType> getIndexedAttributeTypes(CollectionAgent agent) {
        if (this.m_indexedAttributeTypes == null) {
            this.m_indexedAttributeTypes = this.loadAttributeTypes(agent, -2);
        }
        return this.m_indexedAttributeTypes;
    }

    public List<AttributeType> getIndexedAttributeTypesForResourceType(CollectionAgent agent, ResourceType resourceType) {
        LinkedList<AttributeType> resAttrTypes = new LinkedList<AttributeType>();
        for (AttributeType attrType : this.getIndexedAttributeTypes(agent)) {
            if (!attrType.getResourceType().equals(resourceType)) continue;
            resAttrTypes.add(attrType);
        }
        return resAttrTypes;
    }

    public List<AttributeType> getNodeAttributeTypes(CollectionAgent agent) {
        if (this.m_nodeAttributeTypes == null) {
            this.m_nodeAttributeTypes = this.loadAttributeTypes(agent, -1);
        }
        return this.m_nodeAttributeTypes;
    }

    public List<AttributeType> loadAttributeTypes(CollectionAgent agent, int ifType) {
        String sysObjectId = agent.getSysObjectId();
        String hostAddress = agent.getHostAddress();
        List oidList = this.getDataCollectionConfig().getMibObjectList(this.getName(), sysObjectId, hostAddress, ifType);
        HashMap<String, AttributeGroupType> groupTypes = new HashMap<String, AttributeGroupType>();
        LinkedList<AttributeType> typeList = new LinkedList<AttributeType>();
        for (MibObject mibObject : oidList) {
            String instanceName = mibObject.getInstance();
            AttributeGroupType groupType = this.findGroup(groupTypes, mibObject);
            AttributeType attrType = AttributeType.create(this.getResourceType(agent, instanceName), this.getName(), mibObject, groupType);
            groupType.addAttributeType(attrType);
            typeList.add(attrType);
        }
        this.log().debug((Object)("getAttributeTypes(" + agent + ", " + ifType + "): " + typeList));
        return typeList;
    }

    private AttributeGroupType findGroup(Map<String, AttributeGroupType> groupTypes, MibObject mibObject) {
        AttributeGroupType groupType = groupTypes.get(mibObject.getGroupName());
        if (groupType == null) {
            groupType = new AttributeGroupType(mibObject.getGroupName(), mibObject.getGroupIfType());
            groupTypes.put(mibObject.getGroupName(), groupType);
        }
        return groupType;
    }

    public ResourceType getResourceType(CollectionAgent agent, String instanceName) {
        if ("ifIndex".equals(instanceName)) {
            return this.getIfResourceType(agent);
        }
        if (this.getGenericIndexResourceType(agent, instanceName) != null) {
            return this.getGenericIndexResourceType(agent, instanceName);
        }
        return this.getNodeResourceType(agent);
    }

    public NodeResourceType getNodeResourceType(CollectionAgent agent) {
        if (this.m_nodeResourceType == null) {
            this.m_nodeResourceType = new NodeResourceType(agent, this);
        }
        return this.m_nodeResourceType;
    }

    public IfResourceType getIfResourceType(CollectionAgent agent) {
        if (this.m_ifResourceType == null) {
            this.m_ifResourceType = new IfResourceType(agent, this);
        }
        return this.m_ifResourceType;
    }

    public IfAliasResourceType getIfAliasResourceType(CollectionAgent agent) {
        if (this.m_ifAliasResourceType == null) {
            this.m_ifAliasResourceType = new IfAliasResourceType(agent, this, this.m_params, this.getIfResourceType(agent));
        }
        return this.m_ifAliasResourceType;
    }

    public Collection<ResourceType> getGenericIndexResourceTypes(CollectionAgent agent) {
        return Collections.unmodifiableCollection(this.getGenericIndexResourceTypeMap(agent).values());
    }

    private Map<String, ResourceType> getGenericIndexResourceTypeMap(CollectionAgent agent) {
        if (this.m_genericIndexResourceTypes == null) {
            Collection configuredResourceTypes = this.getDataCollectionConfig().getConfiguredResourceTypes().values();
            HashMap<String, ResourceType> resourceTypes = new HashMap<String, ResourceType>();
            for (org.opennms.netmgt.config.datacollection.ResourceType configuredResourceType : configuredResourceTypes) {
                resourceTypes.put(configuredResourceType.getName(), new GenericIndexResourceType(agent, this, configuredResourceType));
            }
            this.m_genericIndexResourceTypes = resourceTypes;
        }
        return this.m_genericIndexResourceTypes;
    }

    private ResourceType getGenericIndexResourceType(CollectionAgent agent, String name) {
        return this.getGenericIndexResourceTypeMap(agent).get(name);
    }

    private Collection<ResourceType> getResourceTypes(CollectionAgent agent) {
        HashSet<ResourceType> set = new HashSet<ResourceType>(3);
        set.add(this.getNodeResourceType(agent));
        set.add(this.getIfResourceType(agent));
        set.add(this.getIfAliasResourceType(agent));
        set.addAll(this.getGenericIndexResourceTypeMap(agent).values());
        return set;
    }

    public Collection<AttributeType> getAttributeTypes(CollectionAgent agent) {
        HashSet<AttributeType> set = new HashSet<AttributeType>();
        for (ResourceType resourceType : this.getResourceTypes(agent)) {
            set.addAll(resourceType.getAttributeTypes());
        }
        return set;
    }

    public Collection<? extends CollectionResource> getResources(CollectionAgent agent) {
        LinkedList<? extends CollectionResource> resources = new LinkedList<CollectionResource>();
        for (ResourceType resourceType : this.getResourceTypes(agent)) {
            resources.addAll(resourceType.getResources());
        }
        return resources;
    }

    OnmsIpInterface.CollectionType getMinimumCollectionType() {
        if (this.getStorageFlag().equals(SnmpCollector.SNMP_STORAGE_PRIMARY)) {
            return OnmsIpInterface.CollectionType.PRIMARY;
        }
        if (this.getStorageFlag().equals(SnmpCollector.SNMP_STORAGE_SELECT)) {
            return OnmsIpInterface.CollectionType.COLLECT;
        }
        return OnmsIpInterface.CollectionType.NO_COLLECT;
    }

    public List<AttributeType> loadAliasAttributeTypes(CollectionAgent agent) {
        IfAliasResourceType resType = this.getIfAliasResourceType(agent);
        MibObject ifAliasMibObject = new MibObject();
        ifAliasMibObject.setOid(".1.3.6.1.2.1.31.1.1.1.18");
        ifAliasMibObject.setAlias("ifAlias");
        ifAliasMibObject.setType("string");
        ifAliasMibObject.setInstance("ifIndex");
        ifAliasMibObject.setGroupName("aliasedResource");
        ifAliasMibObject.setGroupIfType("all");
        AttributeGroupType groupType = new AttributeGroupType(ifAliasMibObject.getGroupName(), ifAliasMibObject.getGroupIfType());
        AttributeType type = AttributeType.create(resType, resType.getCollectionName(), ifAliasMibObject, groupType);
        return Collections.singletonList(type);
    }

    public List<AttributeType> getAliasAttributeTypes(CollectionAgent agent) {
        if (this.m_aliasAttributeTypes == null) {
            this.m_aliasAttributeTypes = this.loadAliasAttributeTypes(agent);
        }
        return this.m_aliasAttributeTypes;
    }
}

