/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.JMXCollectorEntry;

public class JMXNodeCollector {
    private boolean m_error;
    private int m_errorStatus;
    private static String[] m_errorText = new String[]{"ErrNoError", "ErrTooBig", "ErrNoSuchName", "ErrBadValue", "ErrReadOnly", "ErrGenError"};
    private int m_errorIndex;
    private boolean m_timeout;
    private List m_objList;
    private int m_oidListIndex;
    private JMXCollectorEntry m_collectorEntry;
    private int m_version;
    private String m_primaryIf;
    private int m_maxVarsPerPdu;

    private JMXNodeCollector() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Default Constructor not supported");
    }

    public JMXNodeCollector(List objList, int maxVarsPerPdu) {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_error = false;
        this.m_errorIndex = -1;
        this.m_timeout = false;
        this.m_collectorEntry = null;
        this.m_objList = objList;
        this.m_oidListIndex = 0;
        this.m_maxVarsPerPdu = maxVarsPerPdu;
        if (log.isDebugEnabled()) {
            log.debug((Object)("JMXNodeCollector: totalOids=" + objList.size() + " maxVarsPerPdu=" + maxVarsPerPdu));
        }
    }

    public boolean failed() {
        return this.m_error;
    }

    public boolean timedout() {
        if (this.m_error) {
            return this.m_timeout;
        }
        return false;
    }

    public JMXCollectorEntry getEntry() {
        return this.m_collectorEntry;
    }
}

