/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.BasePersister;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.CollectionWarning;
import org.opennms.netmgt.collectd.GroupPersister;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.OneToOnePersister;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ResourceVisitor;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpIfCollector;
import org.opennms.netmgt.collectd.SnmpNodeCollector;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSet
implements Collectable {
    private CollectionAgent m_agent;
    private OnmsSnmpCollection m_snmpCollection;
    private SnmpIfCollector m_ifCollector;
    private IfNumberTracker m_ifNumber;
    private SnmpNodeCollector m_nodeCollector;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CollectionAgent: ");
        buffer.append(this.m_agent);
        buffer.append("\n");
        buffer.append("OnmsSnmpCollection: ");
        buffer.append(this.m_snmpCollection);
        buffer.append("\n");
        buffer.append("SnmpIfCollector: ");
        buffer.append((Object)this.m_ifCollector);
        buffer.append("\n");
        buffer.append("IfNumberTracker: ");
        buffer.append((Object)this.m_ifNumber);
        buffer.append("\n");
        buffer.append("SnmpNodeCollector: ");
        buffer.append((Object)this.m_nodeCollector);
        buffer.append("\n");
        return buffer.toString();
    }

    public CollectionSet(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
    }

    public SnmpIfCollector getIfCollector() {
        if (this.m_ifCollector == null) {
            this.m_ifCollector = this.createIfCollector();
        }
        return this.m_ifCollector;
    }

    public IfNumberTracker getIfNumber() {
        if (this.m_ifNumber == null) {
            this.m_ifNumber = this.createIfNumberTracker();
        }
        return this.m_ifNumber;
    }

    public SnmpNodeCollector getNodeCollector() {
        if (this.m_nodeCollector == null) {
            this.m_nodeCollector = this.createNodeCollector();
        }
        return this.m_nodeCollector;
    }

    private SnmpNodeCollector createNodeCollector() {
        SnmpNodeCollector nodeCollector = null;
        if (!this.getAttributeList().isEmpty()) {
            nodeCollector = new SnmpNodeCollector(this.m_agent.getInetAddress(), this.getAttributeList(), this);
        }
        return nodeCollector;
    }

    private IfNumberTracker createIfNumberTracker() {
        IfNumberTracker ifNumber = null;
        if (this.hasInterfaceDataToCollect()) {
            ifNumber = new IfNumberTracker();
        }
        return ifNumber;
    }

    private SnmpIfCollector createIfCollector() {
        SnmpIfCollector ifCollector = null;
        if (this.hasInterfaceDataToCollect()) {
            ifCollector = new SnmpIfCollector(this.m_agent.getInetAddress(), this.getCombinedIndexedAttributes(), this);
        }
        return ifCollector;
    }

    public NodeInfo getNodeInfo() {
        return this.getNodeResourceType().getNodeInfo();
    }

    boolean hasDataToCollect() {
        return this.getNodeResourceType().hasDataToCollect() || this.getIfResourceType().hasDataToCollect();
    }

    boolean hasInterfaceDataToCollect() {
        return this.getIfResourceType().hasDataToCollect();
    }

    public CollectionAgent getCollectionAgent() {
        return this.m_agent;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    Collection<AttributeType> getAttributeList() {
        return this.m_snmpCollection.getNodeResourceType(this.m_agent).getAttributeTypes();
    }

    List<AttributeType> getCombinedIndexedAttributes() {
        LinkedList<AttributeType> attributes = new LinkedList<AttributeType>();
        attributes.addAll(this.getIfResourceType().getAttributeTypes());
        attributes.addAll(this.getIfAliasResourceType().getAttributeTypes());
        attributes.addAll(this.getGenericIndexAttributeTypes());
        return attributes;
    }

    protected Collection<AttributeType> getGenericIndexAttributeTypes() {
        LinkedList<AttributeType> attributeTypes = new LinkedList<AttributeType>();
        Collection<ResourceType> resourceTypes = this.getGenericIndexResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            attributeTypes.addAll(resourceType.getAttributeTypes());
        }
        return attributeTypes;
    }

    private Collection<ResourceType> getGenericIndexResourceTypes() {
        return this.m_snmpCollection.getGenericIndexResourceTypes(this.m_agent);
    }

    public CollectionTracker getCollectionTracker() {
        return new AggregateTracker(AttributeType.getCollectionTrackers(this.getAttributeTypes()));
    }

    private Collection<AttributeType> getAttributeTypes() {
        return this.m_snmpCollection.getAttributeTypes(this.m_agent);
    }

    public Collection getResources() {
        return this.m_snmpCollection.getResources(this.m_agent);
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet(this);
        for (CollectionResource resource : this.getResources()) {
            resource.visit(visitor);
        }
        visitor.completeCollectionSet(this);
    }

    CollectionTracker getTracker() {
        ArrayList<Object> trackers = new ArrayList<Object>(3);
        if (this.getIfNumber() != null) {
            trackers.add((Object)this.getIfNumber());
        }
        if (this.getNodeCollector() != null) {
            trackers.add((Object)this.getNodeCollector());
        }
        if (this.getIfCollector() != null) {
            trackers.add((Object)this.getIfCollector());
        }
        return new AggregateTracker(trackers);
    }

    protected SnmpWalker createWalker() {
        CollectionAgent agent = this.getCollectionAgent();
        return SnmpUtils.createWalker((SnmpAgentConfig)this.getAgentConfig(), (String)("SnmpCollectors for " + agent.getHostAddress()), (CollectionTracker)this.getTracker());
    }

    void logStartedWalker() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("collect: successfully instantiated SnmpNodeCollector() for " + this.getCollectionAgent().getHostAddress()));
        }
    }

    void logFinishedWalker() {
        this.log().info((Object)("collect: node SNMP query for address " + this.getCollectionAgent().getHostAddress() + " complete."));
    }

    void verifySuccessfulWalk(SnmpWalker walker) throws CollectionWarning {
        if (walker.failed()) {
            throw new CollectionWarning("collect: collection failed for " + this.getCollectionAgent().getHostAddress());
        }
    }

    void collect() throws CollectionWarning {
        try {
            SnmpWalker walker = this.createWalker();
            walker.start();
            this.logStartedWalker();
            walker.waitFor();
            this.logFinishedWalker();
            this.verifySuccessfulWalk(walker);
            this.getCollectionAgent().setMaxVarsPerPdu(walker.getMaxVarsPerPdu());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CollectionWarning("collect: Collection of node SNMP data for interface " + this.getCollectionAgent().getHostAddress() + " interrupted!", e);
        }
    }

    void checkForNewInterfaces(RescanNeeded rescanNeeded) {
        if (!this.hasInterfaceDataToCollect()) {
            return;
        }
        this.logIfCounts();
        if (this.ifCountHasChanged(this.getCollectionAgent())) {
            this.log().info((Object)("Sending rescan event because the number of interfaces on primary SNMP interface " + this.getCollectionAgent().getHostAddress() + " has changed, generating 'ForceRescan' event."));
            rescanNeeded.rescanIndicated();
        }
        this.getCollectionAgent().setSavedIfCount(this.getIfNumber().getIfNumber());
    }

    private void logIfCounts() {
        CollectionAgent agent = this.getCollectionAgent();
        this.log().debug((Object)("collect: nodeId: " + agent.getNodeId() + " interface: " + agent.getHostAddress() + " ifCount: " + this.getIfNumber().getIfNumber() + " savedIfCount: " + agent.getSavedIfCount()));
    }

    public boolean rescanNeeded() {
        final RescanNeeded rescanNeeded = new RescanNeeded();
        this.visit(new ResourceVisitor(){

            public void visitResource(CollectionResource resource) {
                CollectionSet.this.log().debug((Object)("rescanNeeded: Visiting resource " + resource));
                if (resource.rescanNeeded()) {
                    CollectionSet.this.log().debug((Object)("Sending rescan event for " + CollectionSet.this.getCollectionAgent() + " because resource " + resource + " indicated it was needed"));
                    rescanNeeded.rescanIndicated();
                }
            }
        });
        this.checkForNewInterfaces(rescanNeeded);
        return rescanNeeded.rescanIsNeeded();
    }

    public SnmpAgentConfig getAgentConfig() {
        SnmpAgentConfig agentConfig = this.getCollectionAgent().getAgentConfig();
        agentConfig.setMaxVarsPerPdu(this.computeMaxVarsPerPdu(agentConfig));
        int snmpPort = this.m_snmpCollection.getSnmpPort();
        if (snmpPort > -1) {
            agentConfig.setPort(snmpPort);
        }
        return agentConfig;
    }

    private int computeMaxVarsPerPdu(SnmpAgentConfig agentConfig) {
        int maxVarsPerPdu = this.getCollectionAgent().getMaxVarsPerPdu();
        if (maxVarsPerPdu < 1) {
            maxVarsPerPdu = this.m_snmpCollection.getMaxVarsPerPdu();
            this.log().info((Object)"using maxVarsPerPdu from dataCollectionConfig");
        }
        if (maxVarsPerPdu < 1) {
            maxVarsPerPdu = agentConfig.getMaxVarsPerPdu();
            this.log().info((Object)"using maxVarsPerPdu from snmpconfig");
        }
        if (maxVarsPerPdu < 1) {
            this.log().warn((Object)"maxVarsPerPdu CANNOT BE LESS THAN 1.  Using 10");
            return 10;
        }
        return maxVarsPerPdu;
    }

    public void notifyIfNotFound(AttributeDefinition attrType, SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        this.log().info((Object)("Unable to locate resource for agent " + this.getCollectionAgent() + " with instance id " + inst + " while collecting attribute " + attrType));
    }

    void saveAttributes(ServiceParameters params) {
        BasePersister persister = this.createPersister(params);
        this.visit(persister);
    }

    private BasePersister createPersister(ServiceParameters params) {
        if (Boolean.getBoolean("org.opennms.rrd.storeByGroup")) {
            return new GroupPersister(params);
        }
        return new OneToOnePersister(params);
    }

    private boolean ifCountHasChanged(CollectionAgent agent) {
        return agent.getSavedIfCount() != -1 && this.getIfNumber().getIfNumber() != agent.getSavedIfCount();
    }

    private NodeResourceType getNodeResourceType() {
        return this.m_snmpCollection.getNodeResourceType(this.getCollectionAgent());
    }

    private IfResourceType getIfResourceType() {
        return this.m_snmpCollection.getIfResourceType(this.getCollectionAgent());
    }

    private IfAliasResourceType getIfAliasResourceType() {
        return this.m_snmpCollection.getIfAliasResourceType(this.getCollectionAgent());
    }

    public static final class IfNumberTracker
    extends SingleInstanceTracker {
        int m_ifNumber = -1;

        IfNumberTracker() {
            super(SnmpObjId.get((String)".1.3.6.1.2.1.2.1"), SnmpInstId.INST_ZERO);
        }

        protected void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
            this.m_ifNumber = val.toInt();
        }

        public int getIfNumber() {
            return this.m_ifNumber;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(((Object)((Object)this)).getClass().getName());
            buffer.append("@");
            buffer.append(Integer.toHexString(((Object)((Object)this)).hashCode()));
            buffer.append(": ifNumber: " + this.m_ifNumber);
            return buffer.toString();
        }
    }

    public static class RescanNeeded {
        boolean rescanNeeded = false;

        public void rescanIndicated() {
            this.rescanNeeded = true;
        }

        public boolean rescanIsNeeded() {
            return this.rescanNeeded;
        }
    }
}

