/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorUpdates;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.transaction.PlatformTransactionManager;

final class CollectableService
implements ReadyRunnable {
    private int m_nodeId;
    private int m_status;
    private long m_lastScheduledCollectionTime;
    private final Scheduler m_scheduler;
    private CollectorUpdates m_updates;
    private static final boolean ABORT_COLLECTION = true;
    private CollectionSpecification m_spec;
    private Collectd.SchedulingCompletedFlag m_schedulingCompletedFlag;
    private CollectionAgent m_agent;
    private PlatformTransactionManager m_transMgr;
    private IpInterfaceDao m_ifaceDao;

    protected CollectableService(OnmsIpInterface iface, IpInterfaceDao ifaceDao, CollectionSpecification spec, Scheduler scheduler, Collectd.SchedulingCompletedFlag schedulingCompletedFlag, PlatformTransactionManager transMgr) {
        this.m_agent = DefaultCollectionAgent.create(iface.getId(), ifaceDao, transMgr);
        this.m_spec = spec;
        this.m_scheduler = scheduler;
        this.m_schedulingCompletedFlag = schedulingCompletedFlag;
        this.m_ifaceDao = ifaceDao;
        this.m_transMgr = transMgr;
        this.m_nodeId = iface.getNode().getId();
        this.m_status = 1;
        this.m_updates = new CollectorUpdates();
        this.m_lastScheduledCollectionTime = 0L;
        this.m_spec.initialize(this.m_agent);
    }

    public Object getAddress() {
        return this.m_agent.getAddress();
    }

    public CollectionSpecification getSpecification() {
        return this.m_spec;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    public String getServiceName() {
        return this.m_spec.getServiceName();
    }

    public String getPackageName() {
        return this.m_spec.getPackageName();
    }

    public CollectorUpdates getCollectorUpdates() {
        return this.m_updates;
    }

    public void refreshPackage() {
        this.m_spec.refresh();
    }

    public boolean isReady() {
        boolean ready = false;
        if (!this.isSchedulingComplete()) {
            return false;
        }
        ready = this.m_spec.getInterval() < 1L ? true : this.m_spec.getInterval() - (System.currentTimeMillis() - this.m_lastScheduledCollectionTime) < 1L;
        return ready;
    }

    private boolean isSchedulingComplete() {
        return this.m_schedulingCompletedFlag.isSchedulingCompleted();
    }

    private void sendEvent(String uei) {
        Event event = new Event();
        event.setUei(uei);
        event.setNodeid((long)this.m_nodeId);
        event.setInterface(this.getHostAddress());
        event.setService(this.m_spec.getServiceName());
        event.setSource("OpenNMS.Collectd");
        try {
            event.setHost(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException ex) {
            event.setHost("unresolved.host");
        }
        event.setTime(EventConstants.formatToString(new Date()));
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(event);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("sendEvent: Sent event " + uei + " for " + this.m_nodeId + "/" + this.getHostAddress() + "/" + this.getServiceName()));
            }
        }
        catch (Exception ex) {
            this.log().error((Object)("Failed to send the event " + uei + " for interface " + this.getHostAddress()), (Throwable)ex);
        }
    }

    private String getHostAddress() {
        return this.m_agent.getHostAddress();
    }

    public void run() {
        if (this.processUpdates()) {
            return;
        }
        this.m_lastScheduledCollectionTime = System.currentTimeMillis();
        if (!this.m_spec.scheduledOutage(this.m_agent)) {
            int status = this.doCollection();
            this.updateStatus(status);
        }
        this.m_scheduler.schedule(this.m_spec.getInterval(), this.getReadyRunnable());
    }

    private void updateStatus(int status) {
        if (status != this.m_status) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"run: change in collection status, generating event.");
            }
            switch (status) {
                case 1: {
                    this.sendEvent("uei.opennms.org/nodes/dataCollectionSucceeded");
                    break;
                }
                case 2: {
                    this.sendEvent("uei.opennms.org/nodes/dataCollectionFailed");
                    break;
                }
            }
        }
        this.m_status = status;
    }

    private int doCollection() {
        this.log().info((Object)("run: starting new collection for " + this.getHostAddress()));
        int status = 2;
        try {
            status = this.m_spec.collect(this.m_agent);
        }
        catch (Throwable t) {
            this.log().error((Object)("run: An undeclared throwable was caught during SNMP collection for interface " + this.getHostAddress()), t);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUpdates() {
        CollectableService collectableService = this;
        synchronized (collectableService) {
            if (!this.m_updates.hasUpdates()) {
                return false;
            }
            if (this.m_updates.isDeletionFlagSet()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Collector for  " + this.getHostAddress() + " is marked for deletion...skipping collection, will not reschedule."));
                }
                return true;
            }
            OnmsIpInterface newIface = this.m_updates.isReinitializationNeeded();
            if (newIface != null) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("ReinitializationFlag set for " + this.getHostAddress()));
                }
                try {
                    this.reinitialize(newIface);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("Completed reinitializing SNMP collector for " + this.getHostAddress()));
                    }
                }
                catch (RuntimeException rE) {
                    this.log().warn((Object)("Unable to initialize " + this.getHostAddress() + " for " + this.m_spec.getServiceName() + " collection, reason: " + rE.getMessage()));
                }
                catch (Throwable t) {
                    this.log().error((Object)("Uncaught exception, failed to intialize interface " + this.getHostAddress() + " for " + this.m_spec.getServiceName() + " data collection"), t);
                }
            }
            if (this.m_updates.isReparentingFlagSet()) {
                File oldNodeDir;
                String rrdPath;
                File newNodeDir;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("ReparentingFlag set for " + this.getHostAddress()));
                }
                if (!(newNodeDir = new File((rrdPath = DataCollectionConfigFactory.getInstance().getRrdPath()) + File.separator + this.m_updates.getReparentNewNodeId())).isDirectory()) {
                    oldNodeDir = new File(rrdPath + File.separator + this.m_updates.getReparentOldNodeId());
                    try {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("Attempting to rename " + oldNodeDir + " to " + newNodeDir));
                        }
                        oldNodeDir.renameTo(newNodeDir);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"Rename successful!!");
                        }
                    }
                    catch (SecurityException se) {
                        this.log().error((Object)"Insufficient authority to rename RRD directory.", (Throwable)se);
                    }
                    catch (Throwable t) {
                        this.log().error((Object)"Unexpected exception while attempting to rename RRD directory.", t);
                    }
                } else {
                    oldNodeDir = new File(rrdPath + File.separator + this.m_updates.getReparentOldNodeId());
                    String[] filesToMove = oldNodeDir.list();
                    if (filesToMove != null) {
                        for (int i = 0; i < filesToMove.length; ++i) {
                            File srcFile = new File(oldNodeDir.toString() + File.separator + filesToMove[i]);
                            File destFile = new File(newNodeDir.toString() + File.separator + filesToMove[i]);
                            try {
                                if (this.log().isDebugEnabled()) {
                                    this.log().debug((Object)("Attempting to move " + srcFile + " to " + destFile));
                                }
                                srcFile.renameTo(destFile);
                                continue;
                            }
                            catch (SecurityException se) {
                                this.log().error((Object)"Insufficient authority to move RRD files.", (Throwable)se);
                                break;
                            }
                            catch (Throwable t) {
                                this.log().warn((Object)("Unexpected exception while attempting to move " + srcFile + " to " + destFile), t);
                            }
                        }
                    }
                }
                int newNodeId = -1;
                try {
                    newNodeId = Integer.parseInt(this.m_updates.getReparentNewNodeId());
                }
                catch (NumberFormatException nfE) {
                    this.log().warn((Object)("Unable to convert new nodeId value to an int while processing reparenting update: " + this.m_updates.getReparentNewNodeId()));
                }
                this.m_nodeId = newNodeId;
                try {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("Reinitializing SNMP collector for " + this.getHostAddress()));
                    }
                    this.reinitialize(this.m_updates.getUpdatedInterface());
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("Completed reinitializing SNMP collector for " + this.getHostAddress()));
                    }
                }
                catch (RuntimeException rE) {
                    this.log().warn((Object)("Unable to initialize " + this.getHostAddress() + " for " + this.m_spec.getServiceName() + " collection, reason: " + rE.getMessage()));
                }
                catch (Throwable t) {
                    this.log().error((Object)("Uncaught exception, failed to initialize interface " + this.getHostAddress() + " for " + this.m_spec.getServiceName() + " data collection"), t);
                }
            }
            this.m_updates.reset();
        }
        return false;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void reinitialize(OnmsIpInterface newIface) {
        this.m_spec.release(this.m_agent);
        this.m_agent = DefaultCollectionAgent.create(newIface.getId(), this.m_ifaceDao, this.m_transMgr);
        this.m_spec.initialize(this.m_agent);
    }

    public ReadyRunnable getReadyRunnable() {
        return this;
    }
}

