/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.snmp.SnmpValue;

public class Attribute {
    private CollectionResource m_resource;
    private AttributeType m_type;
    private SnmpValue m_val;

    public Attribute(CollectionResource resource, AttributeType type, SnmpValue val) {
        this.m_resource = resource;
        this.m_type = type;
        this.m_val = val;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attribute) {
            Attribute attr = (Attribute)obj;
            return this.m_resource.equals(attr.m_resource) && this.m_type.equals(this.m_type);
        }
        return false;
    }

    public int hashCode() {
        return this.m_resource.hashCode() ^ this.m_type.hashCode();
    }

    public void visit(CollectionSetVisitor visitor) {
        this.log().debug((Object)("Visiting attribute " + this));
        visitor.visitAttribute(this);
        visitor.completeAttribute(this);
    }

    public AttributeType getAttributeType() {
        return this.m_type;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public SnmpValue getValue() {
        return this.m_val;
    }

    void store(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute(this, persister);
    }

    public String toString() {
        return this.getResource() + "." + this.getAttributeType() + " = " + this.getValue();
    }

    public String getType() {
        return this.getAttributeType().getType();
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getName() {
        return this.getAttributeType().getName();
    }

    String getNumericValue() {
        String val = null;
        if (this.getValue() == null) {
            val = null;
        } else {
            try {
                val = Long.toString(this.getValue().toLong());
            }
            catch (NumberFormatException e) {
                this.log().warn((Object)("Unable to process data received for attribute " + this + " maybe this is not a number? See bug 1473 for more information. Skipping."));
            }
        }
        if (val == null) {
            this.log().info((Object)("No data collected for attribute " + this + ". Skipping"));
        }
        return val;
    }
}

