/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class SnmpTable
extends AggregateTracker {
    private Map<SnmpInstId, SnmpTableEntry> m_results = new TreeMap<SnmpInstId, SnmpTableEntry>();
    private InetAddress m_address;
    private String m_tableName;

    protected SnmpTable(InetAddress address, String tableName, NamedSnmpVar[] columns) {
        super((Collectable[])NamedSnmpVar.getTrackersFor(columns));
        this.m_address = address;
        this.m_tableName = tableName;
    }

    protected void storeResult(SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        SnmpTableEntry entry = this.m_results.get(inst);
        if (entry == null) {
            entry = this.createTableEntry(base, inst, val);
            this.m_results.put(inst, entry);
        }
        entry.storeResult(base, inst, val);
    }

    protected abstract SnmpTableEntry createTableEntry(SnmpObjId var1, SnmpInstId var2, Object var3);

    public List getEntries() {
        return new ArrayList<SnmpTableEntry>(this.m_results.values());
    }

    protected void reportGenErr(String msg) {
        this.log().warn((Object)("Error retrieving " + this.m_tableName + " from " + this.m_address + ". " + msg));
    }

    protected void reportNoSuchNameErr(String msg) {
        this.log().info((Object)("Error retrieving " + this.m_tableName + " from " + this.m_address + ". " + msg));
    }

    private final Category log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

