/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.IpAddrTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

public class IpAddrTable
extends SnmpTable {
    public IpAddrTable(InetAddress address) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList);
    }

    protected SnmpTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddrTableEntry();
    }

    public static InetAddress getIpAddress(List ipAddrEntries, int ifIndex) {
        if (ifIndex == -1 || ipAddrEntries == null) {
            return null;
        }
        for (IpAddrTableEntry ipAddrEntry : ipAddrEntries) {
            int ipAddrIndex;
            Integer snmpIpAddrIndex = ipAddrEntry.getIpAdEntIfIndex();
            if (snmpIpAddrIndex == null || (ipAddrIndex = snmpIpAddrIndex.intValue()) != ifIndex) continue;
            return ipAddrEntry.getIpAdEntAddr();
        }
        return null;
    }

    public static List getIpAddresses(List ipAddrEntries, int ifIndex) {
        if (ifIndex == -1 || ipAddrEntries == null) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : ipAddrEntries) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }

    public static List getIpAddresses(List ipAddrEntries) {
        if (ipAddrEntries == null) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : ipAddrEntries) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }

    public static int getIfIndex(List ipAddrEntries, String ipAddress) {
        if (ipAddress == null) {
            return -1;
        }
        for (IpAddrTableEntry ipAddrEntry : ipAddrEntries) {
            InetAddress snmpAddr = ipAddrEntry.getIpAdEntAddr();
            if (!ipAddress.equals(snmpAddr.toString())) continue;
            Integer snmpIpAddrIndex = ipAddrEntry.getIpAdEntIfIndex();
            return snmpIpAddrIndex;
        }
        return -1;
    }

    public static String getNetmask(List ipAddrEntries, int ifIndex) {
        if (ifIndex == -1) {
            return null;
        }
        for (IpAddrTableEntry ipAddrEntry : ipAddrEntries) {
            int ipAddrIndex;
            Integer snmpIpAddrIndex = ipAddrEntry.getIpAdEntIfIndex();
            if (snmpIpAddrIndex == null || (ipAddrIndex = snmpIpAddrIndex.intValue()) != ifIndex) continue;
            InetAddress snmpAddr = ipAddrEntry.getIpAdEntNetMask();
            return snmpAddr == null ? null : snmpAddr.getHostAddress();
        }
        return null;
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        if (this.getEntries() == null) {
            return null;
        }
        for (IpAddrTableEntry entry : this.getEntries()) {
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            InetAddress[] pair = new InetAddress[]{entry.getIpAdEntAddr(), entry.getIpAdEntNetMask()};
            return pair;
        }
        return null;
    }

    public int getIfIndex(InetAddress address) {
        if (this.getEntries() == null) {
            return -1;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getIfIndex: num ipAddrTable entries: " + this.getEntries().size()));
        }
        for (IpAddrTableEntry entry : this.getEntries()) {
            InetAddress ifAddr = entry.getIpAdEntAddr();
            if (ifAddr == null || !ifAddr.equals(address)) continue;
            Integer ndx = entry.getIpAdEntIfIndex();
            this.log().debug((Object)("getIfIndex: got a match for address " + address.getHostAddress() + " index: " + ndx));
            if (ndx == null) continue;
            return ndx;
        }
        this.log().debug((Object)("getIfIndex: no matching ipAddrTable entry for " + address.getHostAddress()));
        return -1;
    }

    protected final Category log() {
        return ThreadCategory.getInstance(IpAddrTable.class);
    }
}

