/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractTcpPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;

public final class FtpPlugin
extends AbstractTcpPlugin {
    private static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final RE MULTILINE_RESULT;
    private static final String PROTOCOL_NAME = "FTP";

    public FtpPlugin() {
        super(PROTOCOL_NAME, 21, 5000, 0);
    }

    protected boolean checkProtocol(Socket socket, ConnectionConfig config) throws IOException {
        boolean isAServer = false;
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String result = null;
            while ((result = lineRdr.readLine()) != null && result.length() > 0 && MULTILINE_RESULT.match(result)) {
            }
            if (result == null || result.length() == 0) {
                log.info((Object)("Received truncated response from ftp server " + config.getInetAddress().getHostAddress()));
                return isAServer;
            }
            StringTokenizer t = new StringTokenizer(result);
            int rc = Integer.parseInt(t.nextToken());
            if (rc > 99 && rc < 600) {
                String cmd = "QUIT\r\n";
                socket.getOutputStream().write(cmd.getBytes());
                while ((result = lineRdr.readLine()) != null && result.length() > 0 && MULTILINE_RESULT.match(result)) {
                }
                if (result == null || result.length() == 0) {
                    log.info((Object)("Received truncated response from ftp server " + config.getInetAddress().getHostAddress()));
                    return isAServer;
                }
                t = new StringTokenizer(result);
                rc = Integer.parseInt(t.nextToken());
                if (rc > 99 && rc < 600) {
                    isAServer = true;
                }
            }
        }
        catch (NumberFormatException e) {
            log.info((Object)("FtpPlugin: received invalid result code from server " + config.getInetAddress().getHostAddress()), (Throwable)e);
            isAServer = false;
        }
        return isAServer;
    }

    static {
        try {
            MULTILINE_RESULT = new RE("^[1-5][0-9]{2}-");
        }
        catch (RESyntaxException re) {
            throw new UndeclaredThrowableException(re);
        }
    }
}

