/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdProtocolInfo;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.common.Range;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager
implements InitializingBean {
    private CapsdConfig m_capsdConfig;
    private Map<String, Plugin> m_pluginsByProtocol = new TreeMap<String, Plugin>();
    private Map<String, Plugin> m_pluginsByClass = new TreeMap<String, Plugin>();

    private void instantiatePlugins() throws ValidationException {
        List<ProtocolPlugin> plugins = this.getCapsdConfig().getProtocolPlugins();
        for (ProtocolPlugin plugin : plugins) {
            try {
                if (this.m_pluginsByClass.containsKey(plugin.getClassName())) {
                    Plugin oplugin = this.m_pluginsByClass.get(plugin.getClassName());
                    this.m_pluginsByProtocol.put(plugin.getProtocol(), oplugin);
                    continue;
                }
                Class<?> cplugin = Class.forName(plugin.getClassName());
                Object oplugin = cplugin.newInstance();
                if (!(oplugin instanceof Plugin)) {
                    throw new ValidationException("CapsdConfigFactory: successfully to load plugin for protocol " + plugin.getProtocol() + ", class-name = " + plugin.getClassName() + ", however the class is not an instance of " + Plugin.class.getName());
                }
                Plugin p = (Plugin)oplugin;
                this.m_pluginsByClass.put(plugin.getClassName(), p);
                this.m_pluginsByProtocol.put(plugin.getProtocol(), p);
            }
            catch (Throwable t) {
                String message = "CapsdConfigFactory: failed to load plugin for protocol " + plugin.getProtocol() + ", class-name = " + plugin.getClassName() + ", exception = " + t;
                this.log().error((Object)message, t);
                throw new ValidationException(message, t);
            }
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public CapsdProtocolInfo[] getProtocolSpecification(InetAddress address) {
        ArrayList<CapsdProtocolInfo> lprotos = new ArrayList<CapsdProtocolInfo>(this.getCapsdConfig().getConfiguration().getProtocolPluginCount());
        List<ProtocolPlugin> plugins = this.getCapsdConfig().getProtocolPlugins();
        block6: for (ProtocolPlugin plugin : plugins) {
            boolean found = false;
            for (ProtocolConfiguration pluginConf : this.getCapsdConfig().getProtocolConfigurations(plugin)) {
                List<String> saddrs = this.getCapsdConfig().getSpecifics(pluginConf);
                Iterator<String> saddrIter = saddrs.iterator();
                while (saddrIter.hasNext() && !found) {
                    String saddr = saddrIter.next();
                    try {
                        InetAddress taddr = InetAddress.getByName(saddr);
                        if (!taddr.equals(address)) continue;
                        found = true;
                    }
                    catch (UnknownHostException e) {
                        this.log().warn((Object)("CapsdConfigFactory: failed to convert address " + saddr + " to InetAddress: " + e), (Throwable)e);
                    }
                }
                long laddr = IPSorter.convertToLong((byte[])address.getAddress());
                List<Range> ranges = this.getCapsdConfig().getRanges(pluginConf);
                Iterator<Range> rangeIter = ranges.iterator();
                while (rangeIter.hasNext() && !found) {
                    Range rng = rangeIter.next();
                    InetAddress start = null;
                    try {
                        start = InetAddress.getByName(rng.getBegin());
                    }
                    catch (UnknownHostException e) {
                        this.log().warn((Object)("CapsdConfigFactory: failed to convert address " + rng.getBegin() + " to InetAddress"), (Throwable)e);
                        continue;
                    }
                    InetAddress stop = null;
                    try {
                        stop = InetAddress.getByName(rng.getEnd());
                    }
                    catch (UnknownHostException e) {
                        this.log().warn((Object)("CapsdConfigFactory: failed to convert address " + rng.getEnd() + " to InetAddress"), (Throwable)e);
                        continue;
                    }
                    if (this.getCapsdConfig().toLong(start) > laddr || laddr > this.getCapsdConfig().toLong(stop)) continue;
                    found = true;
                }
                if (!found) continue;
                String scan = null;
                scan = pluginConf.getScan();
                if (scan != null) {
                    if (scan.equals("enable")) {
                        lprotos.add(new CapsdProtocolInfo(plugin.getProtocol(), this.m_pluginsByProtocol.get(plugin.getProtocol()), null, CapsdProtocolInfo.Action.AUTO_SET));
                        continue block6;
                    }
                    if (scan.equals("off")) {
                        continue block6;
                    }
                } else {
                    scan = plugin.getScan();
                    if (scan != null && scan.equals("off")) continue block6;
                }
                TreeMap<String, String> params = new TreeMap<String, String>();
                this.addProperties(this.getCapsdConfig().getPluginProperties(plugin), params);
                this.addProperties(this.getCapsdConfig().getProtocolConfigurationProperties(pluginConf), params);
                lprotos.add(new CapsdProtocolInfo(plugin.getProtocol(), this.m_pluginsByProtocol.get(plugin.getProtocol()), params, CapsdProtocolInfo.Action.SCAN));
            }
            if (found || "off".equals(plugin.getScan())) continue;
            TreeMap<String, String> params = new TreeMap<String, String>();
            this.addProperties(this.getCapsdConfig().getPluginProperties(plugin), params);
            lprotos.add(new CapsdProtocolInfo(plugin.getProtocol(), this.m_pluginsByProtocol.get(plugin.getProtocol()), params, CapsdProtocolInfo.Action.SCAN));
        }
        CapsdProtocolInfo[] result = new CapsdProtocolInfo[lprotos.size()];
        return lprotos.toArray(result);
    }

    private void addProperties(List<Property> properties, Map<String, String> params) {
        for (Property property : properties) {
            params.put(property.getKey(), property.getValue());
        }
    }

    public CapsdConfig getCapsdConfig() {
        return this.m_capsdConfig;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    public void afterPropertiesSet() throws ValidationException {
        Assert.state((this.m_capsdConfig != null ? 1 : 0) != 0, (String)"property capsdConfig must be set to a non-null value");
        this.instantiatePlugins();
    }
}

