/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.config.xmlrpcd.ExternalServers;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xmlrpcd.BroadcastEventProcessor;
import org.opennms.netmgt.xmlrpcd.EventQueueProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xmlrpcd
extends AbstractServiceDaemon {
    public static final Logger LOG = LoggerFactory.getLogger(Xmlrpcd.class);
    private static final AbstractServiceDaemon m_singleton = new Xmlrpcd();
    private ArrayList<FifoQueue<Event>> m_eventlogQs = new ArrayList();
    private ArrayList<EventQueueProcessor> m_processors = new ArrayList();
    private ArrayList<BroadcastEventProcessor> m_eventReceivers = new ArrayList();
    private OpennmsServerConfigFactory m_serverConfig;
    private XmlrpcdConfigFactory m_config;

    public Xmlrpcd() {
        super("xmlrpcd");
    }

    protected void onInit() {
        LOG.debug("start: Creating the xmlrpc event queue processor");
        try {
            LOG.debug("start: Initializing the xmlrpcd config factory");
            boolean verifyServer = this.getServerConfig().verifyServer();
            String localServer = null;
            if (verifyServer) {
                localServer = this.getServerConfig().getServerName();
            }
            Enumeration servers = this.getConfig().getExternalServerEnumeration();
            int i = 0;
            while (servers.hasMoreElements()) {
                ExternalServers server = (ExternalServers)servers.nextElement();
                XmlrpcServer[] xServers = server.getXmlrpcServer();
                FifoQueueImpl q = new FifoQueueImpl();
                this.m_eventlogQs.add((FifoQueue<Event>)q);
                this.m_eventReceivers.add(new BroadcastEventProcessor(Integer.toString(i), (FifoQueue<Event>)q, this.getConfig().getMaxQueueSize(), this.getConfig().getEventList(server)));
                this.m_processors.add(new EventQueueProcessor((FifoQueue<Event>)q, xServers, server.getRetries(), server.getElapseTime(), verifyServer, localServer, this.getConfig().getMaxQueueSize()));
                ++i;
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to load configuration", t);
            throw new UndeclaredThrowableException(t);
        }
    }

    public XmlrpcdConfigFactory getConfig() throws MarshalException, ValidationException, IOException {
        if (this.m_config == null) {
            this.createConfig();
        }
        return this.m_config;
    }

    public void createConfig() throws MarshalException, ValidationException, IOException {
        XmlrpcdConfigFactory.init();
        this.setConfig(XmlrpcdConfigFactory.getInstance());
    }

    public void setConfig(XmlrpcdConfigFactory config) {
        this.m_config = config;
    }

    public OpennmsServerConfigFactory getServerConfig() throws MarshalException, ValidationException, IOException {
        if (this.m_serverConfig == null) {
            this.createServerConfig();
        }
        return this.m_serverConfig;
    }

    public void createServerConfig() throws MarshalException, ValidationException, IOException {
        OpennmsServerConfigFactory.init();
        this.setServerConfig(OpennmsServerConfigFactory.getInstance());
    }

    public void setServerConfig(OpennmsServerConfigFactory serverConfig) {
        this.m_serverConfig = serverConfig;
    }

    protected void onStart() {
        LOG.debug("start: Initializing the xmlrpcd config factory");
        for (EventQueueProcessor proc : this.m_processors) {
            proc.start();
        }
        LOG.debug("start: xmlrpcd ready to process events");
    }

    protected void onPause() {
        LOG.debug("pause: Calling pause on processor");
        for (EventQueueProcessor proc : this.m_processors) {
            proc.pause();
        }
        LOG.debug("pause: Processor paused");
    }

    protected void onResume() {
        LOG.debug("resume: Calling resume on processor");
        for (EventQueueProcessor proc : this.m_processors) {
            proc.resume();
        }
        LOG.debug("resume: Processor resumed");
    }

    protected void onStop() {
        LOG.debug("stop: Calling stop on processor");
        for (EventQueueProcessor proc : this.m_processors) {
            proc.stop();
        }
        LOG.debug("stop: Processor stopped");
    }

    public static AbstractServiceDaemon getInstance() {
        return m_singleton;
    }
}

