/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xmlrpcd.TimeoutSecureXmlRpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class XmlRpcNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(XmlRpcNotifier.class);
    private static final String XMLRPC_SERVER_SUCCESS_COMMAND = "notifySuccess";
    private static final String XMLRPC_SERVER_FAILURE_COMMAND = "notifyFailure";
    private static final String XMLRPC_SERVER_RECEIVE_EVENT_COMMAND = "notifyReceivedEvent";
    private static final String XMLRPC_SERVICE_UP_COMMAND = "sendServiceUpEvent";
    private static final String XMLRPC_SERVICE_DOWN_COMMAND = "sendServiceDownEvent";
    private static final String XMLRPC_NODE_UP_COMMAND = "sendNodeUpEvent";
    private static final String XMLRPC_NODE_DOWN_COMMAND = "sendNodeDownEvent";
    private static final String XMLRPC_INTERFACE_UP_COMMAND = "sendInterfaceUpEvent";
    private static final String XMLRPC_INTERFACE_DOWN_COMMAND = "sendInterfaceDownEvent";
    private static final String XMLRPC_GENERIC_COMMAND = "sendEvent";
    private static final String XMLRPC_SNMP_TRAP_COMMAND = "sendSnmpTrapEvent";
    private XmlrpcServer[] m_rpcServers;
    private int m_retries;
    private int m_elapseTime;
    private XmlRpcClient m_xmlrpcClient;
    private boolean m_verifyServer;
    private String m_localServer;

    public XmlRpcNotifier(XmlrpcServer[] rpcServers, int retries, int elapseTime, boolean verifyServer, String localServer) {
        this.m_rpcServers = Arrays.copyOf(rpcServers, rpcServers.length);
        this.m_retries = retries;
        this.m_elapseTime = elapseTime;
        this.createConnection();
        this.m_verifyServer = verifyServer;
        if (this.m_verifyServer) {
            this.m_localServer = localServer;
        }
    }

    public boolean notifySuccess(long txNo, String uei, String message) {
        Assert.notNull((Object)uei, (String)"uei must not be null");
        Assert.notNull((Object)message, (String)"message must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(txNo));
        params.addElement(uei);
        params.addElement(message);
        return this.sendXmlrpcRequest(XMLRPC_SERVER_SUCCESS_COMMAND, params);
    }

    public boolean notifyFailure(long txNo, String uei, String reason) {
        Assert.notNull((Object)uei, (String)"uei must not be null");
        Assert.notNull((Object)reason, (String)"reason must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(txNo));
        params.addElement(uei);
        params.addElement(reason);
        return this.sendXmlrpcRequest(XMLRPC_SERVER_FAILURE_COMMAND, params);
    }

    public boolean notifyReceivedEvent(long txNo, String uei, String message) {
        Assert.notNull((Object)uei, (String)"uei must not be null");
        Assert.notNull((Object)message, (String)"message must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(txNo));
        params.addElement(uei);
        params.addElement(message);
        return this.sendXmlrpcRequest(XMLRPC_SERVER_RECEIVE_EVENT_COMMAND, params);
    }

    public boolean sendServiceDownEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(event.getService()));
        params.addElement(String.valueOf("Not Available"));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_SERVICE_DOWN_COMMAND, params);
    }

    private String getEventHost(Event event) {
        return this.m_verifyServer ? this.m_localServer : event.getHost();
    }

    public boolean sendServiceUpEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(event.getService()));
        params.addElement(String.valueOf("Not Available"));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_SERVICE_UP_COMMAND, params);
    }

    public boolean sendInterfaceDownEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_INTERFACE_DOWN_COMMAND, params);
    }

    public boolean sendInterfaceUpEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(event.getHost()));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_INTERFACE_UP_COMMAND, params);
    }

    public boolean sendNodeDownEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_NODE_DOWN_COMMAND, params);
    }

    public boolean sendNodeUpEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_NODE_UP_COMMAND, params);
    }

    public boolean sendEvent(Event event) {
        List eventParams;
        String severity;
        String descr;
        String service;
        String host;
        String label;
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        Hashtable<String, String> table = new Hashtable<String, String>();
        params.addElement(table);
        String source = event.getSource();
        if (source != null) {
            table.put("source", source);
        }
        if ((label = this.getLabelForEventNode(event)) != null) {
            table.put("nodeLabel", label);
        }
        if ((host = this.getEventHost(event)) != null) {
            table.put("host", host);
        }
        table.put("time", String.valueOf(event.getTime()));
        table.put("uei", String.valueOf(event.getUei()));
        table.put("nodeId", Long.toString(event.getNodeid()));
        String intf = event.getInterface();
        if (intf != null) {
            table.put("interface", intf);
        }
        if ((service = event.getService()) != null) {
            table.put("service", service);
        }
        if ((descr = event.getDescr()) != null) {
            table.put("description", descr);
        }
        if ((severity = event.getSeverity()) != null) {
            table.put("severity", event.getSeverity());
        }
        if ((eventParams = event.getParmCollection()) != null) {
            int numParams = eventParams.size();
            for (int i = 0; i < numParams; ++i) {
                Parm p = (Parm)eventParams.get(i);
                Value v = p.getValue();
                table.put("param" + i + " name", p.getParmName());
                table.put("param" + i + " type", v.getType());
                table.put("param" + i + " value", v.getContent());
            }
        }
        if (event.getSnmp() == null) {
            return this.sendXmlrpcRequest(XMLRPC_GENERIC_COMMAND, params);
        }
        Snmp trapInfo = event.getSnmp();
        table.put("communityString", String.valueOf(trapInfo.getCommunity()));
        table.put("genericTrapNumber", Integer.toString(trapInfo.getGeneric()));
        table.put("enterpriseId", String.valueOf(trapInfo.getId()));
        if (trapInfo.getIdtext() != null) {
            table.put("enterpriseIdText", trapInfo.getIdtext());
        }
        table.put("specificTrapNumber", Integer.toString(trapInfo.getSpecific()));
        table.put("timeStamp", Long.toString(trapInfo.getTimeStamp()));
        table.put("version", String.valueOf(trapInfo.getVersion()));
        return this.sendXmlrpcRequest(XMLRPC_SNMP_TRAP_COMMAND, params);
    }

    private String getLabelForEventNode(Event event) {
        return this.getNodeLabel(event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNodeLabel(long nodeId) {
        Connection dbConn = null;
        String nodeLabel = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)dbConn);
            LOG.debug("getNodeLabel: retrieve node label for: {}", (Object)nodeId);
            PreparedStatement stmt = dbConn.prepareStatement("SELECT nodelabel FROM NODE WHERE nodeid = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodeLabel = rs.getString(1);
            }
        }
        catch (SQLException sqle) {
            LOG.warn("SQL exception while retrieving nodeLabel for: {}", (Object)nodeId, (Object)sqle);
        }
        finally {
            d.cleanUp();
        }
        LOG.debug("getNodeLabel: retrieved node label '{}' for: {}", nodeLabel, (Object)nodeId);
        return nodeLabel;
    }

    private boolean sendXmlrpcRequest(String command, Vector<Object> params) {
        if (this.m_xmlrpcClient == null) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < this.m_retries; ++i) {
            try {
                Object reply = this.m_xmlrpcClient.execute(command, params);
                LOG.debug("Response from XMLRPC server: {}\n\t{}", (Object)this.m_xmlrpcClient.getURL(), reply);
                success = true;
            }
            catch (XmlRpcException e) {
                LOG.warn("Failed to send message to XMLRPC server {}", (Object)this.m_xmlrpcClient.getURL(), (Object)e);
            }
            catch (ConnectException e) {
                LOG.warn("Failed to send message to XMLRPC server {} due to connect exception", (Object)this.m_xmlrpcClient.getURL(), (Object)e);
            }
            catch (IOException e) {
                LOG.warn("Failed to send message to XMLRPC server {}", (Object)this.m_xmlrpcClient.getURL(), (Object)e);
            }
            catch (Throwable t) {
                LOG.error("Received unknown error.", t);
            }
            if (success) break;
        }
        if (!success) {
            LOG.error("Could not successfully communicate with XMLRPC server '{}' after {} tries", (Object)this.m_xmlrpcClient.getURL(), (Object)this.m_retries);
        }
        return success;
    }

    public void createConnection() {
        Vector<String> params = new Vector<String>();
        params.addElement(Long.toString(0L));
        params.addElement("uei.opennms.org/internal/capsd/xmlrpcNotification");
        params.addElement("test connection");
        boolean success = false;
        for (int i = 0; i < this.m_rpcServers.length; ++i) {
            XmlrpcServer xServer = this.m_rpcServers[i];
            String url = xServer.getUrl();
            int timeout = xServer.getTimeout();
            LOG.debug("Start to set up communication to XMLRPC server: {}", (Object)url);
            LOG.debug("Setting timeout value to: {}", (Object)timeout);
            try {
                this.m_xmlrpcClient = new TimeoutSecureXmlRpcClient(url, timeout);
            }
            catch (MalformedURLException e) {
                LOG.error("Failed to send message to XMLRPC server: {}", (Object)url, (Object)e);
                continue;
            }
            for (int k = 0; k < this.m_retries; ++k) {
                try {
                    Object reply = this.m_xmlrpcClient.execute(XMLRPC_SERVER_RECEIVE_EVENT_COMMAND, params);
                    LOG.debug("Response from XMLRPC server: {}\n\t{}", (Object)url, reply);
                    success = true;
                }
                catch (XmlRpcException e) {
                    LOG.warn("Failed to send message to XMLRPC server: {}", (Object)url, (Object)e);
                }
                catch (ConnectException e) {
                    LOG.warn("Failed to send message to XMLRPC server {} due to connect exception", (Object)url, (Object)e);
                }
                catch (IOException e) {
                    LOG.warn("Failed to send message to XMLRPC server: {}", (Object)url, (Object)e);
                }
                if (success) break;
                try {
                    Thread.sleep(this.m_elapseTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    LOG.info("Interrupted while waiting to retry.", (Throwable)ie);
                }
            }
            if (success) break;
        }
        if (!success) {
            LOG.error("Can not set up communication with any XMLRPC server");
            this.m_xmlrpcClient = null;
        }
    }
}

