/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Statement;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.vacuumd.AutomationInterval;
import org.opennms.netmgt.vacuumd.AutomationProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vacuumd
extends AbstractServiceDaemon
implements Runnable,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Vacuumd.class);
    private static volatile Vacuumd m_singleton;
    private volatile Thread m_thread;
    private volatile long m_startTime;
    private volatile boolean m_stopped = false;
    private volatile LegacyScheduler m_scheduler;
    private volatile EventIpcManager m_eventMgr;

    public static synchronized Vacuumd getSingleton() {
        if (m_singleton == null) {
            m_singleton = new Vacuumd();
        }
        return m_singleton;
    }

    public Vacuumd() {
        super("vacuumd");
    }

    protected void onInit() {
        try {
            LOG.info("Loading the configuration file.");
            VacuumdConfigFactory.init();
            this.getEventManager().addEventListener((EventListener)this, "uei.opennms.org/internal/reloadVacuumdConfig");
            this.getEventManager().addEventListener((EventListener)this, "uei.opennms.org/internal/reloadDaemonConfig");
            this.initializeDataSources();
        }
        catch (Throwable ex) {
            LOG.error("Failed to load outage configuration", ex);
            throw new UndeclaredThrowableException(ex);
        }
        LOG.info("Vacuumd initialization complete");
        this.createScheduler();
        this.scheduleAutomations();
    }

    private void initializeDataSources() throws MarshalException, ValidationException, IOException, ClassNotFoundException, PropertyVetoException, SQLException {
        for (Trigger trigger : this.getVacuumdConfig().getTriggers()) {
            DataSourceFactory.init((String)trigger.getDataSource());
        }
        for (Action action : this.getVacuumdConfig().getActions()) {
            DataSourceFactory.init((String)action.getDataSource());
        }
    }

    protected void onStart() {
        this.m_startTime = System.currentTimeMillis();
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.start();
    }

    protected void onStop() {
        this.m_stopped = true;
        if (this.m_scheduler != null) {
            this.m_scheduler.stop();
        }
    }

    protected void onPause() {
        this.m_scheduler.pause();
        this.m_stopped = true;
    }

    protected void onResume() {
        this.m_thread = new Thread((Runnable)this, "Vacuumd-Thread");
        this.m_thread.start();
        this.m_scheduler.resume();
    }

    @Override
    public void run() {
        LOG.info("Vacuumd scheduling started");
        long now = System.currentTimeMillis();
        long period = this.getVacuumdConfig().getPeriod();
        LOG.info("Vacuumd sleeping until time to execute statements period = {}", (Object)period);
        long waitTime = 500L;
        while (!this.m_stopped) {
            try {
                now = this.waitPeriod(now, period, waitTime);
                LOG.info("Vacuumd beginning to execute statements");
                this.executeStatements();
                this.m_startTime = System.currentTimeMillis();
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception", e);
            }
        }
    }

    protected void executeStatements() {
        if (!this.m_stopped) {
            List statements = this.getVacuumdConfig().getStatements();
            for (Statement statement : statements) {
                this.runUpdate(statement.getContent(), statement.getTransactional());
            }
        }
    }

    private long waitPeriod(long now, long period, long waitTime) {
        int count = 0;
        while (!this.m_stopped && now - this.m_startTime < period) {
            try {
                if (count % 100 == 0) {
                    LOG.debug("Vacuumd: {}ms remaining to execution.", (Object)(period - now + this.m_startTime));
                }
                Thread.sleep(waitTime);
                now = System.currentTimeMillis();
                ++count;
            }
            catch (InterruptedException e) {}
        }
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runUpdate(String sql, boolean transactional) {
        LOG.info("Vacuumd executing statement: {}", (Object)sql);
        Connection dbConn = null;
        boolean commitRequired = false;
        boolean autoCommitFlag = !transactional;
        try {
            dbConn = this.getDataSourceFactory().getConnection();
            dbConn.setAutoCommit(autoCommitFlag);
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            int count = stmt.executeUpdate();
            stmt.close();
            LOG.debug("Vacuumd: Ran update {}: this affected {} rows", (Object)sql, (Object)count);
            commitRequired = transactional;
            return;
        }
        catch (SQLException ex) {
            LOG.error("Vacuumd:  Database error execuating statement {}", (Object)sql, (Object)ex);
            return;
        }
        finally {
            block38: {
                if (dbConn == null) break block38;
                try {
                    if (commitRequired) {
                        dbConn.commit();
                    } else if (transactional) {
                        dbConn.rollback();
                    }
                    if (dbConn == null) break block38;
                }
                catch (SQLException ex) {
                    if (dbConn == null) break block38;
                    try {
                        dbConn.close();
                    }
                    catch (Throwable e) {}
                    break block38;
                    catch (Throwable throwable) {
                        if (dbConn == null) throw throwable;
                        try {
                            dbConn.close();
                            throw throwable;
                        }
                        catch (Throwable e) {}
                    }
                }
                try {
                    dbConn.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private void createScheduler() {
        try {
            LOG.debug("init: Creating Vacuumd scheduler");
            this.m_scheduler = new LegacyScheduler("Vacuumd", 2);
        }
        catch (RuntimeException e) {
            LOG.error("init: Failed to create Vacuumd scheduler", (Throwable)e);
            throw e;
        }
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    private void scheduleAutomations() {
        for (Automation auto : this.getVacuumdConfig().getAutomations()) {
            this.scheduleAutomation(auto);
        }
    }

    private void scheduleAutomation(Automation auto) {
        if (auto.getActive()) {
            AutomationProcessor ap = new AutomationProcessor(auto);
            Schedule s = new Schedule(ap, new AutomationInterval(auto.getInterval()), this.m_scheduler);
            ap.setSchedule(s);
            s.schedule();
        }
    }

    public EventIpcManager getEventManager() {
        return this.m_eventMgr;
    }

    public void setEventManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public void onEvent(Event event) {
        if (this.isReloadConfigEvent(event)) {
            this.handleReloadConifgEvent();
        }
    }

    private void handleReloadConifgEvent() {
        LOG.info("onEvent: reloading configuration...");
        EventBuilder ebldr = null;
        try {
            LOG.debug("onEvent: Number of elements in schedule:{}; calling stop on scheduler...", (Object)this.m_scheduler.getScheduled());
            this.stop();
            ExecutorService runner = this.m_scheduler.getRunner();
            while (!runner.isShutdown() || this.m_scheduler.getStatus() != 4) {
                LOG.debug("onEvent: waiting for scheduler to stop. Current status of scheduler: {}; Current status of runner: {}", (Object)this.m_scheduler.getStatus(), (Object)(runner.isTerminated() ? "TERMINATED" : (runner.isShutdown() ? "SHUTDOWN" : "RUNNING")));
                Thread.sleep(500L);
            }
            LOG.debug("onEvent: Current status of scheduler: {}; Current status of runner: {}", (Object)this.m_scheduler.getStatus(), (Object)(runner.isTerminated() ? "TERMINATED" : (runner.isShutdown() ? "SHUTDOWN" : "RUNNING")));
            LOG.debug("onEvent: Number of elements in schedule: {}", (Object)this.m_scheduler.getScheduled());
            LOG.debug("onEvent: reloading vacuumd configuration.");
            VacuumdConfigFactory.reload();
            LOG.debug("onEvent: creating new schedule and rescheduling automations.");
            this.init();
            LOG.debug("onEvent: restarting vacuumd and scheduler.");
            this.start();
            LOG.debug("onEvent: Number of elements in schedule: {}", (Object)this.m_scheduler.getScheduled());
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
        }
        catch (IOException e) {
            LOG.error("onEvent: IO problem reading vacuumd configuration", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        catch (InterruptedException e) {
            LOG.error("onEvent: Problem interrupting current Vacuumd Thread", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", "Vacuumd");
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        LOG.info("onEvent: completed configuration reload.");
        if (ebldr != null) {
            this.m_eventMgr.sendNow(ebldr.getEvent());
        }
    }

    private boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Vacuumd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
        } else if ("uei.opennms.org/internal/reloadVacuumdConfig".equals(event.getUei())) {
            isTarget = true;
        }
        return isTarget;
    }

    public long getNumAutomations() {
        if (this.m_scheduler != null) {
            return this.m_scheduler.getNumTasksExecuted();
        }
        return 0L;
    }

    private VacuumdConfigFactory getVacuumdConfig() {
        return VacuumdConfigFactory.getInstance();
    }

    private DataSource getDataSourceFactory() {
        return DataSourceFactory.getInstance();
    }
}

