/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.ArrayList;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);

    BroadcastEventProcessor() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        LOG.debug("Received event: {}", (Object)eventUei);
        if (eventUei.equals("uei.opennms.org/nodes/nodeGainedInterface")) {
            if (Long.toString(event.getNodeid()) != null && event.getInterface() != null) {
                SyslogdIPMgr.setNodeId(event.getInterface(), event.getNodeid());
            }
            LOG.debug("Added {} to known node list", (Object)event.getInterface());
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getInterface() != null) {
                SyslogdIPMgr.removeNodeId(event.getInterface());
            }
            LOG.debug("Removed {} from known node list", (Object)event.getInterface());
        } else if (eventUei.equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (Long.toString(event.getNodeid()) != null && event.getInterface() != null) {
                SyslogdIPMgr.setNodeId(event.getInterface(), event.getNodeid());
            }
            LOG.debug("Reparented {} to known node list", (Object)event.getInterface());
        }
    }

    public String getName() {
        return "Syslogd:BroadcastEventProcessor";
    }
}

