/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class HttpPostMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    public static final String DEFAULT_MIMETYPE = "text/xml";
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final String DEFAULT_URI = "/";
    public static final String DEFAULT_SCHEME = "http";
    public static final boolean DEFAULT_SSLFILTER = false;
    public static final String PARAMETER_SCHEME = "scheme";
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_URI = "uri";
    public static final String PARAMETER_PAYLOAD = "payload";
    public static final String PARAMETER_MIMETYPE = "mimetype";
    public static final String PARAMETER_CHARSET = "charset";
    public static final String PARAMETER_BANNER = "banner";
    public static final String PARAMETER_SSLFILTER = "usesslfiler";
    public static final String PARAMETER_USERNAME = "auth-username";
    public static final String PARAMETER_PASSWORD = "auth-password";
    private static final Logger LOG = LoggerFactory.getLogger(HttpPostMonitor.class);

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_PORT, (int)80);
        String strURI = ParameterMap.getKeyedString(parameters, (String)PARAMETER_URI, (String)DEFAULT_URI);
        String strUser = ParameterMap.getKeyedString(parameters, (String)PARAMETER_USERNAME, null);
        String strPasswd = ParameterMap.getKeyedString(parameters, (String)PARAMETER_PASSWORD, null);
        String strBannerMatch = ParameterMap.getKeyedString(parameters, (String)PARAMETER_BANNER, null);
        String strScheme = ParameterMap.getKeyedString(parameters, (String)PARAMETER_SCHEME, (String)DEFAULT_SCHEME);
        String strPayload = ParameterMap.getKeyedString(parameters, (String)PARAMETER_PAYLOAD, null);
        String strMimetype = ParameterMap.getKeyedString(parameters, (String)PARAMETER_MIMETYPE, (String)DEFAULT_MIMETYPE);
        String strCharset = ParameterMap.getKeyedString(parameters, (String)PARAMETER_CHARSET, (String)DEFAULT_CHARSET);
        boolean boolSSLFilter = ParameterMap.getKeyedBoolean(parameters, (String)PARAMETER_SSLFILTER, (boolean)false);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("poll: address = " + hostAddress + ", port = " + port + ", " + tracker);
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            block13: {
                String reason;
                try {
                    StringEntity postReq;
                    tracker.startAttempt();
                    BasicHttpParams clientParams = new BasicHttpParams();
                    clientParams.setIntParameter("http.connection.timeout", tracker.getSoTimeout());
                    clientParams.setIntParameter("http.socket.timeout", tracker.getSoTimeout());
                    DefaultHttpClient client = new DefaultHttpClient((HttpParams)clientParams);
                    client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
                    if (boolSSLFilter) {
                        client.getConnectionManager().getSchemeRegistry().register(new Scheme(strScheme, port, (SchemeSocketFactory)new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy(), (X509HostnameVerifier)new AllowAllHostnameVerifier())));
                    }
                    if (strUser != null && strPasswd != null) {
                        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(strUser, strPasswd);
                        client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
                    }
                    try {
                        postReq = new StringEntity(strPayload, strMimetype, strCharset);
                    }
                    catch (UnsupportedEncodingException e) {
                        serviceStatus = PollStatus.unavailable((String)("Unsupported encoding encountered while constructing POST body " + e));
                        break;
                    }
                    URIBuilder ub = new URIBuilder();
                    ub.setScheme(strScheme);
                    ub.setHost(hostAddress);
                    ub.setPort(port);
                    ub.setPath(strURI);
                    LOG.debug("HttpPostMonitor: Constructed URL is " + ub.toString());
                    HttpPost post = new HttpPost(ub.build());
                    post.setEntity((HttpEntity)postReq);
                    HttpResponse response = client.execute((HttpUriRequest)post);
                    LOG.debug("HttpPostMonitor: Status Line is " + response.getStatusLine());
                    if (response.getStatusLine().getStatusCode() > 399) {
                        LOG.info("HttpPostMonitor: Got response status code " + response.getStatusLine().getStatusCode());
                        LOG.debug("HttpPostMonitor: Received server response: " + response.getStatusLine());
                        LOG.debug("HttpPostMonitor: Failing on bad status code");
                        serviceStatus = PollStatus.unavailable((String)("HTTP(S) Status code " + response.getStatusLine().getStatusCode()));
                        break;
                    }
                    LOG.debug("HttpPostMonitor: Response code is valid");
                    double responseTime = tracker.elapsedTimeInMillis();
                    HttpEntity entity = response.getEntity();
                    InputStream responseStream = entity.getContent();
                    String Strresponse = IOUtils.toString((InputStream)responseStream);
                    if (Strresponse == null) break block13;
                    LOG.debug("HttpPostMonitor: banner = " + Strresponse);
                    LOG.debug("HttpPostMonitor: responseTime= " + responseTime + "ms");
                    if (strBannerMatch.charAt(0) == '~') {
                        if (!Strresponse.matches(strBannerMatch.substring(1))) {
                            serviceStatus = PollStatus.unavailable((String)("Banner does not match Regex '" + strBannerMatch + "'"));
                            break;
                        }
                        serviceStatus = PollStatus.available((Double)responseTime);
                        break block13;
                    }
                    if (Strresponse.indexOf(strBannerMatch) > -1) {
                        serviceStatus = PollStatus.available((Double)responseTime);
                        break block13;
                    }
                    serviceStatus = PollStatus.unavailable((String)("Did not find expected Text '" + strBannerMatch + "'"));
                }
                catch (URISyntaxException e) {
                    reason = "URISyntaxException for URI: " + strURI + " " + e.getMessage();
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (Exception e) {
                    reason = "Exception: " + e.getMessage();
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                break;
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

