/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.api.DemandPollDao;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PollerEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(PollerEventProcessor.class);
    private final Poller m_poller;
    private volatile DemandPollDao m_demandPollDao;

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeLabelChanged");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/internal/poller/suspendPollingService");
        ueiList.add("uei.opennms.org/internal/poller/resumePollingService");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/demandPollService");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        ueiList.add("uei.opennms.org/nodes/assetInfoChanged");
        ueiList.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        this.getEventManager().addEventListener((EventListener)this, ueiList);
    }

    private void nodeGainedServiceHandler(Event event) {
        String ipAddr = event.getInterface();
        Long nodeId = event.getNodeid();
        String svcName = event.getService();
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        try {
            nodeLabel = this.getPoller().getQueryManager().getNodeLabel(nodeId.intValue());
        }
        catch (Exception e) {
            LOG.error("Unable to retrieve nodeLabel for node {}", (Object)nodeId, (Object)e);
        }
        this.getPoller().scheduleService(nodeId.intValue(), nodeLabel, ipAddr, svcName);
    }

    private void interfaceReparentedHandler(Event event) {
        LOG.debug("interfaceReparentedHandler: processing interfaceReparented event for {}", (Object)event.getInterface());
        if (event.getInterfaceAddress() == null) {
            return;
        }
        InetAddress ipAddr = event.getInterfaceAddress();
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                oldNodeIdStr = parmContent;
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            newNodeIdStr = parmContent;
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            LOG.error("interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        try {
            PollableNode oldNode = this.getNetwork().getNode(Integer.parseInt(oldNodeIdStr));
            if (oldNode == null) {
                LOG.error("interfaceReparentedHandler: Cannot locate old node {} belonging to interface {}", oldNodeIdStr, (Object)ipAddr);
                return;
            }
            PollableNode newNode = this.getNetwork().getNode(Integer.parseInt(newNodeIdStr));
            if (newNode == null) {
                LOG.error("interfaceReparentedHandler: Cannot locate new node {} to move interface to.  Also, grammar error: ended a sentence with a preposition.", (Object)newNodeIdStr);
                return;
            }
            PollableInterface iface = oldNode.getInterface(ipAddr);
            if (iface == null) {
                LOG.error("interfaceReparentedHandler: Cannot locate interface with ipAddr {} to reparent.", (Object)ipAddr);
                return;
            }
            iface.reparentTo(newNode);
        }
        catch (NumberFormatException nfe) {
            LOG.error("interfaceReparentedHandler: failed converting old/new nodeid parm to integer, unable to process.");
            return;
        }
    }

    private void nodeRemovePollableServiceHandler(Event event) {
        Long nodeId = event.getNodeid();
        InetAddress ipAddr = event.getInterfaceAddress();
        String svcName = event.getService();
        if (svcName == null) {
            LOG.error("nodeRemovePollableServiceHandler: service name is null, ignoring event");
            return;
        }
        PollableService svc = this.getNetwork().getService(nodeId.intValue(), ipAddr, svcName);
        svc.delete();
    }

    private void nodeDeletedHandler(Event event) {
        Date closeDate;
        Long nodeId = event.getNodeid();
        String sourceUei = event.getUei();
        long txNo = -1L;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("txno")) continue;
            String temp = parmContent;
            LOG.debug("nodeDeletedHandler:  parmName: {} /parmContent: {}", (Object)parmName, (Object)parmContent);
            try {
                txNo = Long.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("nodeDeletedHandler: Parameter {} cannot be non-numeric", (Object)"txno", (Object)nfe);
                txNo = -1L;
            }
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().getQueryManager().closeOutagesForNode(closeDate, event.getDbid(), nodeId.intValue());
        PollableNode node = this.getNetwork().getNode(nodeId.intValue());
        if (node == null) {
            LOG.error("Nodeid {} does not exist in pollable node map, unable to delete node.", (Object)nodeId);
            if (this.isXmlRPCEnabled()) {
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, sourceUei, "Node does not exist in pollable node map.", status, "OpenNMS.Poller");
            }
            return;
        }
        node.delete();
    }

    private void nodeLabelChangedHandler(Event event) {
        Long nodeId = event.getNodeid();
        for (Parm parm : event.getParmCollection()) {
            String parmName = parm.getParmName();
            Value parmValue = parm.getValue();
            if (parmValue == null || !parmName.equals("nodelabel")) continue;
            String label = parmValue.getContent();
            LOG.debug("nodeLabelChangedHandler: parmName: {} /parmContent: {}", (Object)parmName, (Object)label);
            PollableNode node = this.getNetwork().getNode(nodeId.intValue());
            if (node == null) {
                LOG.warn("nodeLabelChangedHandler: nodeid {} does not exist in pollable node map, unable to update node label.", (Object)nodeId);
                continue;
            }
            node.setNodeLabel(label);
            return;
        }
    }

    private void interfaceDeletedHandler(Event event) {
        Date closeDate;
        Long nodeId = event.getNodeid();
        String sourceUei = event.getUei();
        InetAddress ipAddr = event.getInterfaceAddress();
        long txNo = -1L;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("txno")) continue;
            String temp = parmContent;
            LOG.debug("interfaceDeletedHandlerHandler:  parmName: {} /parmContent: {}", (Object)parmName, (Object)parmContent);
            try {
                txNo = Long.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("interfaceDeletedHandlerHandler: Parameter {} cannot be non-numberic", (Object)"txno", (Object)nfe);
                txNo = -1L;
            }
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().getQueryManager().closeOutagesForInterface(closeDate, event.getDbid(), nodeId.intValue(), InetAddressUtils.str((InetAddress)ipAddr));
        PollableInterface iface = this.getNetwork().getInterface(nodeId.intValue(), ipAddr);
        if (iface == null) {
            LOG.error("Interface {}/{} does not exist in pollable node map, unable to delete node.", (Object)nodeId, (Object)event.getInterface());
            if (this.isXmlRPCEnabled()) {
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, sourceUei, "Interface does not exist in pollable node map.", status, "OpenNMS.Poller");
            }
            return;
        }
        iface.delete();
    }

    private void serviceDeletedHandler(Event event) {
        Date closeDate;
        Long nodeId = event.getNodeid();
        InetAddress ipAddr = event.getInterfaceAddress();
        String service = event.getService();
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().getQueryManager().closeOutagesForService(closeDate, event.getDbid(), nodeId.intValue(), InetAddressUtils.str((InetAddress)ipAddr), service);
        PollableService svc = this.getNetwork().getService(nodeId.intValue(), ipAddr, service);
        if (svc == null) {
            LOG.error("Interface {}/{} does not exist in pollable node map, unable to delete node.", (Object)nodeId, (Object)event.getInterface());
            return;
        }
        svc.delete();
    }

    PollerEventProcessor(Poller poller) {
        this.m_poller = poller;
        this.createMessageSelectorAndSubscribe();
        LOG.debug("Subscribed to eventd");
    }

    public void close() {
        this.getEventManager().removeEventListener((EventListener)this);
    }

    private EventIpcManager getEventManager() {
        return this.getPoller().getEventManager();
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        LOG.debug("PollerEventProcessor: received event, uei = {}", (Object)event.getUei());
        if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
            LOG.info("Reloading poller config factory and polloutages config factory");
            this.scheduledOutagesChangeHandler();
        } else if (event.getUei().equals("uei.opennms.org/internal/thresholdConfigChange")) {
            LOG.info("Reloading thresholding configuration in pollerd");
            this.thresholdsConfigChangeHandler();
        } else if (!event.hasNodeid()) {
            LOG.info("PollerEventProcessor: no database node id found, discarding event");
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/resumePollingService")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, cannot resume polling service, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/suspendPollingService")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, cannot suspend polling service, discarding event");
            } else {
                this.nodeRemovePollableServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, discarding event");
            } else {
                this.interfaceReparentedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLabelChanged")) {
            if (event.getNodeid() < 0L) {
                LOG.info("PollerEventProcessor: no node or interface found, discarding event");
            }
            this.nodeLabelChangedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted") || event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
            if (event.getNodeid() < 0L) {
                LOG.info("PollerEventProcessor: no node or interface found, discarding event");
            }
            this.nodeDeletedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null) {
                LOG.info("PollerEventProcessor: invalid nodeid or no interface found, discarding event");
            } else {
                this.interfaceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null || event.getService() == null) {
                LOG.info("PollerEventProcessor: invalid nodeid or no nodeinterface or service found, discarding event");
            } else {
                this.serviceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
            if (event.getNodeid() >= 0L) {
                this.serviceReschedule(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/assetInfoChanged") && event.getNodeid() >= 0L) {
            this.serviceReschedule(event);
        }
    }

    private void serviceReschedule(Event event) {
        PollableNode pnode = this.getNetwork().getNode(event.getNodeid().intValue());
        Long nodeId = event.getNodeid();
        String nodeLabel = pnode.getNodeLabel();
        List<String[]> list = this.getPoller().getQueryManager().getNodeServices(nodeId.intValue());
        for (String[] row : list) {
            Date closeDate;
            LOG.debug(" Removing the following from the list: {}:{}", (Object)row[0], (Object)row[1]);
            InetAddress addr = InetAddressUtils.addr((String)row[0]);
            if (addr == null) {
                LOG.warn("Rescheduler: Could not convert {} to an InetAddress", (Object)row[0]);
                return;
            }
            try {
                closeDate = EventConstants.parseToDate((String)event.getTime());
            }
            catch (ParseException e) {
                closeDate = new Date();
            }
            this.getPoller().getQueryManager().closeOutagesForService(closeDate, event.getDbid(), nodeId.intValue(), row[0], row[1]);
            PollableService svc = this.getNetwork().getService(nodeId.intValue(), addr, row[1]);
            if (svc != null) {
                svc.delete();
                while (!svc.isDeleted()) {
                    LOG.debug("Waiting for the service to delete...");
                }
                continue;
            }
            LOG.debug("Service Not Found");
        }
        this.getPoller().getPollerConfig().rebuildPackageIpListMap();
        for (String[] row : list) {
            LOG.debug(" Re-adding the following to the list: {}:{}", (Object)row[0], (Object)row[1]);
            this.getPoller().scheduleService(nodeId.intValue(), nodeLabel, row[0], row[1]);
        }
    }

    private void demandPollServiceHandler(Event e) throws InsufficientInformationException {
        EventUtils.checkNodeId(e);
        EventUtils.checkInterface(e);
        EventUtils.checkService(e);
        EventUtils.requireParm(e, "demandPollId");
        this.m_demandPollDao.get((Serializable)Integer.valueOf(EventUtils.getIntParm(e, "demandPollId", -1)));
    }

    private void scheduledOutagesChangeHandler() {
        try {
            this.getPollerConfig().update();
            this.getPoller().getPollOutagesConfig().update();
        }
        catch (Throwable e) {
            LOG.error("Failed to reload PollerConfigFactory", e);
        }
        this.getPoller().refreshServicePackages();
    }

    private void thresholdsConfigChangeHandler() {
        this.getPoller().refreshServiceThresholds();
    }

    public String getName() {
        return "Poller:PollerEventProcessor";
    }

    private Poller getPoller() {
        return this.m_poller;
    }

    private PollerConfig getPollerConfig() {
        return this.getPoller().getPollerConfig();
    }

    private PollableNetwork getNetwork() {
        return this.getPoller().getNetwork();
    }

    private boolean isXmlRPCEnabled() {
        return this.getPollerConfig().shouldNotifyXmlrpc();
    }
}

