/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class MicroblogAuthorization {
    private final Twitter m_twitter;
    private final RequestToken m_requestToken;

    public MicroblogAuthorization(Twitter twitter) throws MicroblogAuthorizationException {
        this.m_twitter = twitter;
        try {
            this.m_requestToken = twitter.getOAuthRequestToken();
        }
        catch (TwitterException e) {
            throw new MicroblogAuthorizationException("Unable to get OAuth request token", e);
        }
    }

    public String getUrl() {
        return this.m_requestToken.getAuthenticationURL();
    }

    public AccessToken retrieveToken() throws MicroblogAuthorizationException {
        try {
            return this.m_twitter.getOAuthAccessToken(this.m_requestToken);
        }
        catch (TwitterException e) {
            throw new MicroblogAuthorizationException((Throwable)e);
        }
    }

    public AccessToken retrieveToken(String pin) throws MicroblogAuthorizationException {
        try {
            return this.m_twitter.getOAuthAccessToken(this.m_requestToken, pin);
        }
        catch (TwitterException e) {
            throw new MicroblogAuthorizationException((Throwable)e);
        }
    }

    public class MicroblogAuthorizationException
    extends Exception {
        private static final long serialVersionUID = -2319636949583935715L;

        public MicroblogAuthorizationException() {
        }

        public MicroblogAuthorizationException(String message) {
            super(message);
        }

        public MicroblogAuthorizationException(Throwable t) {
            super(t);
        }

        public MicroblogAuthorizationException(String message, Throwable t) {
            super(message, t);
        }
    }
}

