/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.opennms.netmgt.snmp.SnmpUtils;

public class LldpRemTableEntry
extends SnmpStore {
    public static final String LLDP_REM_LOCAL_PORTNUM_ALIAS = "lldpRemLocalPortNum";
    public static final String LLDP_REM_CHASSISID_SUBTYPE_ALIAS = "lldpRemChassisIdSubtype";
    public static final String LLDP_REM_CHASSISID_ALIAS = "lldpRemChassisId";
    public static final String LLDP_REM_PORTID_SUBTYPE_ALIAS = "lldpRemPortIdSubtype";
    public static final String LLDP_REM_PORTID_ALIAS = "lldpRemPortId";
    public static final String LLDP_REM_SYSNAME_ALIAS = "lldpRemSysName";
    public static final String LLDP_REM_LOCAL_PORTNUM_OID = ".1.0.8802.1.1.2.1.4.1.1.2";
    public static final String LLDP_REM_CHASSISID_SUBTYPE_OID = ".1.0.8802.1.1.2.1.4.1.1.4";
    public static final String LLDP_REM_CHASSISID_OID = ".1.0.8802.1.1.2.1.4.1.1.5";
    public static final String LLDP_REM_PORTID_SUBTYPE_OID = ".1.0.8802.1.1.2.1.4.1.1.6";
    public static final String LLDP_REM_PORTID_OID = ".1.0.8802.1.1.2.1.4.1.1.7";
    public static final String LLDP_REM_SYSNAME_OID = ".1.0.8802.1.1.2.1.4.1.1.9";
    public static final NamedSnmpVar[] lldpremtable_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "lldpRemLocalPortNum", ".1.0.8802.1.1.2.1.4.1.1.2", 1), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "lldpRemChassisIdSubtype", ".1.0.8802.1.1.2.1.4.1.1.4", 2), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "lldpRemChassisId", ".1.0.8802.1.1.2.1.4.1.1.5", 3), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "lldpRemPortIdSubtype", ".1.0.8802.1.1.2.1.4.1.1.6", 4), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "lldpRemPortId", ".1.0.8802.1.1.2.1.4.1.1.7", 5), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "lldpRemSysName", ".1.0.8802.1.1.2.1.4.1.1.9", 6)};
    public static final String TABLE_OID = ".1.0.8802.1.1.2.1.4.1.1";
    private boolean hasLldpLocPortId = false;

    public LldpRemTableEntry() {
        super(lldpremtable_elemList);
    }

    public Integer getLldpRemLocalPortNum() {
        return this.getInt32(LLDP_REM_LOCAL_PORTNUM_ALIAS);
    }

    public Integer getLldpRemChassisidSubtype() {
        return this.getInt32(LLDP_REM_CHASSISID_SUBTYPE_ALIAS);
    }

    public String getLldpRemChassiid() {
        return this.getHexString(LLDP_REM_CHASSISID_ALIAS);
    }

    public Integer getLldpRemPortidSubtype() {
        return this.getInt32(LLDP_REM_PORTID_SUBTYPE_ALIAS);
    }

    public String getLldpRemPortid() {
        return this.getDisplayString(LLDP_REM_PORTID_ALIAS);
    }

    public String getLldpRemSysname() {
        return this.getDisplayString(LLDP_REM_SYSNAME_ALIAS);
    }

    public String getLldpRemMacAddress() {
        return this.getHexString(LLDP_REM_PORTID_ALIAS);
    }

    public InetAddress getLldpRemIpAddress() {
        return this.getIPAddress(LLDP_REM_PORTID_ALIAS);
    }

    public void storeResult(SnmpResult res) {
        if (!this.hasLldpLocPortId) {
            int lldpLocPortId = res.getInstance().getSubIdAt(1);
            super.storeResult(new SnmpResult(SnmpObjId.get((String)LLDP_REM_LOCAL_PORTNUM_OID), res.getInstance(), SnmpUtils.getValueFactory().getInt32(lldpLocPortId)));
            this.hasLldpLocPortId = true;
        }
        super.storeResult(res);
    }
}

