/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpNetToMediaTableEntry
extends SnmpStore {
    private static final Logger LOG = LoggerFactory.getLogger(IpNetToMediaTableEntry.class);
    public static final String INTM_INDEX = "ipNetToMediaIfIndex";
    public static final String INTM_PHYSADDR = "ipNetToMediaPhysAddress";
    public static final String INTM_NETADDR = "ipNetToMediaNetAddress";
    public static final String INTM_TYPE = "ipNetToMediatype";
    public static final String TABLE_OID = ".1.3.6.1.2.1.4.22.1";
    public static NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipNetToMediaIfIndex", ".1.3.6.1.2.1.4.22.1.1", 1), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "ipNetToMediaPhysAddress", ".1.3.6.1.2.1.4.22.1.2", 2), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpIPAddress", "ipNetToMediaNetAddress", ".1.3.6.1.2.1.4.22.1.3", 3), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "ipNetToMediatype", ".1.3.6.1.2.1.4.22.1.4", 4)};

    public IpNetToMediaTableEntry() {
        super(ms_elemList);
    }

    public int getIpNetToMediaIfIndex() {
        Integer val = this.getInt32(INTM_INDEX);
        if (val == null) {
            return -1;
        }
        return val;
    }

    public String getIpNetToMediaPhysAddress() {
        try {
            String hexString = this.getHexString(INTM_PHYSADDR);
            if (hexString != null && hexString.length() == 12) {
                return hexString;
            }
            return InetAddressUtils.normalizeMacAddress((String)this.getDisplayString(INTM_PHYSADDR));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("IllegalArgumentException", (Throwable)e);
            return this.getDisplayString(INTM_PHYSADDR);
        }
    }

    public InetAddress getIpNetToMediaNetAddress() {
        return this.getIPAddress(INTM_NETADDR);
    }

    public int getIpNetToMediatype() {
        Integer val = this.getInt32(INTM_TYPE);
        if (val == null) {
            return -1;
        }
        return val;
    }
}

