/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dot1dBaseGroup
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(Dot1dBaseGroup.class);
    public static final String BASE_BRIDGE_ADDRESS = "dot1dBaseBridgeAddress";
    public static final String BASE_NUM_PORTS = "dot1dBaseNumPorts";
    public static final String BASE_NUM_TYPE = "dot1dBaseType";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "dot1dBaseBridgeAddress", ".1.3.6.1.2.1.17.1.1"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dBaseNumPorts", ".1.3.6.1.2.1.17.1.2"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "dot1dBaseType", ".1.3.6.1.2.1.17.1.3")};
    public static final String SYSTEM_OID = ".1.3.6.1.2.1.17.1";
    private SnmpStore m_store;
    private InetAddress m_address;

    public Dot1dBaseGroup(InetAddress address) {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
        this.m_address = address;
        this.m_store = new SnmpStore(ms_elemList);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving systemGroup from {}: {}", (Object)this.m_address, (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving systemGroup from {}: {}", (Object)this.m_address, (Object)msg);
    }

    public String getBridgeAddress() {
        return this.m_store.getHexString(BASE_BRIDGE_ADDRESS);
    }

    public Integer getNumberOfPorts() {
        return this.m_store.getInt32(BASE_NUM_PORTS);
    }

    public Integer getBridgeType() {
        return this.m_store.getInt32(BASE_NUM_TYPE);
    }

    public OnmsStpNode getOnmsStpNode(OnmsStpNode node) {
        if (this.getBridgeAddress() == null) {
            return node;
        }
        node.setBaseBridgeAddress(this.getBridgeAddress());
        if (this.getBridgeType() == null) {
            node.setBaseType(OnmsStpNode.BridgeBaseType.UNKNOWN);
        } else {
            node.setBaseType(OnmsStpNode.BridgeBaseType.get((Integer)this.getBridgeType()));
        }
        node.setBaseNumPorts(this.getNumberOfPorts());
        return node;
    }
}

