/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTableEntry;
import org.opennms.netmgt.linkd.snmp.VlanTableBasic;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpStore;

public class CiscoVlanTable
extends VlanTableBasic {
    public CiscoVlanTable(InetAddress address) {
        super(address, "ciscoVlanTable", CiscoVlanTableEntry.cisco_vlan_elemList);
    }

    @Override
    protected CiscoVlanTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new CiscoVlanTableEntry();
    }

    @Override
    public List<OnmsVlan> getVlansForSnmpCollection() {
        ArrayList<OnmsVlan> vlans = new ArrayList<OnmsVlan>();
        for (SnmpStore elm : this.getEntries()) {
            OnmsVlan vlan = ((CiscoVlanTableEntry)elm).getOnmsVlan();
            if (!vlan.getVlanType().equals((Object)OnmsVlan.VlanType.CISCO_VTP_ETHERNET) || !vlan.getVlanStatus().equals((Object)OnmsVlan.VlanStatus.CISCOVTP_OPERATIONAL)) continue;
            vlans.add(vlan);
        }
        return vlans;
    }
}

