/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.opennms.netmgt.snmp.SnmpUtils;

public final class CdpCacheTableEntry
extends SnmpStore {
    public static final String CDP_IFINDEX = "cdpCacheIfIndex";
    public static final String CDP_DEVICEINDEX = "cdpCacheDeviceIndex";
    public static final String CDP_ADDRESS_TYPE = "cdpCacheAddressType";
    public static final String CDP_ADDRESS = "cdpCacheAddress";
    public static final String CDP_VERSION = "cdpCacheVersion";
    public static final String CDP_DEVICEID = "cdpCacheDeviceId";
    public static final String CDP_DEVICEPORT = "cdpCacheDevicePort";
    public static final String CDP_PLATFORM = "cdpPlatform";
    public static final String CDP_CAPS = "cdpCacheCapabilities";
    public static final String CDP_VTP_MGMTDOMAIN = "cdpCacheVtpMgmtDomain";
    public static final String CDP_NATIVEVLAN = "cdpCacheNatveVlan";
    public static final String CDP_DUPLEX = "cdpCacheDuplex";
    public static final String CDP_APPLIANCEID = "cdpCacheApplianceID";
    public static final String CDP_VLANID = "cdpCacheVlanID";
    public static final String CDP_POWERCONS = "cdpCachePowerConsumption";
    public static final String CDP_MTU = "cdpCacheMTU";
    public static final String CDP_SYSNAME = "cdpCacheSysName";
    public static final String CDP_SYSOBJID = "cdpCacheSysObjectID";
    public static final String CDP_PRIMARYMGMTADDR_TYPE = "cdpCachePrimaryMgmtAddressType";
    public static final String CDP_PRIMARYMGMTADDR = "cdpCachePrimaryMgmtAddress";
    public static final String CDP_SECONDARYMGMTADDR_TYPE = "cdpCacheSecondaryMgmtAddressType";
    public static final String CDP_SECONDARYMGMTADDR = "cdpCacheSecondaryMgmtAddress";
    public static final String CDP_PHYSLOC = "cdpCachePhysLocation";
    public static final String CDP_LASTCHANGE = "cdpCacheLastChange";
    private boolean hasIfIndex = false;
    private static final String CDP_IFINDEX_OID = ".1.3.6.1.4.1.9.9.23.1.2.1.1.1";
    private static final String CDP_DEVICEINDEX_OID = ".1.3.6.1.4.1.9.9.23.1.2.1.1.2";
    public static final NamedSnmpVar[] cdpCache_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "cdpCacheIfIndex", ".1.3.6.1.4.1.9.9.23.1.2.1.1.1", 1), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "cdpCacheDeviceIndex", ".1.3.6.1.4.1.9.9.23.1.2.1.1.2", 2), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "cdpCacheAddressType", ".1.3.6.1.4.1.9.9.23.1.2.1.1.3", 3), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpCacheAddress", ".1.3.6.1.4.1.9.9.23.1.2.1.1.4", 4), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpCacheVersion", ".1.3.6.1.4.1.9.9.23.1.2.1.1.5", 5), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpCacheDeviceId", ".1.3.6.1.4.1.9.9.23.1.2.1.1.6", 6), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpCacheDevicePort", ".1.3.6.1.4.1.9.9.23.1.2.1.1.7", 7)};
    public static final String TABLE_OID = ".1.3.6.1.4.1.9.9.23.1.2.1.1";

    public CdpCacheTableEntry() {
        super(cdpCache_elemList);
    }

    public void storeResult(SnmpResult res) {
        if (!this.hasIfIndex) {
            int ifindex = res.getInstance().getSubIdAt(res.getInstance().length() - 2);
            super.storeResult(new SnmpResult(SnmpObjId.get((String)CDP_IFINDEX_OID), res.getInstance(), SnmpUtils.getValueFactory().getInt32(ifindex)));
            int deviceIndex = res.getInstance().getLastSubId();
            super.storeResult(new SnmpResult(SnmpObjId.get((String)CDP_DEVICEINDEX_OID), res.getInstance(), SnmpUtils.getValueFactory().getInt32(deviceIndex)));
            this.hasIfIndex = true;
        }
        super.storeResult(res);
    }

    public int getCdpCacheIfIndex() {
        return this.getInt32(CDP_IFINDEX);
    }

    public int getCdpCacheDeviceIndex() {
        return this.getInt32(CDP_DEVICEINDEX);
    }

    public int getCdpCacheAddressType() {
        return this.getInt32(CDP_ADDRESS_TYPE);
    }

    public String getCdpCacheAddress() {
        return this.getHexString(CDP_ADDRESS);
    }

    public InetAddress getCdpCacheIpv4Address() {
        return CdpCacheTableEntry.getIpAddressByHexString(this.getCdpCacheAddress());
    }

    public String getCdpCacheVersion() {
        return this.getDisplayString(CDP_VERSION);
    }

    public String getCdpCacheDeviceId() {
        return this.getDisplayString(CDP_DEVICEID);
    }

    public String getCdpCacheDevicePort() {
        return this.getDisplayString(CDP_DEVICEPORT);
    }

    private static InetAddress getIpAddressByHexString(String ipaddrhexstrng) {
        try {
            long ipAddr = Long.parseLong(ipaddrhexstrng, 16);
            byte[] bytes = new byte[4];
            bytes[3] = (byte)(ipAddr & 0xFFL);
            bytes[2] = (byte)(ipAddr >> 8 & 0xFFL);
            bytes[1] = (byte)(ipAddr >> 16 & 0xFFL);
            bytes[0] = (byte)(ipAddr >> 24 & 0xFFL);
            return InetAddressUtils.getInetAddress((byte[])bytes);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

