/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.AtInterfaceDao;
import org.opennms.netmgt.dao.api.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.api.StpInterfaceDao;
import org.opennms.netmgt.dao.api.StpNodeDao;
import org.opennms.netmgt.dao.api.VlanDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.linkd.AbstractQueryManager;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.LinkableSnmpNode;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.OnmsVlan;
import org.opennms.netmgt.model.PrimaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class HibernateEventWriter
extends AbstractQueryManager
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateEventWriter.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private AtInterfaceDao m_atInterfaceDao;
    @Autowired
    private VlanDao m_vlanDao;
    @Autowired
    private StpNodeDao m_stpNodeDao;
    @Autowired
    private StpInterfaceDao m_stpInterfaceDao;
    @Autowired
    private IpRouteInterfaceDao m_ipRouteInterfaceDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;

    @Override
    public List<LinkableSnmpNode> getSnmpNodeList() {
        ArrayList<LinkableSnmpNode> nodes = new ArrayList<LinkableSnmpNode>();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN);
        builder.eq("type", (Object)"A");
        builder.eq("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY);
        for (OnmsNode node : this.m_nodeDao.findMatching(builder.toCriteria())) {
            String sysObjectId = node.getSysObjectId();
            nodes.add(new LinkableSnmpNode(node.getId(), node.getPrimaryInterface().getIpAddress(), sysObjectId == null ? "-1" : sysObjectId, node.getSysName()));
        }
        return nodes;
    }

    @Override
    public LinkableSnmpNode getSnmpNode(int nodeid) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.alias("ipInterfaces", "iface", Alias.JoinType.LEFT_JOIN);
        builder.eq("type", (Object)"A");
        builder.eq("iface.isSnmpPrimary", (Object)PrimaryType.PRIMARY);
        builder.eq("id", (Object)nodeid);
        List nodes = this.m_nodeDao.findMatching(builder.toCriteria());
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            String sysObjectId = node.getSysObjectId();
            return new LinkableSnmpNode(node.getId(), node.getPrimaryInterface().getIpAddress(), sysObjectId == null ? "-1" : sysObjectId, node.getSysName());
        }
        return null;
    }

    @Override
    public void updateDeletedNodes() {
        this.m_atInterfaceDao.markDeletedIfNodeDeleted();
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.markDeletedIfNodeDeleted();
        this.m_vlanDao.flush();
        this.m_stpNodeDao.markDeletedIfNodeDeleted();
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.markDeletedIfNodeDeleted();
        this.m_stpInterfaceDao.flush();
        this.m_ipRouteInterfaceDao.markDeletedIfNodeDeleted();
        this.m_ipRouteInterfaceDao.flush();
        this.m_dataLinkInterfaceDao.markDeletedIfNodeDeleted();
        this.m_dataLinkInterfaceDao.flush();
    }

    @Override
    protected void markOldDataInactive(Date scanTime, int nodeid) {
        this.m_atInterfaceDao.deactivateForSourceNodeIdIfOlderThan(nodeid, scanTime);
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_vlanDao.flush();
        this.m_ipRouteInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_ipRouteInterfaceDao.flush();
        this.m_stpNodeDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpInterfaceDao.flush();
    }

    @Override
    protected void deleteOlderData(Date scanTime, int nodeid) {
        this.m_atInterfaceDao.deleteForNodeSourceIdIfOlderThan(nodeid, scanTime);
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_vlanDao.flush();
        this.m_ipRouteInterfaceDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_ipRouteInterfaceDao.flush();
        this.m_stpNodeDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.deleteForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpInterfaceDao.flush();
    }

    @Override
    @Transactional
    public LinkableNode storeSnmpCollection(LinkableNode node, SnmpCollection snmpColl) {
        Date scanTime = new Date();
        OnmsNode onmsNode = this.getNode(node.getNodeId());
        if (onmsNode == null) {
            LOG.debug("no node found!");
            return null;
        }
        LOG.debug("storeSnmpCollection: wifi hasMtxrWlRtabTable: {}", (Object)snmpColl.hasMtxrWlRtabTable());
        if (snmpColl.hasMtxrWlRtabTable()) {
            this.processWifi(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: ospf hasOspfGeneralGroup/hasOspfNbrTable: {}/{}", (Object)snmpColl.hasOspfGeneralGroup(), (Object)snmpColl.hasOspfNbrTable());
        if (snmpColl.hasOspfGeneralGroup() && snmpColl.hasOspfNbrTable()) {
            this.processOspf(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: isis hasIsIsSystemObjectGroup/hasIsisCircTable/hasIsisISAdjTable: {}/{}/{}", new Object[]{snmpColl.hasIsIsSysObjectGroup(), snmpColl.hasIsisCircTable(), snmpColl.hasIsisISAdjTable()});
        if (snmpColl.hasIsIsSysObjectGroup() && snmpColl.hasIsisCircTable() && snmpColl.hasIsisISAdjTable()) {
            this.processIsis(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: lldp hasLldpLocalGroup/hasLldpLocTable/haLldpRemTable: {}/{}/{}", new Object[]{snmpColl.hasLldpLocalGroup(), snmpColl.hasLldpLocTable(), snmpColl.hasLldpRemTable()});
        if (snmpColl.hasLldpLocalGroup()) {
            this.processLldp(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: hasIpNetToMediaTable: {}", (Object)snmpColl.hasIpNetToMediaTable());
        if (snmpColl.hasIpNetToMediaTable()) {
            this.processIpNetToMediaTable(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: hasCdpGlobalGroup: {}", (Object)snmpColl.hasCdpGlobalGroup());
        LOG.debug("storeSnmpCollection: hasCdpCacheTable: {}", (Object)snmpColl.hasCdpCacheTable());
        if (snmpColl.hasCdpGlobalGroup() && snmpColl.hasCdpCacheTable()) {
            this.processCdp(node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: hasRouteTable: {}", (Object)snmpColl.hasRouteTable());
        if (snmpColl.hasRouteTable()) {
            this.processRouteTable(onmsNode, node, snmpColl, scanTime);
        }
        LOG.debug("storeSnmpCollection: hasVlanTable: {}", (Object)snmpColl.hasVlanTable());
        if (snmpColl.hasVlanTable()) {
            this.processVlanTable(onmsNode, node, snmpColl, scanTime);
        }
        for (OnmsVlan vlan : snmpColl.getSnmpVlanCollections().keySet()) {
            LOG.debug("storeSnmpCollection: parsing bridge data on VLAN {}/{}", (Object)vlan.getVlanId(), (Object)vlan.getVlanName());
            this.storeSnmpVlanCollection(onmsNode, node, vlan, snmpColl.getSnmpVlanCollections().get(vlan), scanTime);
        }
        this.markOldDataInactive(scanTime, node.getNodeId());
        this.deleteOlderData(new Date(scanTime.getTime() - snmpColl.getPollInterval() * 3L), node.getNodeId());
        return node;
    }

    private DataLinkInterface getDatabaseLink(Collection<DataLinkInterface> links, int nodeparentid, int parentifindex, DataLinkInterface.DiscoveryProtocol protocol) {
        for (DataLinkInterface link : links) {
            if (link.getNodeParentId() != nodeparentid || link.getParentIfIndex() != parentifindex || link.getProtocol() != protocol) continue;
            LOG.info("storeDiscoveryLink: found link {} on database.", (Object)link);
            return link;
        }
        return null;
    }

    @Override
    @Transactional
    public void storeDiscoveryLink(DiscoveryLink discoveryLink) {
        Date now = new Date();
        String source = this.getLinkd().getName() + "/" + discoveryLink.getPackageName();
        for (NodeToNodeLink lk : discoveryLink.getLinks()) {
            LOG.debug("storeDiscoveryLink: parsing link {}.", (Object)lk);
            DataLinkInterface link = this.getDatabaseLink(this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(lk.getNodeId()), Integer.valueOf(lk.getIfindex())), lk.getNodeparentid(), lk.getParentifindex(), lk.getProtocol());
            if (link == null) {
                LOG.info("storeDiscoveryLink: no found interface on database for link {}. Creating a new one", (Object)lk);
                OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(lk.getNodeId()));
                link = new DataLinkInterface(onmsNode, lk.getIfindex(), lk.getNodeparentid(), lk.getParentifindex(), OnmsArpInterface.StatusType.ACTIVE, now);
                link.setProtocol(lk.getProtocol());
            } else {
                link.setStatus(OnmsArpInterface.StatusType.ACTIVE);
                link.setLastPollTime(now);
            }
            link.setSource(source);
            DataLinkInterface reverselink = this.getDatabaseLink(this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(lk.getNodeparentid()), Integer.valueOf(lk.getParentifindex())), lk.getNodeId(), lk.getIfindex(), lk.getProtocol());
            if (reverselink != null) {
                LOG.info("storeDiscoveryLink: Deleting found reverse link {}.", (Object)reverselink);
                this.m_dataLinkInterfaceDao.delete((Object)reverselink);
            }
            LOG.debug("storeDiscoveryLink: Storing {}", (Object)link);
            this.m_dataLinkInterfaceDao.saveOrUpdate((Object)link);
        }
        this.m_dataLinkInterfaceDao.deactivateIfOlderThan(now, source);
        this.m_dataLinkInterfaceDao.deleteIfOlderThan(new Date(now.getTime() - 3L * discoveryLink.getInterval()), source);
        this.m_dataLinkInterfaceDao.flush();
    }

    @Override
    public void update(int nodeid, OnmsArpInterface.StatusType action) {
        this.m_vlanDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_atInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_ipRouteInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_stpNodeDao.setStatusForNode(Integer.valueOf(nodeid), action);
        this.m_stpInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), action);
        for (String packageName : this.getLinkd().getActivePackages()) {
            this.m_dataLinkInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), this.getLinkd().getSource() + "/" + packageName, action);
        }
    }

    @Override
    public void updateForInterface(int nodeid, String ipAddr, int ifIndex, OnmsArpInterface.StatusType action) {
        if (ipAddr != null && ipAddr.length() != 0 && !"0.0.0.0".equals(ipAddr)) {
            this.m_atInterfaceDao.setStatusForNodeAndIp(Integer.valueOf(nodeid), ipAddr, action);
        }
        if (ifIndex > -1) {
            this.m_atInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), action);
            this.m_stpInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), action);
            this.m_ipRouteInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), action);
            for (String packageName : this.getLinkd().getActivePackages()) {
                this.m_dataLinkInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), this.getLinkd().getSource() + "/" + packageName, action);
            }
        }
    }

    @Override
    protected int getIfIndexByName(int targetCdpNodeId, String cdpTargetDevicePort) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node");
        builder.eq("node.id", (Object)targetCdpNodeId);
        builder.or((Restriction)new EqRestriction("ifName", (Object)cdpTargetDevicePort), (Restriction)new EqRestriction("ifDescr", (Object)cdpTargetDevicePort));
        List interfaces = this.m_snmpInterfaceDao.findMatching(builder.toCriteria());
        if (interfaces.isEmpty()) {
            return -1;
        }
        if (interfaces.size() > 1) {
            LOG.debug("getIfIndexByName: More than one SnmpInterface matches nodeId {} and snmpIfName/snmpIfDescr {}", (Object)targetCdpNodeId, (Object)cdpTargetDevicePort);
        }
        return ((OnmsSnmpInterface)interfaces.get(0)).getIfIndex();
    }

    @Override
    protected List<OnmsNode> getNodeidFromIp(InetAddress cdpTargetIpAddr) {
        ArrayList<OnmsNode> nodeids = new ArrayList<OnmsNode>();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.eq("ipAddress", (Object)cdpTargetIpAddr);
        builder.eq("node.type", (Object)"A");
        List interfaces = this.m_ipInterfaceDao.findMatching(builder.toCriteria());
        LOG.debug("getNodeidFromIp: Found {} nodeids matching ipAddress {}", (Object)interfaces.size(), (Object)InetAddressUtils.str((InetAddress)cdpTargetIpAddr));
        for (OnmsIpInterface ipinterface : interfaces) {
            nodeids.add(ipinterface.getNode());
        }
        return nodeids;
    }

    @Override
    protected List<RouterInterface> getRouteInterface(InetAddress nexthop, int ifindex) {
        ArrayList<RouterInterface> routes = new ArrayList<RouterInterface>();
        List interfaces = this.m_ipInterfaceDao.findByIpAddress(InetAddressUtils.str((InetAddress)nexthop));
        LOG.debug("getRouteInterface: Found {} interface matching ipAddress {}", (Object)interfaces.size(), (Object)InetAddressUtils.str((InetAddress)nexthop));
        for (OnmsIpInterface ipInterface : interfaces) {
            RouterInterface route = null;
            OnmsNode node = ipInterface.getNode();
            OnmsSnmpInterface snmpInterface = ipInterface.getSnmpInterface();
            route = snmpInterface == null || snmpInterface.getNetMask() == null ? new RouterInterface(node.getId(), -1) : new RouterInterface(node.getId(), snmpInterface.getIfIndex(), snmpInterface.getNetMask());
            route.setNextHop(nexthop);
            route.setIfindex(ifindex);
            LOG.debug("getRouteInterface: adding {} route interface", (Object)route);
            routes.add(route);
        }
        return routes;
    }

    @Override
    protected int getSnmpIfType(int nodeId, Integer ifIndex) {
        Integer snmpIfType = -1;
        OnmsSnmpInterface snmpInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeId), ifIndex);
        if (snmpInterface != null) {
            snmpIfType = snmpInterface.getIfType();
        }
        LOG.debug("getSnmpIfType({}, {}), found {}.", new Object[]{nodeId, ifIndex, snmpIfType});
        return snmpIfType;
    }

    @Override
    protected List<String> getPhysAddrs(int nodeId) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
        builder.alias("node", "node");
        builder.eq("node.id", (Object)nodeId);
        ArrayList<String> addrs = new ArrayList<String>();
        for (OnmsSnmpInterface snmpInterface : this.m_snmpInterfaceDao.findMatching(builder.toCriteria())) {
            addrs.add(snmpInterface.getPhysAddr());
        }
        return addrs;
    }

    @Override
    protected synchronized void saveIpRouteInterface(final OnmsIpRouteInterface saveMe) {
        new UpsertTemplate<OnmsIpRouteInterface, IpRouteInterfaceDao>(this.m_transactionManager, this.m_ipRouteInterfaceDao){

            protected OnmsIpRouteInterface query() {
                return ((IpRouteInterfaceDao)this.m_dao).findByNodeAndDest(saveMe.getNode().getId(), saveMe.getRouteDest());
            }

            protected OnmsIpRouteInterface doUpdate(OnmsIpRouteInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getRouteDest().equals(saveMe.getRouteDest()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setRouteIfIndex(saveMe.getRouteIfIndex());
                updateMe.setRouteMask(saveMe.getRouteMask());
                updateMe.setRouteMetric1(saveMe.getRouteMetric1());
                updateMe.setRouteMetric2(saveMe.getRouteMetric2());
                updateMe.setRouteMetric3(saveMe.getRouteMetric3());
                updateMe.setRouteMetric4(saveMe.getRouteMetric4());
                updateMe.setRouteMetric5(saveMe.getRouteMetric5());
                updateMe.setRouteNextHop(saveMe.getRouteNextHop());
                updateMe.setRouteProto(saveMe.getRouteProto());
                updateMe.setRouteType(saveMe.getRouteType());
                updateMe.setStatus(saveMe.getStatus());
                ((IpRouteInterfaceDao)this.m_dao).update((Object)updateMe);
                ((IpRouteInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsIpRouteInterface doInsert() {
                ((IpRouteInterfaceDao)this.m_dao).save((Object)saveMe);
                ((IpRouteInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected void saveVlan(final OnmsVlan saveMe) {
        new UpsertTemplate<OnmsVlan, VlanDao>(this.m_transactionManager, this.m_vlanDao){

            protected OnmsVlan query() {
                return ((VlanDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getVlanId());
            }

            protected OnmsVlan doUpdate(OnmsVlan updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getVlanId().equals(saveMe.getVlanId()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setVlanName(saveMe.getVlanName());
                updateMe.setVlanStatus(saveMe.getVlanStatus());
                updateMe.setVlanType(saveMe.getVlanType());
                ((VlanDao)this.m_dao).update((Object)updateMe);
                ((VlanDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsVlan doInsert() {
                ((VlanDao)this.m_dao).save((Object)saveMe);
                ((VlanDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected synchronized void saveStpNode(final OnmsStpNode saveMe) {
        new UpsertTemplate<OnmsStpNode, StpNodeDao>(this.m_transactionManager, this.m_stpNodeDao){

            protected OnmsStpNode query() {
                return ((StpNodeDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getBaseVlan());
            }

            protected OnmsStpNode doUpdate(OnmsStpNode updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getBaseVlan().equals(saveMe.getBaseVlan()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setBaseBridgeAddress(saveMe.getBaseBridgeAddress());
                updateMe.setBaseNumPorts(saveMe.getBaseNumPorts());
                updateMe.setBaseType(saveMe.getBaseType());
                updateMe.setBaseVlanName(saveMe.getBaseVlanName());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setStpDesignatedRoot(saveMe.getStpDesignatedRoot());
                updateMe.setStpPriority(saveMe.getStpPriority());
                updateMe.setStpProtocolSpecification(saveMe.getStpProtocolSpecification());
                updateMe.setStpRootCost(saveMe.getStpRootCost());
                updateMe.setStpRootPort(saveMe.getStpRootPort());
                ((StpNodeDao)this.m_dao).update((Object)updateMe);
                ((StpNodeDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsStpNode doInsert() {
                ((StpNodeDao)this.m_dao).save((Object)saveMe);
                ((StpNodeDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected void saveStpInterface(final OnmsStpInterface saveMe) {
        new UpsertTemplate<OnmsStpInterface, StpInterfaceDao>(this.m_transactionManager, this.m_stpInterfaceDao){

            protected OnmsStpInterface query() {
                return ((StpInterfaceDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getBridgePort(), saveMe.getVlan());
            }

            protected OnmsStpInterface doUpdate(OnmsStpInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getBridgePort().equals(saveMe.getBridgePort()));
                Assert.isTrue((boolean)updateMe.getVlan().equals(saveMe.getVlan()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setIfIndex(saveMe.getIfIndex());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setStpPortDesignatedBridge(saveMe.getStpPortDesignatedBridge());
                updateMe.setStpPortDesignatedCost(saveMe.getStpPortDesignatedCost());
                updateMe.setStpPortDesignatedPort(saveMe.getStpPortDesignatedPort());
                updateMe.setStpPortDesignatedRoot(saveMe.getStpPortDesignatedRoot());
                updateMe.setStpPortPathCost(saveMe.getStpPortPathCost());
                updateMe.setStpPortState(saveMe.getStpPortState());
                ((StpInterfaceDao)this.m_dao).update((Object)updateMe);
                ((StpInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsStpInterface doInsert() {
                ((StpInterfaceDao)this.m_dao).save((Object)saveMe);
                ((StpInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected void saveAtInterface(final OnmsAtInterface saveMe) {
        new UpsertTemplate<OnmsAtInterface, AtInterfaceDao>(this.m_transactionManager, this.m_atInterfaceDao){

            protected OnmsAtInterface query() {
                return ((AtInterfaceDao)this.m_dao).findByNodeAndAddress(saveMe.getNode().getId(), saveMe.getIpAddress(), saveMe.getMacAddress());
            }

            protected OnmsAtInterface doUpdate(OnmsAtInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getIpAddress().equals(saveMe.getIpAddress()));
                Assert.isTrue((boolean)updateMe.getMacAddress().equals(saveMe.getMacAddress()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setIfIndex(saveMe.getIfIndex());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                ((AtInterfaceDao)this.m_dao).update((Object)updateMe);
                ((AtInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsAtInterface doInsert() {
                ((AtInterfaceDao)this.m_dao).save((Object)saveMe);
                ((AtInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        LOG.debug("Initialized {}", (Object)this.getClass().getSimpleName());
    }

    @Override
    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    @Override
    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    @Override
    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    @Override
    public AtInterfaceDao getAtInterfaceDao() {
        return this.m_atInterfaceDao;
    }

    public VlanDao getVlanDao() {
        return this.m_vlanDao;
    }

    public StpNodeDao getStpNodeDao() {
        return this.m_stpNodeDao;
    }

    public StpInterfaceDao getStpInterfaceDao() {
        return this.m_stpInterfaceDao;
    }

    public IpRouteInterfaceDao getIpRouteInterfaceDao() {
        return this.m_ipRouteInterfaceDao;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }

    @Override
    @Transactional
    public OnmsSnmpInterface getFromSysnameIpAddress(String lldpRemSysname, InetAddress lldpRemPortid) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
        builder.createAlias("node", "node");
        builder.eq("node.sysName", (Object)lldpRemSysname);
        builder.eq("ipAddress", (Object)lldpRemPortid);
        List interfaces = this.getIpInterfaceDao().findMatching(builder.toCriteria());
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            OnmsIpInterface ip = (OnmsIpInterface)interfaces.get(0);
            return this.getSnmpInterfaceDao().findByNodeIdAndIfIndex(ip.getNode().getId(), ip.getIfIndex());
        }
        return null;
    }

    @Override
    @Transactional
    protected OnmsSnmpInterface getFromSysnameIfName(String lldpRemSysname, String lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("ifName", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    protected OnmsSnmpInterface getFromSysnameIfIndex(String lldpRemSysname, Integer lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("ifIndex", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    protected OnmsSnmpInterface getFromSysnameMacAddress(String lldpRemSysname, String lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("physAddr", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    protected OnmsSnmpInterface getFromSysnameIfAlias(String lldpRemSysname, String lldpRemPortid) {
        Criteria criteria = new Criteria(OnmsSnmpInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.sysName", (Object)lldpRemSysname));
        criteria.addRestriction((Restriction)new EqRestriction("ifAlias", (Object)lldpRemPortid));
        List interfaces = this.getSnmpInterfaceDao().findMatching(criteria);
        if (interfaces != null && !interfaces.isEmpty() && interfaces.size() == 1) {
            return (OnmsSnmpInterface)interfaces.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    protected OnmsSnmpInterface getFromSysnameAgentCircuitId(String lldpRemSysname, String lldpRemPortid) {
        LOG.warn("getFromSysnameAgentCircuitId: AgentCircuitId LLDP PortSubTypeId not supported");
        return null;
    }

    @Override
    protected OnmsSnmpInterface getFromSysnamePortComponent(String lldpRemSysname, String lldpRemPortid) {
        LOG.warn("getFromSysnamePortComponent:PortComponent LLDP PortSubTypeId not supported");
        return null;
    }
}

