/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.udp;

import java.net.InetAddress;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.udp.UdpReceivedEvent;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UdpProcessor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UdpProcessor.class);
    private Thread m_context = null;
    private List<UdpReceivedEvent> m_eventsIn;
    private List<UdpReceivedEvent> m_eventUuidsOut;
    private List<EventHandler> m_handlers;
    private volatile boolean m_stop = false;
    private String m_logPrefix;

    UdpProcessor(List<EventHandler> handlers, List<UdpReceivedEvent> in, List<UdpReceivedEvent> out) {
        this.m_eventsIn = in;
        this.m_eventUuidsOut = out;
        this.m_handlers = handlers;
        this.m_logPrefix = "eventd";
    }

    boolean isAlive() {
        return this.m_context == null ? false : this.m_context.isAlive();
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_context = Thread.currentThread();
        Logging.putPrefix((String)this.m_logPrefix);
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        block16: while (!this.m_stop) {
            LOG.debug("Waiting on a new datagram to arrive");
            UdpReceivedEvent re = null;
            List<UdpReceivedEvent> list = this.m_eventsIn;
            synchronized (list) {
                while (this.m_eventsIn.isEmpty()) {
                    try {
                        this.m_eventsIn.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        LOG.debug("Thread interrupted");
                        break block16;
                    }
                    if (!this.m_stop) continue;
                    LOG.debug("Stop flag is set");
                    break block16;
                }
                re = this.m_eventsIn.remove(0);
            }
            LOG.debug("A new request has arrived");
            Event[] events = null;
            try {
                LOG.debug("Event from {}:{}", (Object)InetAddressUtils.str((InetAddress)re.getSender()), (Object)re.getPort());
                LOG.debug("Unmarshalling Event text \\{{}{}{}}", new Object[]{System.getProperty("line.separator"), re.getXmlData(), System.getProperty("line.separator")});
                events = re.unmarshal().getEvents().getEvent();
            }
            catch (MarshalException e) {
                LOG.warn("Failed to unmarshal the event from {}:{}", new Object[]{InetAddressUtils.str((InetAddress)re.getSender()), re.getPort(), e});
                continue;
            }
            catch (ValidationException e) {
                LOG.warn("Failed to validate the event from {}:{}", new Object[]{InetAddressUtils.str((InetAddress)re.getSender()), re.getPort(), e});
                continue;
            }
            if (events == null || events.length == 0) {
                LOG.debug("The event log record contained no events");
                continue;
            }
            LOG.debug("Processing {} events", (Object)events.length);
            List<Object> list2 = this.m_handlers;
            synchronized (list2) {
                for (EventHandler handler : this.m_handlers) {
                    for (int ndx = 0; ndx < events.length; ++ndx) {
                        try {
                            if (!handler.processEvent(events[ndx])) continue;
                            re.ackEvent(events[ndx]);
                            continue;
                        }
                        catch (Throwable t) {
                            LOG.warn("Failed to process received UDP event, exception follows", t);
                        }
                    }
                }
            }
            LOG.debug("event processing complete, forwarding to receipt generator");
            list2 = this.m_eventUuidsOut;
            synchronized (list2) {
                this.m_eventUuidsOut.add(re);
            }
        }
        LOG.debug("Context finished, returning");
    }

    void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }
}

