/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeGroup;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnmpCollectionResource
implements CollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollectionResource.class);
    private final ResourceType m_resourceType;
    private final Map<AttributeGroupType, AttributeGroup> m_groups = new HashMap<AttributeGroupType, AttributeGroup>();

    public SnmpCollectionResource(ResourceType def) {
        this.m_resourceType = def;
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    public final CollectionAgent getCollectionAgent() {
        return this.m_resourceType.getAgent();
    }

    public abstract boolean shouldPersist(ServiceParameters var1);

    public String getOwnerName() {
        return this.getCollectionAgent().getHostAddress();
    }

    public abstract File getResourceDir(RrdRepository var1) throws FileNotFoundException;

    public abstract int getSnmpIfType();

    public boolean rescanNeeded() {
        return false;
    }

    public void setAttributeValue(SnmpAttributeType type, SnmpValue val) {
        SnmpAttribute attr = new SnmpAttribute(this, type, val);
        this.addAttribute(attr);
    }

    private void addAttribute(SnmpAttribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        LOG.debug("Adding attribute {}: {} to group {}", new Object[]{((Object)((Object)attr)).getClass().getName(), attr, group});
        group.addAttribute((CollectionAttribute)attr);
    }

    private AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_groups.get(groupType);
        if (group == null) {
            group = new SnmpAttributeGroup(this, groupType);
            this.m_groups.put(groupType, group);
        }
        return group;
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource((CollectionResource)this);
        for (AttributeGroup group : this.getGroups()) {
            group.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
    }

    protected Collection<AttributeGroup> getGroups() {
        return this.m_groups.values();
    }

    public TimeKeeper getTimeKeeper() {
        return null;
    }
}

