/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpAttribute
extends AbstractCollectionAttribute {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpAttribute.class);
    private SnmpValue m_val;

    public SnmpAttribute(CollectionResource resource, SnmpAttributeType type, SnmpValue val) {
        super((CollectionAttributeType)type, resource);
        this.m_val = val;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpAttribute) {
            SnmpAttribute attr = (SnmpAttribute)((Object)obj);
            return this.m_resource.equals(attr.m_resource) && this.m_attribType.equals(attr.m_attribType);
        }
        return false;
    }

    public int hashCode() {
        return this.m_resource.hashCode() ^ this.m_attribType.hashCode();
    }

    public SnmpValue getValue() {
        return this.m_val;
    }

    public void storeAttribute(Persister persister) {
        this.getAttributeType().storeAttribute((CollectionAttribute)this, persister);
    }

    public String toString() {
        return this.getResource() + "." + this.getAttributeType() + " = " + this.getValue();
    }

    public String getMetricIdentifier() {
        String instance = this.m_resource.getInstance();
        SnmpAttributeType type = (SnmpAttributeType)this.m_attribType;
        if (instance == null) {
            instance = type.getInstance();
        }
        return "SNMP_" + SnmpObjId.get((SnmpObjId)type.getSnmpObjId(), (String)instance);
    }

    public String getNumericValue() {
        if (this.getValue() == null) {
            LOG.debug("No data collected for attribute {}. Skipping", (Object)this);
            return null;
        }
        if (this.getValue().isNumeric()) {
            return Long.toString(this.getValue().toLong());
        }
        if (this.getValue().getBytes().length == 8) {
            return Long.toString(SnmpUtils.getProtoCounter64Value((SnmpValue)this.getValue()));
        }
        try {
            return Double.valueOf(this.getValue().toString()).toString();
        }
        catch (NumberFormatException e) {
            LOG.trace("Unable to process data received for attribute {} maybe this is not a number? See bug 1473 for more information. Skipping.", (Object)this);
            if (this.getValue().getType() == 4) {
                try {
                    return Long.valueOf(this.getValue().toHexString(), 16).toString();
                }
                catch (NumberFormatException ex) {
                    LOG.trace("Unable to process data received for attribute {} maybe this is not a number? See bug 1473 for more information. Skipping.", (Object)this);
                }
            }
            return null;
        }
    }

    public String getStringValue() {
        SnmpValue value = this.getValue();
        return value == null ? null : value.toString();
    }
}

