/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.JMXDataSource;
import org.opennms.netmgt.collectd.JMXNodeInfo;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.JMXDataCollectionConfigFactory;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(JMXCollector.class);
    static String IF_MAP_KEY = "org.opennms.netmgt.collectd.JBossCollector.ifMap";
    private static final int MAX_DS_NAME_LENGTH = 19;
    private boolean useFriendlyName = false;
    static String NODE_INFO_KEY = "org.opennms.netmgt.collectd.JMXCollector.nodeInfo";
    private String serviceName = null;

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void initialize(Map<String, String> parameters) {
        try {
            JMXDataCollectionConfigFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: Failed to load data collection configuration", e);
            throw new UndeclaredThrowableException(e);
        }
        Connection ctest = null;
        try {
            ctest = DataSourceFactory.getInstance().getConnection();
        }
        catch (Exception e) {
            LOG.error("initialize: failed to get a database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (ctest != null) {
                try {
                    ctest.close();
                }
                catch (Throwable t) {
                    LOG.debug("initialize: an exception occured while closing the JDBC connection");
                }
            }
        }
        LOG.debug("initialize: successfully instantiated JNI interface to RRD.");
    }

    public void release() {
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        InetAddress ipAddr = (InetAddress)agent.getAddress();
        int nodeID = agent.getNodeId();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)ServiceParameters.ParameterName.COLLECTION.toString(), (String)this.serviceName);
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("initialize: InetAddress={}, collectionName={}", (Object)hostAddress, (Object)collectionName);
        JMXNodeInfo nodeInfo = new JMXNodeInfo(nodeID);
        LOG.debug("nodeInfo: {} {} {}", new Object[]{hostAddress, nodeID, agent});
        Map attrMap = JMXDataCollectionConfigFactory.getInstance().getAttributeMap(collectionName, this.serviceName, hostAddress);
        nodeInfo.setAttributeMap(attrMap);
        Map<String, JMXDataSource> dsList = JMXCollector.buildDataSourceList(collectionName, attrMap);
        nodeInfo.setDsMap(dsList);
        nodeInfo.setMBeans(JMXDataCollectionConfigFactory.getInstance().getMBeanInfo(collectionName));
        agent.setAttribute(NODE_INFO_KEY, (Object)nodeInfo);
        agent.setAttribute("collectionName", (Object)collectionName);
    }

    public void release(CollectionAgent agent) {
    }

    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> map) {
        InetAddress ipaddr = (InetAddress)agent.getAddress();
        JMXNodeInfo nodeInfo = (JMXNodeInfo)agent.getAttribute(NODE_INFO_KEY);
        Map<String, BeanInfo> mbeans = nodeInfo.getMBeans();
        String collDir = this.serviceName;
        boolean useMbeanForRrds = ParameterMap.getKeyedBoolean(map, (String)ServiceParameters.ParameterName.USE_MBEAN_NAME_FOR_RRDS.toString(), (boolean)false);
        String port = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.PORT.toString(), null);
        String friendlyName = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.FRIENDLY_NAME.toString(), (String)port);
        if (this.useFriendlyName) {
            collDir = friendlyName;
        }
        JMXCollectionResource collectionResource = new JMXCollectionResource(agent, collDir);
        SingleResourceCollectionSet collectionSet = new SingleResourceCollectionSet((CollectionResource)collectionResource, new Date());
        ConnectionWrapper connection = null;
        LOG.debug("collecting {} on node ID {}", (Object)InetAddressUtils.str((InetAddress)ipaddr), (Object)nodeInfo.getNodeId());
        try {
            connection = this.getMBeanServerConnection(map, ipaddr);
            if (connection == null) {
                SingleResourceCollectionSet singleResourceCollectionSet = collectionSet;
                return singleResourceCollectionSet;
            }
            MBeanServerConnection mbeanServer = connection.getMBeanServer();
            int retry = ParameterMap.getKeyedInteger(map, (String)ServiceParameters.ParameterName.RETRY.toString(), (int)3);
            for (int attempts = 0; attempts <= retry; ++attempts) {
                try {
                    for (BeanInfo beanInfo : mbeans.values()) {
                        JMXCollectionAttributeType attribType;
                        JMXDataSource ds;
                        JMXCollectionAttributeType attribType2;
                        JMXDataSource ds2;
                        Attribute attrib;
                        String mbeanName = beanInfo.getMbeanName();
                        String objectName = beanInfo.getObjectName();
                        String excludeList = beanInfo.getExcludes();
                        String obj = useMbeanForRrds ? mbeanName : objectName;
                        AttributeGroupType attribGroupType = new AttributeGroupType(JMXCollector.fixGroupName(obj), "all");
                        List attribNames = beanInfo.getAttributeNames();
                        List compAttribNames = beanInfo.getCompositeAttributeNames();
                        for (String compAttribName : compAttribNames) {
                            if (!attribNames.contains(compAttribName)) continue;
                            attribNames.remove(compAttribName);
                            String[] ac = compAttribName.split("\\|", -1);
                            String attrName = ac[0];
                            if (attribNames.contains(attrName)) continue;
                            attribNames.add(attrName);
                        }
                        String[] attrNames = attribNames.toArray(new String[attribNames.size()]);
                        if (objectName.indexOf(42) == -1) {
                            LOG.debug("{} Collector - getAttributes: {}, # attributes: {}, # composite attribute members: {}", new Object[]{this.serviceName, objectName, attrNames.length, compAttribNames.size()});
                            try {
                                ObjectName oName = new ObjectName(objectName);
                                if (!mbeanServer.isRegistered(oName)) continue;
                                AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                Map<String, JMXDataSource> dsMap = nodeInfo.getDsMap();
                                for (Object attribute : attrList) {
                                    ArrayList<String> compositeMemberKeys = new ArrayList<String>();
                                    Boolean isComposite = false;
                                    attrib = (Attribute)attribute;
                                    for (String compAttrName : compAttribNames) {
                                        String[] attribKeys = compAttrName.split("\\|", -1);
                                        if (!attrib.getName().equals(attribKeys[0])) continue;
                                        compositeMemberKeys.add(attribKeys[1]);
                                        isComposite = true;
                                    }
                                    if (isComposite.booleanValue()) {
                                        try {
                                            CompositeData cd = (CompositeData)attrib.getValue();
                                            for (String key : compositeMemberKeys) {
                                                ds2 = dsMap.get(objectName + "|" + attrib.getName() + "|" + key);
                                                attribType2 = new JMXCollectionAttributeType(ds2, null, null, attribGroupType);
                                                collectionResource.setAttributeValue((CollectionAttributeType)attribType2, cd.get(key).toString());
                                            }
                                            continue;
                                        }
                                        catch (ClassCastException cce) {
                                            LOG.debug("{} Collection - getAttributes (try CompositeData) - ERROR: Failed to cast attribute value to type CompositeData!", (Object)this.serviceName, (Object)cce);
                                            continue;
                                        }
                                    }
                                    ds = dsMap.get(objectName + "|" + attrib.getName());
                                    attribType = new JMXCollectionAttributeType(ds, null, null, attribGroupType);
                                    collectionResource.setAttributeValue((CollectionAttributeType)attribType, attrib.getValue().toString());
                                }
                                continue;
                            }
                            catch (InstanceNotFoundException e) {
                                LOG.error("Unable to retrieve attributes from {}", (Object)objectName, (Object)e);
                                continue;
                            }
                        }
                        Set<ObjectName> mbeanSet = JMXCollector.getObjectNames(mbeanServer, objectName);
                        for (ObjectName oName : mbeanSet) {
                            LOG.debug("{} Collector - getAttributesWC: {}, # attributes: {}, alias: {}", new Object[]{this.serviceName, oName, attrNames.length, beanInfo.getKeyAlias()});
                            try {
                                if (excludeList == null) {
                                    if (!mbeanServer.isRegistered(oName)) continue;
                                    AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                    Map<String, JMXDataSource> dsMap = nodeInfo.getDsMap();
                                    for (Object attribute : attrList) {
                                        attrib = (Attribute)attribute;
                                        ds = dsMap.get(objectName + "|" + attrib.getName());
                                        attribType = new JMXCollectionAttributeType(ds, oName.getKeyProperty(beanInfo.getKeyField()), beanInfo.getKeyAlias(), attribGroupType);
                                        collectionResource.setAttributeValue((CollectionAttributeType)attribType, attrib.getValue().toString());
                                    }
                                    continue;
                                }
                                String keyName = oName.getKeyProperty(beanInfo.getKeyField());
                                boolean found = false;
                                StringTokenizer st = new StringTokenizer(excludeList, ",");
                                while (st.hasMoreTokens()) {
                                    if (!keyName.equals(st.nextToken())) continue;
                                    found = true;
                                    break;
                                }
                                if (found || !mbeanServer.isRegistered(oName)) continue;
                                AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                Map<String, JMXDataSource> dsMap = nodeInfo.getDsMap();
                                for (Object attribute : attrList) {
                                    Attribute attrib2 = (Attribute)attribute;
                                    ds2 = dsMap.get(objectName + "|" + attrib2.getName());
                                    attribType2 = new JMXCollectionAttributeType(ds2, oName.getKeyProperty(beanInfo.getKeyField()), beanInfo.getKeyAlias(), attribGroupType);
                                    collectionResource.setAttributeValue((CollectionAttributeType)attribType2, attrib2.getValue().toString());
                                }
                            }
                            catch (InstanceNotFoundException e) {
                                LOG.error("Error retrieving attributes for {}", (Object)oName, (Object)e);
                            }
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    LOG.debug("{} Collector.collect: IOException while collecting address: {}", new Object[]{this.serviceName, agent.getAddress(), e});
                    continue;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error getting MBeanServer", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        collectionSet.setStatus(1);
        return collectionSet;
    }

    private static Set<ObjectName> getObjectNames(MBeanServerConnection mbeanServer, String objectName) throws IOException, MalformedObjectNameException {
        return mbeanServer.queryNames(new ObjectName(objectName), null);
    }

    private static String fixGroupName(String objectName) {
        if (objectName == null) {
            return "NULL";
        }
        return AlphaNumeric.parseAndReplace((String)objectName, (char)'_');
    }

    private static String fixKey(String key, String attrName, String substitutions) {
        String newKey = key;
        if (key.startsWith(File.separator)) {
            newKey = key.substring(1);
        }
        if (substitutions != null && substitutions.length() > 0) {
            StringTokenizer st = new StringTokenizer(substitutions, ",");
            while (st.hasMoreTokens()) {
                int index;
                String token = st.nextToken();
                if (!newKey.equals(token.substring(0, index = token.indexOf(124)))) continue;
                newKey = token.substring(index + 1);
            }
        }
        return newKey;
    }

    protected static Map<String, JMXDataSource> buildDataSourceList(String collectionName, Map<String, List<Attrib>> attributeMap) {
        LOG.debug("buildDataSourceList - ***");
        HashMap<String, JMXDataSource> dsList = new HashMap<String, JMXDataSource>();
        LOG.debug("attributeMap size: {}", (Object)attributeMap.size());
        Iterator<String> objNameIter = attributeMap.keySet().iterator();
        while (objNameIter.hasNext()) {
            String objectName = objNameIter.next().toString();
            List<Attrib> list = attributeMap.get(objectName);
            LOG.debug("ObjectName: {}, Attributes: {}", (Object)objectName, (Object)list.size());
            for (Attrib attr : list) {
                JMXDataSource ds = null;
                String ds_type = JMXDataSource.mapType(attr.getType());
                if (ds_type != null) {
                    ds = new JMXDataSource();
                    ds.setHeartbeat(2 * JMXDataCollectionConfigFactory.getInstance().getStep(collectionName));
                    String ds_minval = attr.getMinval();
                    if (ds_minval == null) {
                        ds_minval = "U";
                    }
                    ds.setMax(ds_minval);
                    String ds_maxval = attr.getMaxval();
                    if (ds_maxval == null) {
                        ds_maxval = "U";
                    }
                    ds.setMax(ds_maxval);
                    ds.setInstance(collectionName);
                    String ds_name = attr.getAlias();
                    if (ds_name.length() > 19) {
                        LOG.warn("buildDataSourceList: alias '{}' exceeds 19 char maximum for RRD data source names, truncating.", (Object)attr.getAlias());
                        char[] temp = ds_name.toCharArray();
                        ds_name = String.copyValueOf(temp, 0, 19);
                    }
                    ds.setName(ds_name);
                    ds.setType(ds_type);
                    ds.setOid(attr.getName());
                    LOG.debug("buildDataSourceList: ds_name: {} ds_oid: {}.{} ds_max: {} ds_min: {}", new Object[]{ds.getName(), ds.getOid(), ds.getInstance(), ds.getMax(), ds.getMin()});
                    dsList.put(objectName + "|" + attr.getName(), ds);
                    continue;
                }
                LOG.warn("buildDataSourceList: Data type '{}' not supported.  Only integer-type data may be stored in RRD.  MBean object '{}' will not be mapped to RRD data source.", (Object)attr.getType(), (Object)attr.getAlias());
            }
        }
        return dsList;
    }

    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return JMXDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    public static class JMXCollectionResource
    extends AbstractCollectionResource {
        private final String m_resourceName;
        private final int m_nodeId;

        public JMXCollectionResource(CollectionAgent agent, String resourceName) {
            super(agent);
            this.m_resourceName = resourceName;
            this.m_nodeId = agent.getNodeId();
        }

        public String toString() {
            return "node[" + this.m_nodeId + ']';
        }

        public void setAttributeValue(CollectionAttributeType type, String value) {
            JMXCollectionAttribute attr = new JMXCollectionAttribute(this, type, value);
            this.addAttribute((CollectionAttribute)attr);
        }

        public File getResourceDir(RrdRepository repository) {
            return new File(repository.getRrdBaseDir(), this.getParent() + File.separator + this.m_resourceName);
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }
    }

    private static class JMXCollectionAttribute
    extends AbstractCollectionAttribute {
        private final String m_value;

        JMXCollectionAttribute(JMXCollectionResource resource, CollectionAttributeType attribType, String value) {
            super(attribType, (CollectionResource)resource);
            this.m_value = value;
        }

        public String getNumericValue() {
            return this.m_value;
        }

        public String getStringValue() {
            return this.m_value;
        }

        public String toString() {
            return "alias " + this.getName() + ", value " + this.m_value + ", resource " + this.m_resource + ", attributeType " + this.m_attribType;
        }

        public String getMetricIdentifier() {
            String metricId = this.m_attribType.getGroupType().getName();
            metricId = metricId.replace("_type_", ":type=");
            metricId = metricId.replace("_", ".");
            metricId = metricId.concat(".");
            metricId = metricId.concat(this.getName());
            return "JMX_".concat(metricId);
        }
    }

    private static class JMXCollectionAttributeType
    extends AbstractCollectionAttributeType {
        private final JMXDataSource m_dataSource;
        private final String m_name;

        public JMXCollectionAttributeType(JMXDataSource dataSource, String key, String substitutions, AttributeGroupType groupType) {
            super(groupType);
            this.m_dataSource = dataSource;
            this.m_name = this.createName(key, substitutions);
        }

        private String createName(String key, String substitutions) {
            String name = this.m_dataSource.getName();
            if (key != null && !key.equals("")) {
                name = JMXCollector.fixKey(key, this.m_dataSource.getName(), substitutions) + "_" + name;
            }
            return name;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            persister.persistNumericAttribute(attribute);
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_dataSource.getType();
        }
    }
}

