/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfResourceType
extends ResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(IfResourceType.class);
    private TreeMap<Integer, IfInfo> m_ifMap = new TreeMap();

    public IfResourceType(SnmpCollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        super(agent, snmpCollection);
        this.addKnownIfResources();
    }

    private Map<Integer, IfInfo> getIfMap() {
        return this.m_ifMap;
    }

    private void addIfInfo(IfInfo ifInfo) {
        this.getIfMap().put(ifInfo.getIndex(), ifInfo);
    }

    private void addKnownIfResources() {
        Set<IfInfo> ifInfos = this.getAgent().getSnmpInterfaceInfo(this);
        for (IfInfo ifInfo : ifInfos) {
            this.addIfInfo(ifInfo);
        }
    }

    @Override
    public SnmpInstId[] getCollectionInstances() {
        ArrayList<SnmpInstId> instances = new ArrayList<SnmpInstId>();
        for (IfInfo ifInfo : this.m_ifMap.values()) {
            if (!ifInfo.isCollectionEnabled()) continue;
            instances.add(new SnmpInstId(ifInfo.getIndex()));
        }
        return instances.toArray(new SnmpInstId[instances.size()]);
    }

    @Override
    public SnmpCollectionResource findResource(SnmpInstId inst) {
        return this.getIfMap().get(inst.toInt());
    }

    @Override
    public SnmpCollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        LOG.debug("findAliasedResource: Should not get called from IfResourceType");
        return null;
    }

    public Collection<IfInfo> getResources() {
        return Collections.unmodifiableCollection(this.m_ifMap.values());
    }

    @Override
    protected Collection<SnmpAttributeType> loadAttributeTypes() {
        return Collections.unmodifiableCollection(this.getCollection().getIndexedAttributeTypesForResourceType(this.getAgent(), this));
    }
}

