/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import org.opennms.netmgt.capsd.snmp.IfXTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

public final class IfXTable
extends SnmpTable<IfXTableEntry> {
    public IfXTable(InetAddress address) {
        super(address, "ifXTable", IfXTableEntry.ms_elemList);
    }

    @Override
    protected IfXTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IfXTableEntry(inst.toInt());
    }

    public IfXTableEntry getEntry(int ifIndex) {
        for (IfXTableEntry entry : this) {
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            return entry;
        }
        return null;
    }

    public String getIfName(int ifIndex) {
        for (IfXTableEntry ifXEntry : this) {
            int ifXIndex = -1;
            Integer snmpIfIndex = ifXEntry.getIfIndex();
            if (snmpIfIndex != null) {
                ifXIndex = snmpIfIndex;
            }
            if (ifXIndex != ifIndex) continue;
            return ifXEntry.getIfName();
        }
        return null;
    }

    public String getIfAlias(int ifIndex) {
        for (IfXTableEntry ifXEntry : this) {
            int ifXIndex = -1;
            Integer snmpIfIndex = ifXEntry.getIfIndex();
            if (snmpIfIndex != null) {
                ifXIndex = snmpIfIndex;
            }
            if (ifXIndex != ifIndex) continue;
            return ifXEntry.getIfAlias();
        }
        return null;
    }

    public Long getIfHighSpeed(int ifIndex) {
        for (IfXTableEntry ifXEntry : this) {
            int ifXIndex = -1;
            Integer snmpIfIndex = ifXEntry.getIfIndex();
            if (snmpIfIndex != null) {
                ifXIndex = snmpIfIndex;
            }
            if (ifXIndex != ifIndex) continue;
            return ifXEntry.getIfHighSpeed();
        }
        return null;
    }
}

