/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmbPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SmbPlugin.class);
    private static final String PROTOCOL_NAME = "SMB";

    private boolean isSmb(InetAddress host) {
        boolean isAServer = false;
        try {
            LOG.debug("host.getHostAddress(): {}", (Object)InetAddressUtils.str((InetAddress)host));
            NbtAddress nbtAddr = NbtAddress.getByName((String)InetAddressUtils.str((InetAddress)host));
            LOG.debug("nbtAddr.getHostName(): {}", (Object)nbtAddr.getHostName());
            if (nbtAddr.getHostName().equals(InetAddressUtils.str((InetAddress)host))) {
                LOG.debug("SmbPlugin: failed to retrieve SMB name for {}", (Object)InetAddressUtils.str((InetAddress)host));
            } else {
                isAServer = true;
            }
        }
        catch (UnknownHostException e) {
            LOG.debug("SmbPlugin: UnknownHostException: {}", (Object)e.getMessage());
        }
        catch (Throwable t) {
            LOG.error("SmbPlugin: An undeclared throwable exception was caught checking host {}", (Object)InetAddressUtils.str((InetAddress)host), (Object)t);
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isSmb(address);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        return this.isSmb(address);
    }
}

