/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.capsd.IfCollector;
import org.opennms.netmgt.capsd.IfSmbCollector;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.IfXTableEntry;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

final class SuspectEventProcessor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SuspectEventProcessor.class);
    private static final String EVENT_SOURCE = "OpenNMS.Capsd";
    private static String SQL_RETRIEVE_INTERFACE_NODEID_PREFIX = "SELECT nodeId FROM ipinterface WHERE ";
    private static final String SQL_RETRIEVE_IPINTERFACES_ON_NODEID = "SELECT ipaddr FROM ipinterface WHERE nodeid = ? and ismanaged != 'D'";
    String m_suspectIf;
    private CapsdDbSyncer m_capsdDbSyncer;
    private PluginManager m_pluginManager;
    private static Set<String> m_queuedSuspectTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SuspectEventProcessor(CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager, String ifAddress) {
        Assert.notNull((Object)capsdDbSyncer, (String)"The capsdDbSyncer argument cannot be null");
        Assert.notNull((Object)pluginManager, (String)"The pluginManager argument cannot be null");
        Assert.notNull((Object)ifAddress, (String)"The ifAddress argument cannot be null");
        this.m_capsdDbSyncer = capsdDbSyncer;
        this.m_pluginManager = pluginManager;
        this.m_suspectIf = ifAddress;
        Set<String> set = m_queuedSuspectTracker;
        synchronized (set) {
            m_queuedSuspectTracker.add(ifAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbNodeEntry getExistingNodeEntry(Connection dbc, IfCollector collector) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        LOG.debug("getExistingNodeEntry: checking for current target: {}", (Object)collector.getTarget());
        if (!collector.hasSnmpCollection() || collector.getSnmpCollector().failed()) {
            return null;
        }
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        IfTable ifTable = null;
        IpAddrTable ipAddrTable = null;
        if (snmpc.hasIfTable()) {
            ifTable = snmpc.getIfTable();
        }
        if (snmpc.hasIpAddrTable()) {
            ipAddrTable = snmpc.getIpAddrTable();
        }
        if (ifTable == null || ipAddrTable == null) {
            return null;
        }
        StringBuffer sqlBuffer = new StringBuffer(SQL_RETRIEVE_INTERFACE_NODEID_PREFIX);
        boolean firstAddress = true;
        ArrayList<String> ipaddrsOfNewNode = new ArrayList<String>();
        ArrayList<String> ipaddrsOfOldNode = new ArrayList<String>();
        for (IfTableEntry ifEntry : ifTable) {
            if (ifEntry.getIfIndex() == null) {
                LOG.debug("getExistingNodeEntry:  Breaking from loop");
                break;
            }
            int ifIndex = ifEntry.getIfIndex();
            List<InetAddress> ipAddrs = ipAddrTable.getIpAddresses(ifIndex);
            LOG.debug("getExistingNodeEntry: number of interfaces retrieved for ifIndex {} is: {}", (Object)ifIndex, (Object)ipAddrs.size());
            for (InetAddress ipAddress : ipAddrs) {
                if (ipAddress == null || InetAddressUtils.str((InetAddress)ipAddress).equals("0.0.0.0") || ipAddress.isLoopbackAddress()) continue;
                if (firstAddress) {
                    sqlBuffer.append("ipaddr='").append(InetAddressUtils.str((InetAddress)ipAddress)).append("'");
                    firstAddress = false;
                } else {
                    sqlBuffer.append(" OR ipaddr='").append(InetAddressUtils.str((InetAddress)ipAddress)).append("'");
                }
                ipaddrsOfNewNode.add(InetAddressUtils.str((InetAddress)ipAddress));
            }
        }
        if (firstAddress) {
            return null;
        }
        LOG.debug("getExistingNodeEntry: issuing SQL command: {}", (Object)sqlBuffer.toString());
        int nodeID = -1;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbc.prepareStatement(sqlBuffer.toString());
            d.watch((Object)stmt);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeID = rs.getInt(1);
                LOG.debug("getExistingNodeEntry: target {}/{}", (Object)InetAddressUtils.str((InetAddress)collector.getTarget()), (Object)nodeID);
                rs = null;
            }
        }
        finally {
            d.cleanUp();
        }
        if (nodeID == -1) {
            return null;
        }
        try {
            stmt = dbc.prepareStatement(SQL_RETRIEVE_IPINTERFACES_ON_NODEID);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                String ipaddr = rs.getString(1);
                if (ipaddr.equals("0.0.0.0")) continue;
                ipaddrsOfOldNode.add(ipaddr);
            }
        }
        finally {
            d.cleanUp();
        }
        if (ipaddrsOfNewNode.containsAll(ipaddrsOfOldNode)) {
            LOG.debug("getExistingNodeEntry: found one of the addrs under existing node: {}", (Object)nodeID);
            return DbNodeEntry.get(nodeID);
        }
        String dupIpaddr = this.getDuplicateIpaddress(ipaddrsOfOldNode, ipaddrsOfNewNode);
        this.createAndSendDuplicateIpaddressEvent(nodeID, dupIpaddr);
        return null;
    }

    private String getDuplicateIpaddress(List<String> ipListA, List<String> ipListB) {
        if (ipListA == null || ipListB == null) {
            return null;
        }
        String ipaddr2 = null;
        for (String ipaddr2 : ipListA) {
            if (ipListB.contains(ipaddr2)) {
                LOG.debug("getDuplicateIpaddress: get duplicate ip address: {}", (Object)ipaddr2);
                break;
            }
            ipaddr2 = null;
        }
        return ipaddr2;
    }

    private DbNodeEntry createNode(Connection dbc, InetAddress ifaddr, IfCollector collector) throws SQLException {
        InetAddress primaryIf = this.determinePrimaryInterface(collector);
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        IfSmbCollector smbc = collector.getSmbCollector();
        DbNodeEntry entryNode = DbNodeEntry.create();
        Date now = new Date();
        entryNode.setCreationTime(now);
        entryNode.setLastPoll(now);
        entryNode.setNodeType(OnmsNode.NodeType.ACTIVE);
        entryNode.setLabel(primaryIf.getHostName());
        if (entryNode.getLabel().equals(InetAddressUtils.str((InetAddress)primaryIf))) {
            entryNode.setLabelSource(OnmsNode.NodeLabelSource.ADDRESS);
        } else {
            entryNode.setLabelSource(OnmsNode.NodeLabelSource.HOSTNAME);
        }
        if (snmpc != null && snmpc.hasSystemGroup()) {
            SystemGroup sysgrp = snmpc.getSystemGroup();
            String sysObjectId = sysgrp.getSysObjectID();
            if (sysObjectId != null) {
                entryNode.setSystemOID(sysObjectId);
            } else {
                LOG.warn("SuspectEventProcessor: {} has NO sysObjectId!!!!", (Object)InetAddressUtils.str((InetAddress)ifaddr));
            }
            String str = sysgrp.getSysName();
            LOG.debug("SuspectEventProcessor: {} has sysName: {}", (Object)InetAddressUtils.str((InetAddress)ifaddr), (Object)str);
            if (str != null && str.length() > 0) {
                entryNode.setSystemName(str);
                if (entryNode.getLabelSource() == OnmsNode.NodeLabelSource.ADDRESS) {
                    entryNode.setLabel(str);
                    entryNode.setLabelSource(OnmsNode.NodeLabelSource.SYSNAME);
                }
            }
            str = sysgrp.getSysDescr();
            LOG.debug("SuspectEventProcessor: {} has sysDescription: {}", (Object)InetAddressUtils.str((InetAddress)ifaddr), (Object)str);
            if (str != null && str.length() > 0) {
                entryNode.setSystemDescription(str);
            }
            str = sysgrp.getSysLocation();
            LOG.debug("SuspectEventProcessor: {} has sysLocation: {}", (Object)InetAddressUtils.str((InetAddress)ifaddr), (Object)str);
            if (str != null && str.length() > 0) {
                entryNode.setSystemLocation(str);
            }
            str = sysgrp.getSysContact();
            LOG.debug("SuspectEventProcessor: {} has sysContact: {}", (Object)InetAddressUtils.str((InetAddress)ifaddr), (Object)str);
            if (str != null && str.length() > 0) {
                entryNode.setSystemContact(str);
            }
        }
        if (smbc != null && smbc.getNbtName() != null && entryNode.getLabelSource() != OnmsNode.NodeLabelSource.HOSTNAME) {
            entryNode.setLabel(smbc.getNbtName());
            entryNode.setLabelSource(OnmsNode.NodeLabelSource.NETBIOS);
            entryNode.setNetBIOSName(entryNode.getLabel());
            if (smbc.getDomainName() != null) {
                entryNode.setDomainName(smbc.getDomainName());
            }
        }
        entryNode.store(dbc);
        return entryNode;
    }

    private void addInterfaces(Connection dbc, DbNodeEntry node, boolean useExistingNode, InetAddress ifaddr, IfCollector collector) throws SQLException {
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        Date now = new Date();
        int nodeId = node.getNodeId();
        DbIpInterfaceEntry ipIfEntry = DbIpInterfaceEntry.create(nodeId, ifaddr);
        ipIfEntry.setLastPoll(now);
        ipIfEntry.setHostname(ifaddr.getHostName());
        boolean addrUnmanaged = cFactory.isAddressUnmanaged(ifaddr);
        if (addrUnmanaged) {
            LOG.debug("addInterfaces: {} is unmanaged", (Object)ifaddr);
            ipIfEntry.setManagedState('U');
        } else {
            LOG.debug("addInterfaces: {} is managed", (Object)ifaddr);
            ipIfEntry.setManagedState('M');
        }
        ipIfEntry.setPrimaryState('N');
        ipIfEntry.store(dbc);
        Package ipPkg = this.getPackageForNewInterface(dbc, ifaddr, ipIfEntry, addrUnmanaged);
        int ifIndex = this.addSnmpInterfaces(dbc, ifaddr, nodeId, collector, ipIfEntry);
        this.addSupportedProtocols(node, ifaddr, collector.getSupportedProtocols(), addrUnmanaged, ifIndex, ipPkg);
        if (useExistingNode) {
            return;
        }
        this.getSubInterfacesForNewInterface(dbc, node, ifaddr, collector, now, nodeId, ifIndex);
    }

    private int addSnmpInterfaces(Connection dbc, InetAddress ifaddr, int nodeId, IfCollector collector, DbIpInterfaceEntry ipIfEntry) throws SQLException {
        boolean addedSnmpInterfaceEntry = this.addIfTableSnmpInterfaces(dbc, ifaddr, nodeId, collector);
        int ifIndex = this.getIfIndexForNewInterface(dbc, ifaddr, collector, ipIfEntry);
        if (ifIndex == -100 || !addedSnmpInterfaceEntry) {
            DbSnmpInterfaceEntry snmpEntry = DbSnmpInterfaceEntry.create(nodeId, ifIndex);
            snmpEntry.store(dbc);
        }
        LOG.debug("SuspectEventProcessor: setting ifindex for {}/{} to {}", new Object[]{nodeId, ifaddr, ifIndex});
        ipIfEntry.setIfIndex(ifIndex);
        ipIfEntry.store(dbc);
        return ifIndex;
    }

    private Package getPackageForNewInterface(Connection dbc, InetAddress ifaddr, DbIpInterfaceEntry ipIfEntry, boolean addrUnmanaged) throws SQLException {
        if (addrUnmanaged) {
            return null;
        }
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        Package ipPkg = null;
        pollerCfgFactory.rebuildPackageIpListMap();
        boolean ipToBePolled = false;
        ipPkg = pollerCfgFactory.getFirstPackageMatch(InetAddressUtils.str((InetAddress)ifaddr));
        if (ipPkg != null) {
            ipToBePolled = true;
        }
        LOG.debug("addInterfaces: {} is to be polled = {}", (Object)ifaddr, (Object)ipToBePolled);
        if (!ipToBePolled) {
            ipIfEntry.setManagedState('N');
            ipIfEntry.store(dbc);
        }
        return ipPkg;
    }

    private int getIfIndexForNewInterface(Connection dbc, InetAddress ifaddr, IfCollector collector, DbIpInterfaceEntry ipIfEntry) throws SQLException {
        if (!collector.hasSnmpCollection()) {
            return -1;
        }
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        int ifIndex = -1;
        ipIfEntry.setPrimaryState('N');
        if (snmpc.hasIpAddrTable() && (ifIndex = snmpc.getIfIndex(ifaddr)) != -1) {
            int status;
            if (snmpc.hasIfTable() && (status = snmpc.getAdminStatus(ifIndex)) != -1) {
                ipIfEntry.setStatus(status);
            }
        } else {
            ifIndex = -100;
            LOG.debug("SuspectEventProcessor: no valid ifIndex for {} Assume this is a lame SNMP host", (Object)ifaddr);
        }
        ipIfEntry.store(dbc);
        return ifIndex;
    }

    private void getSubInterfacesForNewInterface(Connection dbc, DbNodeEntry node, InetAddress ifaddr, IfCollector collector, Date now, int nodeId, int ifIndex) throws SQLException {
        if (!collector.hasSnmpCollection()) {
            return;
        }
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        this.addSubIpInterfaces(dbc, node, collector, now, nodeId, cFactory, pollerCfgFactory, snmpc);
    }

    private void addSubIpInterfaces(Connection dbc, DbNodeEntry node, IfCollector collector, Date now, int nodeId, CapsdConfig cFactory, PollerConfig pollerCfgFactory, IfSnmpCollector snmpc) throws SQLException {
        if (!snmpc.hasIpAddrTable()) {
            return;
        }
        Map<InetAddress, List<IfCollector.SupportedProtocol>> extraTargets = collector.getAdditionalTargets();
        for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> xifaddrEntry : extraTargets.entrySet()) {
            LOG.debug("addInterfaces: adding interface {}", (Object)InetAddressUtils.str((InetAddress)xifaddrEntry.getKey()));
            DbIpInterfaceEntry xipIfEntry = DbIpInterfaceEntry.create(nodeId, xifaddrEntry.getKey());
            xipIfEntry.setLastPoll(now);
            xipIfEntry.setHostname(xifaddrEntry.getKey().getHostName());
            boolean xaddrUnmanaged = cFactory.isAddressUnmanaged(xifaddrEntry.getKey());
            if (xaddrUnmanaged) {
                xipIfEntry.setManagedState('U');
            } else {
                xipIfEntry.setManagedState('M');
            }
            xipIfEntry.setPrimaryState('N');
            int xifIndex = -1;
            xifIndex = snmpc.getIfIndex(xifaddrEntry.getKey());
            if (xifIndex != -1) {
                xipIfEntry.setIfIndex(xifIndex);
                int status = snmpc.getAdminStatus(xifIndex);
                if (status != -1) {
                    xipIfEntry.setStatus(status);
                }
                if (!SuspectEventProcessor.supportsSnmp(xifaddrEntry.getValue())) {
                    LOG.debug("addInterfaces: Interface doesn't support SNMP. {} set to not eligible", (Object)InetAddressUtils.str((InetAddress)xifaddrEntry.getKey()));
                }
            } else {
                LOG.debug("addInterfaces: No ifIndex found. {} set to not eligible", (Object)InetAddressUtils.str((InetAddress)xifaddrEntry.getKey()));
            }
            xipIfEntry.store(dbc);
            Package xipPkg = null;
            if (!xaddrUnmanaged) {
                PollerConfigFactory.getInstance().rebuildPackageIpListMap();
                boolean xipToBePolled = false;
                xipPkg = pollerCfgFactory.getFirstPackageMatch(InetAddressUtils.str((InetAddress)xifaddrEntry.getKey()));
                if (xipPkg != null) {
                    xipToBePolled = true;
                }
                if (!xipToBePolled) {
                    xipIfEntry.setManagedState('N');
                    xipIfEntry.store(dbc);
                }
            }
            this.addSupportedProtocols(node, xifaddrEntry.getKey(), extraTargets.get(xifaddrEntry.getKey()), xaddrUnmanaged, xifIndex, xipPkg);
        }
    }

    private boolean addIfTableSnmpInterfaces(Connection dbc, InetAddress ifaddr, int nodeId, IfCollector collector) throws SQLException {
        if (!collector.hasSnmpCollection()) {
            return false;
        }
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        if (!snmpc.hasIfTable()) {
            return false;
        }
        boolean addedSnmpInterfaceEntry = false;
        for (IfTableEntry ifte : snmpc.getIfTable()) {
            String ifAlias;
            if (ifte.getIfIndex() == null) continue;
            int xifIndex = ifte.getIfIndex();
            InetAddress[] addrs = null;
            if (snmpc.hasIpAddrTable()) {
                addrs = snmpc.getIfAddressAndMask(xifIndex);
            }
            if (addrs != null && addrs[0].isLoopbackAddress()) continue;
            DbSnmpInterfaceEntry snmpEntry = DbSnmpInterfaceEntry.create(nodeId, xifIndex);
            if (addrs == null) {
                snmpEntry.setCollect("N");
            } else {
                if (addrs[0].equals(ifaddr)) {
                    addedSnmpInterfaceEntry = true;
                }
                if (addrs[1] != null) {
                    snmpEntry.setNetmask(addrs[1]);
                }
                snmpEntry.setCollect("C");
            }
            String str = ifte.getIfDescr();
            if (addrs != null) {
                LOG.debug("SuspectEventProcessor: {} has ifDescription: {}", (Object)InetAddressUtils.str((InetAddress)addrs[0]), (Object)str);
            }
            if (str != null && str.length() > 0) {
                snmpEntry.setDescription(str);
            }
            String physAddr = null;
            try {
                physAddr = ifte.getPhysAddr();
                if (addrs != null) {
                    LOG.debug("SuspectEventProcessor: {} has physical address: -{}-", (Object)InetAddressUtils.str((InetAddress)addrs[0]), (Object)physAddr);
                }
            }
            catch (IllegalArgumentException iae) {
                physAddr = null;
                if (addrs != null) {
                    LOG.debug("ifPhysAddress.{} on node {} / {} could not be converted to a hex string (not a PhysAddr / OCTET STRING?), setting to null.", new Object[]{ifte.getIfIndex(), nodeId, InetAddressUtils.str((InetAddress)addrs[0])});
                }
                StringBuffer errMsg = new StringBuffer("SNMP agent bug on node ");
                errMsg.append(nodeId).append(" / ").append(InetAddressUtils.str((InetAddress)ifaddr));
                errMsg.append(": wrong type for physical address (see bug 2740). ");
                errMsg.append("Working around, but expect trouble with this node.");
                LOG.warn(errMsg.toString());
            }
            if (physAddr != null && physAddr.length() == 12) {
                snmpEntry.setPhysicalAddress(physAddr);
            }
            if (ifte.getIfType() == null) {
                snmpEntry.setType(0);
            } else {
                snmpEntry.setType(ifte.getIfType());
            }
            IfXTableEntry ifxte = snmpc.hasIfXTable() ? snmpc.getIfXTable().getEntry(xifIndex) : null;
            long speed = this.getInterfaceSpeed(ifte, ifxte);
            snmpEntry.setSpeed(speed);
            if (ifte.getIfAdminStatus() == null) {
                snmpEntry.setAdminStatus(0);
            } else {
                snmpEntry.setAdminStatus(ifte.getIfAdminStatus());
            }
            if (ifte.getIfOperStatus() == null) {
                snmpEntry.setOperationalStatus(0);
            } else {
                snmpEntry.setOperationalStatus(ifte.getIfOperStatus());
            }
            String ifName = snmpc.getIfName(xifIndex);
            if (ifName != null && ifName.length() > 0) {
                snmpEntry.setName(ifName);
            }
            if ((ifAlias = snmpc.getIfAlias(xifIndex)) != null && ifAlias.length() > 0) {
                snmpEntry.setAlias(ifAlias);
            }
            snmpEntry.store(dbc);
        }
        return addedSnmpInterfaceEntry;
    }

    private long getInterfaceSpeed(IfTableEntry ifte, IfXTableEntry ifxte) {
        if (ifxte != null && ifxte.getIfHighSpeed() != null && ifxte.getIfHighSpeed() > 4294L) {
            return ifxte.getIfHighSpeed() * 1000000L;
        }
        if (ifte != null && ifte.getIfSpeed() != null) {
            return ifte.getIfSpeed();
        }
        return 0L;
    }

    private void addSupportedProtocols(DbNodeEntry node, InetAddress ifaddr, List<IfCollector.SupportedProtocol> protocols, boolean addrUnmanaged, int ifIndex, Package ipPkg) throws SQLException {
        if (InetAddressUtils.str((InetAddress)ifaddr).equals("0.0.0.0")) {
            LOG.debug("addSupportedProtocols: node {}: Cant add ip services for non-ip interface. Just return.", (Object)node.getNodeId());
            return;
        }
        for (IfCollector.SupportedProtocol p : protocols) {
            Integer sid = this.m_capsdDbSyncer.getServiceId(p.getProtocolName());
            DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.create(node.getNodeId(), ifaddr, sid);
            if (addrUnmanaged) {
                ifSvcEntry.setStatus('U');
            } else if (this.isServicePolledLocally(InetAddressUtils.str((InetAddress)ifaddr), p.getProtocolName(), ipPkg)) {
                ifSvcEntry.setStatus('A');
            } else if (this.isServicePolled(InetAddressUtils.str((InetAddress)ifaddr), p.getProtocolName(), ipPkg)) {
                ifSvcEntry.setStatus('X');
            } else {
                ifSvcEntry.setStatus('N');
            }
            if (p.getQualifiers() != null && p.getQualifiers().get("port") != null) {
                try {
                    Integer port = (Integer)p.getQualifiers().get("port");
                    ifSvcEntry.setQualifier(port.toString());
                }
                catch (ClassCastException ccE) {
                    // empty catch block
                }
            }
            ifSvcEntry.setSource('P');
            ifSvcEntry.setNotify('Y');
            if (ifIndex != -1) {
                ifSvcEntry.setIfIndex(ifIndex);
            }
            ifSvcEntry.store();
        }
    }

    private boolean isServicePolled(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !(svcToBePolled = PollerConfigFactory.getInstance().isPolled(svcName, ipPkg))) {
            svcToBePolled = PollerConfigFactory.getInstance().isPolled(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    private boolean isServicePolledLocally(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !ipPkg.getRemote().booleanValue() && !(svcToBePolled = PollerConfigFactory.getInstance().isPolled(svcName, ipPkg))) {
            svcToBePolled = PollerConfigFactory.getInstance().isPolledLocally(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    static boolean supportsSnmp(List<IfCollector.SupportedProtocol> supportedProtocols) {
        for (IfCollector.SupportedProtocol p : supportedProtocols) {
            if (!p.getProtocolName().equals("SNMP")) continue;
            return true;
        }
        return false;
    }

    static boolean hasIfIndex(InetAddress ipaddr, IfSnmpCollector snmpc) {
        int ifIndex = -1;
        if (snmpc.hasIpAddrTable()) {
            ifIndex = snmpc.getIfIndex(ipaddr);
        }
        LOG.debug("hasIfIndex: ipAddress: {} has ifIndex: {}", (Object)InetAddressUtils.str((InetAddress)ipaddr), (Object)ifIndex);
        return ifIndex != -1;
    }

    static int getIfType(InetAddress ipaddr, IfSnmpCollector snmpc) {
        int ifIndex = snmpc.getIfIndex(ipaddr);
        int ifType = snmpc.getIfType(ifIndex);
        LOG.debug("getIfType: ipAddress: {} has ifIndex: {} and ifType: {}", new Object[]{InetAddressUtils.str((InetAddress)ipaddr), ifIndex, ifType});
        return ifType;
    }

    static InetAddress compareAndSelectPrimary(InetAddress currentIf, InetAddress oldPrimary) {
        byte[] primary;
        InetAddress newPrimary = null;
        if (oldPrimary == null) {
            if (!CapsdConfigFactory.getInstance().isAddressUnmanaged(currentIf)) {
                return currentIf;
            }
            return oldPrimary;
        }
        byte[] current = currentIf.getAddress();
        if (new ByteArrayComparator().compare(current, primary = oldPrimary.getAddress()) < 0 && !CapsdConfigFactory.getInstance().isAddressUnmanaged(currentIf)) {
            newPrimary = currentIf;
        }
        if (newPrimary != null) {
            return newPrimary;
        }
        return oldPrimary;
    }

    private List<InetAddress> buildLBSnmpAddressList(IfCollector collector) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (collector.getSnmpCollector() == null) {
            LOG.debug("buildLBSnmpAddressList: no SNMP info for {}", (Object)collector.getTarget());
            return addresses;
        }
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        if (!snmpc.hasIfTable() || !snmpc.hasIpAddrTable()) {
            LOG.info("buildLBSnmpAddressList: missing SNMP info for {}", (Object)collector.getTarget());
            return addresses;
        }
        InetAddress ipAddr = collector.getTarget();
        if (SuspectEventProcessor.supportsSnmp(collector.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ipAddr, snmpc) && SuspectEventProcessor.getIfType(ipAddr, snmpc) == 24) {
            LOG.debug("buildLBSnmpAddressList: adding target interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)ipAddr));
            addresses.add(ipAddr);
        }
        if (collector.hasAdditionalTargets()) {
            Map<InetAddress, List<IfCollector.SupportedProtocol>> extraTargets = collector.getAdditionalTargets();
            for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> currIfEntry : extraTargets.entrySet()) {
                if (!SuspectEventProcessor.supportsSnmp(currIfEntry.getValue()) || SuspectEventProcessor.getIfType(currIfEntry.getKey(), snmpc) != 24) continue;
                LOG.debug("buildLBSnmpAddressList: adding subtarget interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)currIfEntry.getKey()));
                addresses.add(currIfEntry.getKey());
            }
        }
        return addresses;
    }

    private List<InetAddress> buildSnmpAddressList(IfCollector collector) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (collector.getSnmpCollector() == null) {
            LOG.debug("buildSnmpAddressList: no SNMP info for {}", (Object)collector.getTarget());
            return addresses;
        }
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        if (!snmpc.hasIfTable() || !snmpc.hasIpAddrTable()) {
            LOG.info("buildSnmpAddressList: missing SNMP info for {}", (Object)collector.getTarget());
            return addresses;
        }
        InetAddress ipAddr = collector.getTarget();
        if (SuspectEventProcessor.supportsSnmp(collector.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ipAddr, snmpc)) {
            LOG.debug("buildSnmpAddressList: adding target interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)ipAddr));
            addresses.add(ipAddr);
        }
        if (collector.hasAdditionalTargets()) {
            Map<InetAddress, List<IfCollector.SupportedProtocol>> extraTargets = collector.getAdditionalTargets();
            for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> currIfEntry : extraTargets.entrySet()) {
                if (!SuspectEventProcessor.supportsSnmp(currIfEntry.getValue()) || !SuspectEventProcessor.hasIfIndex(currIfEntry.getKey(), snmpc)) continue;
                LOG.debug("buildSnmpAddressList: adding subtarget interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)currIfEntry.getKey()));
                addresses.add(currIfEntry.getKey());
            }
        }
        return addresses;
    }

    private InetAddress determinePrimaryInterface(IfCollector collector) {
        InetAddress primaryIf = null;
        primaryIf = collector.getTarget();
        if (collector.hasAdditionalTargets()) {
            Map<InetAddress, List<IfCollector.SupportedProtocol>> extraTargets = collector.getAdditionalTargets();
            for (InetAddress currIf : extraTargets.keySet()) {
                primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf, primaryIf);
            }
        }
        if (primaryIf != null) {
            LOG.debug("determinePrimaryInterface: selected primary interface: {}", (Object)InetAddressUtils.str((InetAddress)primaryIf));
        } else {
            LOG.debug("determinePrimaryInterface: no primary interface found");
        }
        return primaryIf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object dbc;
        InetAddress ifaddr = null;
        ifaddr = InetAddressUtils.addr((String)this.m_suspectIf);
        if (ifaddr == null) {
            LOG.warn("SuspectEventProcessor: Failed to convert interface address {} to InetAddress", (Object)this.m_suspectIf);
            return;
        }
        LOG.debug("SuspectEventProcessor: running collection for {}", (Object)InetAddressUtils.str((InetAddress)ifaddr));
        IfCollector collector = new IfCollector(this.m_pluginManager, ifaddr, true);
        collector.run();
        InetAddress oldSnmpPrimaryIf = null;
        InetAddress newSnmpPrimaryIf = null;
        boolean updateCompleted = false;
        boolean useExistingNode = false;
        DbNodeEntry entryNode = null;
        try {
            dbc = null;
            Object object = Capsd.getDbSyncLock();
            synchronized (object) {
                try {
                    dbc = DataSourceFactory.getInstance().getConnection();
                    if (!this.m_capsdDbSyncer.isInterfaceInDB((Connection)dbc, ifaddr)) {
                        Iterator<InetAddress> opiter;
                        entryNode = this.getExistingNodeEntry((Connection)dbc, collector);
                        if (entryNode == null) {
                            entryNode = this.createNode((Connection)dbc, ifaddr, collector);
                        } else {
                            useExistingNode = true;
                        }
                        List<InetAddress> oldPriIfs = this.getPrimarySnmpInterfaceFromDb((Connection)dbc, entryNode);
                        this.addInterfaces((Connection)dbc, entryNode, useExistingNode, ifaddr, collector);
                        boolean strict = true;
                        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
                        List<InetAddress> lbAddressList = this.buildLBSnmpAddressList(collector);
                        List<InetAddress> addressList = this.buildSnmpAddressList(collector);
                        for (InetAddress addr : addressList) {
                            if (!this.m_capsdDbSyncer.isServiceCollectionEnabled(InetAddressUtils.str((InetAddress)addr), "SNMP")) continue;
                            DBUtils d = new DBUtils(this.getClass());
                            try {
                                PreparedStatement stmt = dbc.prepareStatement("UPDATE ipInterface SET isSnmpPrimary='S' WHERE nodeId=? AND ipAddr=? AND isManaged!='D'");
                                d.watch((Object)stmt);
                                stmt.setInt(1, entryNode.getNodeId());
                                stmt.setString(2, InetAddressUtils.str((InetAddress)addr));
                                stmt.executeUpdate();
                                LOG.debug("updated {} to secondary.", (Object)InetAddressUtils.str((InetAddress)addr));
                            }
                            finally {
                                d.cleanUp();
                            }
                        }
                        String psiType = null;
                        if (lbAddressList != null) {
                            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(lbAddressList, strict);
                            psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
                        }
                        if (newSnmpPrimaryIf == null) {
                            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(addressList, strict);
                            psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
                        }
                        strict = false;
                        if (newSnmpPrimaryIf == null && lbAddressList != null) {
                            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(lbAddressList, strict);
                            psiType = "DB loopback addresses";
                        }
                        if (newSnmpPrimaryIf == null) {
                            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(addressList, strict);
                            psiType = "DB addresses";
                        }
                        if (collector.hasSnmpCollection() && newSnmpPrimaryIf == null) {
                            newSnmpPrimaryIf = ifaddr;
                            psiType = "New suspect ip address";
                        }
                        if (LOG.isDebugEnabled()) {
                            if (newSnmpPrimaryIf == null) {
                                LOG.debug("No primary SNMP interface found");
                            } else {
                                LOG.debug("primary SNMP interface is: {}, selected from {}", (Object)newSnmpPrimaryIf, (Object)psiType);
                            }
                        }
                        if ((opiter = oldPriIfs.iterator()).hasNext()) {
                            while (opiter.hasNext()) {
                                SuspectEventProcessor.setPrimarySnmpInterface((Connection)dbc, entryNode, newSnmpPrimaryIf, opiter.next());
                            }
                        } else {
                            SuspectEventProcessor.setPrimarySnmpInterface((Connection)dbc, entryNode, newSnmpPrimaryIf, null);
                        }
                        updateCompleted = true;
                    }
                }
                finally {
                    if (dbc != null) {
                        try {
                            dbc.close();
                        }
                        catch (SQLException e) {
                            LOG.info("run: an sql exception occured closing the database connection", (Throwable)e);
                        }
                    }
                    dbc = null;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Error writing records", t);
        }
        finally {
            dbc = m_queuedSuspectTracker;
            synchronized (dbc) {
                m_queuedSuspectTracker.remove(InetAddressUtils.str((InetAddress)ifaddr));
            }
        }
        if (updateCompleted) {
            if (!useExistingNode) {
                this.createAndSendNodeAddedEvent(entryNode);
            }
            this.sendInterfaceEvents(entryNode, useExistingNode, ifaddr, collector);
            if (useExistingNode) {
                this.generateSnmpDataCollectionEvents(entryNode, oldSnmpPrimaryIf, newSnmpPrimaryIf);
            }
        }
        LOG.debug("sendInterfaceEvents: sending suspect scan completed event for {}", (Object)InetAddressUtils.str((InetAddress)ifaddr));
        LOG.debug("SuspectEventProcessor for {} completed.", (Object)this.m_suspectIf);
        this.createAndSendSuspectScanCompletedEvent(ifaddr);
    }

    List<InetAddress> getPrimarySnmpInterfaceFromDb(Connection dbc, DbNodeEntry node) throws SQLException {
        ArrayList<InetAddress> priSnmpAddrs = new ArrayList<InetAddress>();
        LOG.debug("getPrimarySnmpInterfaceFromDb: retrieving primary SNMP interface(s) from DB for node {}", (Object)node.getNodeId());
        InetAddress oldPrimarySnmpIf = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = dbc.prepareStatement("SELECT ipAddr FROM ipInterface WHERE nodeId=? AND isSnmpPrimary='P' AND isManaged!='D'");
            d.watch((Object)stmt);
            stmt.setInt(1, node.getNodeId());
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                String oldPrimaryAddr = rs.getString(1);
                LOG.debug("getPrimarySnmpInterfaceFromDb: String oldPrimaryAddr = {}", (Object)oldPrimaryAddr);
                if (oldPrimaryAddr == null) continue;
                oldPrimarySnmpIf = InetAddressUtils.addr((String)oldPrimaryAddr);
                LOG.debug("getPrimarySnmpInterfaceFromDb: old primary SNMP interface is {}", (Object)oldPrimaryAddr);
                priSnmpAddrs.add(oldPrimarySnmpIf);
            }
        }
        catch (SQLException sqlE) {
            LOG.warn("getPrimarySnmpInterfaceFromDb: Exception: {}", (Throwable)sqlE);
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
        return priSnmpAddrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPrimarySnmpInterface(Connection dbc, DbNodeEntry node, InetAddress newPrimarySnmpIf, InetAddress oldPrimarySnmpIf) throws SQLException {
        if (newPrimarySnmpIf == null) {
            LOG.debug("setPrimarySnmpInterface: newSnmpPrimary is null, nothing to set, returning.");
            return;
        }
        LOG.debug("setPrimarySnmpInterface: newSnmpPrimary = {}", (Object)newPrimarySnmpIf);
        if (oldPrimarySnmpIf != null && oldPrimarySnmpIf.equals(newPrimarySnmpIf)) {
            LOG.debug("setPrimarySnmpInterface: Old and new primary interfaces are the same");
        }
        if (newPrimarySnmpIf != null) {
            LOG.debug("setPrimarySnmpInterface: Updating primary SNMP interface {}", (Object)InetAddressUtils.str((InetAddress)newPrimarySnmpIf));
            DBUtils d = new DBUtils(SuspectEventProcessor.class);
            try {
                PreparedStatement stmt = dbc.prepareStatement("UPDATE ipInterface SET isSnmpPrimary='P' WHERE nodeId=? AND ipaddr=? AND isManaged!='D'");
                d.watch((Object)stmt);
                stmt.setInt(1, node.getNodeId());
                stmt.setString(2, InetAddressUtils.str((InetAddress)newPrimarySnmpIf));
                stmt.executeUpdate();
                LOG.debug("setPrimarySnmpInterface: Completed update of new primary interface to PRIMARY.");
            }
            finally {
                d.cleanUp();
            }
        }
    }

    public static synchronized void setQueuedSuspectsTracker(Set<String> queuedSuspectTracker) {
        m_queuedSuspectTracker = Collections.synchronizedSet(queuedSuspectTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isScanQueuedForAddress(String ipAddr) {
        Set<String> set = m_queuedSuspectTracker;
        synchronized (set) {
            return m_queuedSuspectTracker.contains(ipAddr);
        }
    }

    private void generateSnmpDataCollectionEvents(DbNodeEntry nodeEntry, InetAddress oldPrimary, InetAddress newPrimary) {
        if (oldPrimary == null && newPrimary == null) {
            LOG.warn("generateSnmpDataCollectionEvents: both old and new primary SNMP interface vars are null!");
        } else if (oldPrimary != null && newPrimary == null) {
            LOG.warn("generateSnmpDataCollectionEvents: old primary ({}) is not null but new primary is null!", (Object)InetAddressUtils.str((InetAddress)oldPrimary));
        } else if (oldPrimary == null && newPrimary != null) {
            LOG.debug("generateSnmpDataCollectionEvents: identified {} as the primary SNMP interface for node {}", (Object)InetAddressUtils.str((InetAddress)newPrimary), (Object)nodeEntry.getNodeId());
        } else if (!oldPrimary.equals(newPrimary)) {
            LOG.debug("generateSnmpDataCollectionEvents: primary SNMP interface has changed.  Was: {} Is: {}", (Object)InetAddressUtils.str((InetAddress)oldPrimary), (Object)InetAddressUtils.str((InetAddress)newPrimary));
            this.createAndSendPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), newPrimary, oldPrimary);
        } else {
            LOG.debug("generateSnmpDataCollectionEvents: Generating reinitializeSnmpInterface event for interface {}", (Object)InetAddressUtils.str((InetAddress)newPrimary));
            this.createAndSendReinitializePrimarySnmpInterfaceEvent(nodeEntry.getNodeId(), newPrimary);
        }
    }

    private void createAndSendPrimarySnmpInterfaceChangedEvent(int nodeId, InetAddress newPrimaryIf, InetAddress oldPrimaryIf) {
        LOG.debug("createAndSendPrimarySnmpInterfaceChangedEvent: nodeId: {} oldPrimarySnmpIf: '{}' newPrimarySnmpIf: '{}'", new Object[]{nodeId, InetAddressUtils.str((InetAddress)oldPrimaryIf), InetAddressUtils.str((InetAddress)newPrimaryIf)});
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        bldr.setNodeid((long)nodeId);
        bldr.setInterface(newPrimaryIf);
        bldr.setService("SNMP");
        if (InetAddressUtils.str((InetAddress)oldPrimaryIf) != null) {
            bldr.addParam("oldPrimarySnmpAddress", InetAddressUtils.str((InetAddress)oldPrimaryIf));
        }
        if (InetAddressUtils.str((InetAddress)newPrimaryIf) != null) {
            bldr.addParam("newPrimarySnmpAddress", InetAddressUtils.str((InetAddress)newPrimaryIf));
        }
        this.sendEvent(bldr.getEvent());
    }

    private void createAndSendReinitializePrimarySnmpInterfaceEvent(int nodeId, InetAddress primarySnmpIf) {
        LOG.debug("reinitializePrimarySnmpInterface: nodeId: {} interface: {}", (Object)nodeId, (Object)InetAddressUtils.str((InetAddress)primarySnmpIf));
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        bldr.setNodeid((long)nodeId);
        bldr.setInterface(primarySnmpIf);
        this.sendEvent(bldr.getEvent());
    }

    private void sendInterfaceEvents(DbNodeEntry node, boolean useExistingNode, InetAddress ifaddr, IfCollector collector) {
        LOG.debug("sendInterfaceEvents: sending node gained interface event for {}", (Object)InetAddressUtils.str((InetAddress)ifaddr));
        this.createAndSendNodeGainedInterfaceEvent(node.getNodeId(), ifaddr);
        LOG.debug("sendInterfaceEvents: processing supported services for {}", (Object)InetAddressUtils.str((InetAddress)ifaddr));
        for (IfCollector.SupportedProtocol p : collector.getSupportedProtocols()) {
            LOG.debug("sendInterfaceEvents: sending event for service: {}", (Object)p.getProtocolName());
            this.createAndSendNodeGainedServiceEvent(node, ifaddr, p.getProtocolName(), null);
        }
        if (useExistingNode) {
            return;
        }
        if (collector.hasSnmpCollection() && !collector.getSnmpCollector().failed()) {
            Map<InetAddress, List<IfCollector.SupportedProtocol>> extraTargets = collector.getAdditionalTargets();
            for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> xifaddrEntry : extraTargets.entrySet()) {
                this.createAndSendNodeGainedInterfaceEvent(node.getNodeId(), xifaddrEntry.getKey());
                List<IfCollector.SupportedProtocol> supportedProtocols = xifaddrEntry.getValue();
                LOG.debug("interface {} supports {} protocols.", (Object)xifaddrEntry.getKey(), (Object)supportedProtocols.size());
                if (supportedProtocols == null) continue;
                for (IfCollector.SupportedProtocol p : supportedProtocols) {
                    this.createAndSendNodeGainedServiceEvent(node, xifaddrEntry.getKey(), p.getProtocolName(), null);
                }
            }
        }
    }

    private void createAndSendNodeAddedEvent(DbNodeEntry nodeEntry) {
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/nodes/nodeAdded");
        bldr.setNodeid((long)nodeEntry.getNodeId());
        bldr.addParam("nodelabel", nodeEntry.getLabel());
        if (nodeEntry.getLabelSource() != null) {
            bldr.addParam("nodelabelsource", nodeEntry.getLabelSource().toString());
        }
        bldr.addParam("method", "icmp");
        this.sendEvent(bldr.getEvent());
    }

    private EventBuilder createEventBuilder(String uei) {
        EventBuilder bldr = new EventBuilder(uei, EVENT_SOURCE);
        bldr.setHost(Capsd.getLocalHostAddress());
        return bldr;
    }

    private void sendEvent(Event newEvent) {
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
            LOG.debug("sendEvent: successfully sent: {}", (Object)this.toString(newEvent));
        }
        catch (Throwable t) {
            LOG.warn("run: unexpected throwable exception caught during send to middleware", t);
        }
    }

    private String toString(Event e) {
        StringBuilder buf = new StringBuilder();
        buf.append("Event uei: ").append(e.getUei());
        buf.append(" For ").append(e.getNodeid()).append('/').append(e.getInterface()).append('/').append(e.getService());
        return buf.toString();
    }

    private void createAndSendDuplicateIpaddressEvent(int nodeId, String ipAddr) {
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/internal/capsd/duplicateIPAddress");
        bldr.setNodeid((long)nodeId);
        bldr.setInterface(InetAddressUtils.addr((String)ipAddr));
        bldr.addParam("iphostname", this.getHostName(ipAddr));
        bldr.addParam("method", "icmp");
        this.sendEvent(bldr.getEvent());
    }

    private String getHostName(String ipAddr) {
        String hostName = InetAddressUtils.normalize((String)ipAddr);
        return hostName == null ? "" : hostName;
    }

    private void createAndSendNodeGainedInterfaceEvent(int nodeId, InetAddress ipAddr) {
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/nodes/nodeGainedInterface");
        bldr.setNodeid((long)nodeId);
        bldr.setInterface(ipAddr);
        bldr.addParam("iphostname", ipAddr.getHostName());
        bldr.addParam("method", "icmp");
        this.sendEvent(bldr.getEvent());
    }

    private void createAndSendNodeGainedServiceEvent(DbNodeEntry nodeEntry, InetAddress ipAddr, String svcName, String qualifier) {
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/nodes/nodeGainedService");
        bldr.setNodeid((long)nodeEntry.getNodeId());
        bldr.setInterface(ipAddr);
        bldr.setService(svcName);
        bldr.addParam("iphostname", ipAddr.getHostName());
        bldr.addParam("nodelabel", nodeEntry.getLabel());
        if (nodeEntry.getLabelSource() != null) {
            bldr.addParam("nodelabelsource", nodeEntry.getLabelSource().toString());
        }
        if (qualifier != null && qualifier.length() > 0) {
            bldr.addParam("qualifier", qualifier);
        }
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        this.sendEvent(bldr.getEvent());
    }

    private void createAndSendSuspectScanCompletedEvent(InetAddress ipAddr) {
        EventBuilder bldr = this.createEventBuilder("uei.opennms.org/internal/capsd/suspectScanCompleted");
        bldr.setInterface(ipAddr);
        bldr.addParam("iphostname", ipAddr.getHostName());
        this.sendEvent(bldr.getEvent());
    }
}

