/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.capsd.IfCollector;
import org.opennms.netmgt.capsd.IfSmbCollector;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.IfXTableEntry;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RescanProcessor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RescanProcessor.class);
    private static final String s_ZERO_ZERO_ZERO_ZERO = "0.0.0.0";
    private static final InetAddress ZERO_ZERO_ZERO_ZERO = InetAddressUtils.addr((String)"0.0.0.0");
    static final String SQL_DB_RETRIEVE_NODE_TYPE = "SELECT nodetype FROM node WHERE nodeID=?";
    static final String SQL_DB_RETRIEVE_OTHER_NODES = "SELECT ipinterface.nodeid FROM ipinterface, node WHERE ipinterface.ismanaged != 'D' AND ipinterface.ipaddr = ? AND ipinterface.nodeid = node.nodeid AND node.foreignsource IS NULL AND ipinterface.nodeid !=? ";
    static final String SQL_DB_REPARENT_IP_INTERFACE_LOOKUP = "SELECT ipaddr, ifindex FROM ipinterface WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_IP_INTERFACE_DELETE = "DELETE FROM ipinterface WHERE nodeID=? AND ipaddr=?";
    static final String SQL_DB_REPARENT_IP_INTERFACE = "UPDATE ipinterface SET nodeID=? WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_SNMP_IF_LOOKUP = "SELECT id FROM snmpinterface WHERE nodeID=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_SNMP_IF_DELETE = "DELETE FROM snmpinterface WHERE nodeID=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_SNMP_INTERFACE = "UPDATE snmpinterface SET nodeID=? WHERE nodeID=? AND snmpifindex=?";
    static final String SQL_DB_REPARENT_IF_SERVICES_LOOKUP = "SELECT serviceid FROM ifservices WHERE nodeID=? AND ipaddr=? AND ifindex = ? AND status!='D'";
    static final String SQL_DB_REPARENT_IF_SERVICES_DELETE = "DELETE FROM ifservices WHERE nodeID=? AND ipaddr=? ";
    static final String SQL_DB_REPARENT_IF_SERVICES = "UPDATE ifservices SET nodeID=? WHERE nodeID=? AND ipaddr=? AND status!='D'";
    static final String SQL_DB_DELETE_DUP_INTERFACE = "DELETE FROM ipinterface WHERE nodeID=?";
    static final String SQL_DB_DELETE_DUP_SERVICES = "DELETE FROM ifservices WHERE nodeid=?";
    static final String SQL_DB_DELETE_DUP_SNMPINTERFACE = "DELETE FROM snmpinterface WHERE nodeid =?";
    private static final String SQL_RETRIEVE_SERVICE_IDS = "SELECT serviceid,servicename  FROM service";
    private static final String SQL_DB_UPDATE_ISMANAGED = "UPDATE ipinterface SET ismanaged=? WHERE nodeID=? AND ipaddr=? AND isManaged!='D'";
    private boolean m_forceRescan;
    private final List<Event> m_eventList = new ArrayList<Event>();
    private boolean m_ifIndexOnNodeChangedFlag;
    private boolean m_snmpIfTableChangedFlag;
    private CapsdDbSyncer m_capsdDbSyncer;
    private PluginManager m_pluginManager;
    private int m_nodeId;
    private static Set<Integer> s_queuedRescanTracker;

    RescanProcessor(Scheduler.NodeInfo nodeInfo, boolean forceRescan, CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager) {
        this(nodeInfo.getNodeId(), forceRescan, capsdDbSyncer, pluginManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RescanProcessor(int nodeId, boolean forceRescan, CapsdDbSyncer capsdDbSyncer, PluginManager pluginManager) {
        this.m_nodeId = nodeId;
        this.m_forceRescan = forceRescan;
        this.m_capsdDbSyncer = capsdDbSyncer;
        this.m_pluginManager = pluginManager;
        Set<Integer> set = s_queuedRescanTracker;
        synchronized (set) {
            s_queuedRescanTracker.add(nodeId);
        }
    }

    private DbNodeEntry updateNode(Connection dbc, Date now, DbNodeEntry dbNodeEntry, InetAddress currPrimarySnmpIf, DbIpInterfaceEntry[] dbIpInterfaces, Map<String, IfCollector> collectorMap) throws SQLException {
        LOG.debug("updateNode: updating node id {}", (Object)dbNodeEntry.getNodeId());
        DbNodeEntry originalDbNodeEntry = DbNodeEntry.clone(dbNodeEntry);
        DbNodeEntry currNodeEntry = DbNodeEntry.create();
        currNodeEntry.setNodeType(OnmsNode.NodeType.ACTIVE);
        RescanProcessor.setNodeLabelAndSmbInfo(collectorMap, dbNodeEntry, currNodeEntry, currPrimarySnmpIf);
        if (currPrimarySnmpIf != null) {
            IfCollector primaryIfc;
            String addr = InetAddressUtils.str((InetAddress)currPrimarySnmpIf);
            IfCollector ifCollector = primaryIfc = addr == null ? null : collectorMap.get(addr);
            if (primaryIfc == null) {
                for (IfCollector tmp : collectorMap.values()) {
                    if (tmp.getSnmpCollector() == null) continue;
                    primaryIfc = tmp;
                    break;
                }
            }
            if (primaryIfc == null) {
                LOG.error("updateNode: failed to determine primary interface collector for node {}", (Object)dbNodeEntry.getNodeId());
                throw new RuntimeException("Update node failed for node " + dbNodeEntry.getNodeId() + ", unable to determine primary interface collector.");
            }
            IfSnmpCollector snmpc = primaryIfc.getSnmpCollector();
            if (snmpc != null && snmpc.hasSystemGroup()) {
                String sysContact;
                String sysLocation;
                String sysDescr;
                SystemGroup sysgrp = snmpc.getSystemGroup();
                currNodeEntry.setSystemOID(sysgrp.getSysObjectID());
                String sysName = sysgrp.getSysName();
                if (sysName != null && sysName.length() > 0) {
                    currNodeEntry.setSystemName(sysName);
                }
                if ((sysDescr = sysgrp.getSysDescr()) != null && sysDescr.length() > 0) {
                    currNodeEntry.setSystemDescription(sysDescr);
                }
                if ((sysLocation = sysgrp.getSysLocation()) != null && sysLocation.length() > 0) {
                    currNodeEntry.setSystemLocation(sysLocation);
                }
                if ((sysContact = sysgrp.getSysContact()) != null && sysContact.length() > 0) {
                    currNodeEntry.setSystemContact(sysContact);
                }
            }
        }
        currNodeEntry.updateParentId(dbNodeEntry.getParentId());
        LOG.debug("updateNode: -------dumping old node-------: {}", (Object)dbNodeEntry);
        LOG.debug("updateNode: -------dumping new node-------: {}", (Object)currNodeEntry);
        dbNodeEntry.updateParentId(currNodeEntry.getParentId());
        dbNodeEntry.updateNodeType(currNodeEntry.getNodeType());
        dbNodeEntry.updateSystemOID(currNodeEntry.getSystemOID());
        dbNodeEntry.updateSystemName(currNodeEntry.getSystemName());
        dbNodeEntry.updateSystemDescription(currNodeEntry.getSystemDescription());
        dbNodeEntry.updateSystemLocation(currNodeEntry.getSystemLocation());
        dbNodeEntry.updateSystemContact(currNodeEntry.getSystemContact());
        dbNodeEntry.updateNetBIOSName(currNodeEntry.getNetBIOSName());
        dbNodeEntry.updateDomainName(currNodeEntry.getDomainName());
        dbNodeEntry.updateOS(currNodeEntry.getOS());
        dbNodeEntry.setLastPoll(now);
        if (dbNodeEntry.getLabelSource() != OnmsNode.NodeLabelSource.USER) {
            dbNodeEntry.updateLabel(currNodeEntry.getLabel());
            dbNodeEntry.updateLabelSource(currNodeEntry.getLabelSource());
        }
        boolean nodeLabelChangedFlag = dbNodeEntry.hasLabelChanged() || dbNodeEntry.hasLabelSourceChanged();
        boolean nodeInfoChangedFlag = dbNodeEntry.hasSystemOIDChanged() || dbNodeEntry.hasSystemNameChanged() || dbNodeEntry.hasSystemDescriptionChanged() || dbNodeEntry.hasSystemLocationChanged() || dbNodeEntry.hasSystemContactChanged() || dbNodeEntry.hasNetBIOSNameChanged() || dbNodeEntry.hasDomainNameChanged() || dbNodeEntry.hasOSChanged();
        dbNodeEntry.store(dbc);
        if (nodeLabelChangedFlag) {
            this.m_eventList.add(RescanProcessor.createNodeLabelChangedEvent(dbNodeEntry, originalDbNodeEntry));
        }
        if (nodeInfoChangedFlag) {
            this.m_eventList.add(RescanProcessor.createNodeInfoChangedEvent(dbNodeEntry, originalDbNodeEntry));
        }
        return dbNodeEntry;
    }

    private void updateInterfaces(Connection dbc, Date now, DbNodeEntry node, Map<String, IfCollector> collectorMap, boolean doesSnmp) throws SQLException {
        LOG.debug("updateInterfaces: Rebuilding PackageIpListMap");
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        pollerCfgFactory.rebuildPackageIpListMap();
        ArrayList<InetAddress> updatedIfList = new ArrayList<InetAddress>();
        IfSnmpCollector snmpCollector = null;
        if (doesSnmp) {
            this.m_ifIndexOnNodeChangedFlag = false;
            this.m_snmpIfTableChangedFlag = false;
            IfCollector collectorWithSnmp = null;
            for (IfCollector tmp : collectorMap.values()) {
                if (tmp.getSnmpCollector() == null) continue;
                collectorWithSnmp = tmp;
                break;
            }
            if (collectorWithSnmp != null) {
                snmpCollector = collectorWithSnmp.getSnmpCollector();
                this.updateInterface(dbc, now, node, collectorWithSnmp.getTarget(), collectorWithSnmp.getTarget(), collectorWithSnmp.getSupportedProtocols(), snmpCollector, doesSnmp);
                updatedIfList.add(collectorWithSnmp.getTarget());
                if (collectorWithSnmp.hasAdditionalTargets()) {
                    Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = collectorWithSnmp.getAdditionalTargets();
                    for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> entry : subTargets.entrySet()) {
                        this.updateInterface(dbc, now, node, collectorWithSnmp.getTarget(), entry.getKey(), entry.getValue(), snmpCollector, doesSnmp);
                        updatedIfList.add(entry.getKey());
                    }
                }
                if (collectorWithSnmp.hasNonIpInterfaces()) {
                    for (Integer ifIndex : collectorWithSnmp.getNonIpInterfaces()) {
                        this.updateNonIpInterface(dbc, now, node, ifIndex, snmpCollector);
                    }
                }
            }
        }
        for (IfCollector ifc : collectorMap.values()) {
            InetAddress ifaddr = ifc.getTarget();
            if (!updatedIfList.contains(ifaddr)) {
                this.updateInterface(dbc, now, node, ifc.getTarget(), ifaddr, ifc.getSupportedProtocols(), snmpCollector, doesSnmp);
                updatedIfList.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> entry : subTargets.entrySet()) {
                InetAddress subIf = entry.getKey();
                if (updatedIfList.contains(subIf)) continue;
                this.updateInterface(dbc, now, node, ifc.getTarget(), subIf, entry.getValue(), snmpCollector, doesSnmp);
                updatedIfList.add(subIf);
            }
        }
    }

    private void updateNonIpInterface(Connection dbc, Date now, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc) throws SQLException {
        LOG.debug("updateNonIpInterface: node= {} ifIndex= {}", (Object)node.getNodeId(), (Object)ifIndex);
        if (snmpc == null || snmpc.failed()) {
            return;
        }
        InetAddress ifAddr = ZERO_ZERO_ZERO_ZERO;
        if (ifAddr == null) {
            return;
        }
        this.updateSnmpInfoForNonIpInterface(dbc, node, ifIndex, snmpc, ifAddr);
    }

    private void updateSnmpInfoForNonIpInterface(Connection dbc, DbNodeEntry node, int ifIndex, IfSnmpCollector snmpc, InetAddress ifAddr) throws SQLException {
        LOG.debug("updateNonIpInterface: updating non-IP SNMP interface with nodeId={} and ifIndex={}", (Object)node.getNodeId(), (Object)ifIndex);
        boolean newSnmpIfTableEntry = false;
        DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
        if (dbSnmpIfEntry == null) {
            LOG.debug("updateNonIpInterface: non-IP SNMP interface with ifIndex {} not in database, creating new snmpInterface object.", (Object)ifIndex);
            dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            newSnmpIfTableEntry = true;
        }
        IfTableEntry ifte = RescanProcessor.findEntryByIfIndex(ifIndex, snmpc);
        IfXTableEntry ifxte = RescanProcessor.findXEntryByIfIndex(ifIndex, snmpc);
        if (ifte != null) {
            RescanProcessor.updateType(ifte, dbSnmpIfEntry);
            RescanProcessor.updateDescription(ifIndex, ifte, dbSnmpIfEntry);
            RescanProcessor.updatePhysicalAddress(ifIndex, ifte, dbSnmpIfEntry);
            RescanProcessor.updateSpeed(ifIndex, ifte, ifxte, dbSnmpIfEntry);
            RescanProcessor.updateAdminStatus(ifte, dbSnmpIfEntry);
            RescanProcessor.updateOperationalStatus(ifte, dbSnmpIfEntry);
            RescanProcessor.updateName(ifIndex, snmpc, dbSnmpIfEntry);
            RescanProcessor.updateAlias(ifIndex, snmpc, dbSnmpIfEntry);
        }
        if (!this.m_snmpIfTableChangedFlag && newSnmpIfTableEntry || dbSnmpIfEntry.hasTypeChanged() || dbSnmpIfEntry.hasNameChanged() || dbSnmpIfEntry.hasDescriptionChanged() || dbSnmpIfEntry.hasPhysicalAddressChanged() || dbSnmpIfEntry.hasAliasChanged()) {
            this.m_snmpIfTableChangedFlag = true;
        }
        dbSnmpIfEntry.store(dbc);
    }

    private static IfTableEntry findEntryByIfIndex(int ifIndex, IfSnmpCollector snmpc) {
        if (snmpc.hasIfTable()) {
            return snmpc.getIfTable().getEntry(ifIndex);
        }
        return null;
    }

    private static IfXTableEntry findXEntryByIfIndex(int ifIndex, IfSnmpCollector snmpc) {
        if (snmpc.hasIfXTable()) {
            return snmpc.getIfXTable().getEntry(ifIndex);
        }
        return null;
    }

    private static void updateAlias(int ifIndex, IfSnmpCollector snmpc, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String ifAlias = snmpc.getIfAlias(ifIndex);
        dbSnmpIfEntry.updateAlias(ifAlias == null ? "" : ifAlias);
    }

    private static void updateName(int ifIndex, IfSnmpCollector snmpc, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String ifName = snmpc.getIfName(ifIndex);
        if (ifName != null && ifName.length() > 0) {
            dbSnmpIfEntry.updateName(ifName);
        }
    }

    private static void updateOperationalStatus(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfOperStatus();
        dbSnmpIfEntry.updateOperationalStatus(sint == null ? 0 : sint);
    }

    private static void updateAdminStatus(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfAdminStatus();
        dbSnmpIfEntry.updateAdminStatus(sint == null ? 0 : sint);
    }

    private static void updateType(IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        Integer sint = ifte.getIfType();
        dbSnmpIfEntry.updateType(sint == null ? 0 : sint);
    }

    private static void updateDescription(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String str = ifte.getIfDescr();
        LOG.debug("updateNonIpInterface: ifIndex: {} has ifDescription: {}", (Object)ifIndex, (Object)str);
        if (str != null && str.length() > 0) {
            dbSnmpIfEntry.updateDescription(str);
        }
    }

    private static void updatePhysicalAddress(int ifIndex, IfTableEntry ifte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        String physAddr = ifte.getPhysAddr();
        LOG.debug("updateNonIpInterface: ifIndex: {} has physical address '{}'", (Object)ifIndex, (Object)physAddr);
        if (physAddr != null && physAddr.length() == 12) {
            dbSnmpIfEntry.updatePhysicalAddress(physAddr);
        }
    }

    static void updateSpeed(int ifIndex, IfTableEntry ifte, IfXTableEntry ifxte, DbSnmpInterfaceEntry dbSnmpIfEntry) {
        try {
            dbSnmpIfEntry.updateSpeed(RescanProcessor.getInterfaceSpeed(ifte, ifxte));
        }
        catch (Throwable t) {
            LOG.warn("updateNonIpInterface: ifSpeed '{}' for ifIndex {} is invalid, inserting 0", new Object[]{ifte.getDisplayString("ifSpeed"), ifIndex, t});
            dbSnmpIfEntry.updateSpeed(0L);
        }
    }

    private static long getInterfaceSpeed(IfTableEntry ifte, IfXTableEntry ifxte) {
        if (ifxte != null && ifxte.getIfHighSpeed() != null && ifxte.getIfHighSpeed() > 4294L) {
            return ifxte.getIfHighSpeed() * 1000000L;
        }
        if (ifte != null && ifte.getIfSpeed() != null) {
            return ifte.getIfSpeed();
        }
        return 0L;
    }

    private void updateInterface(Connection dbc, Date now, DbNodeEntry node, InetAddress target, InetAddress ifaddr, List<IfCollector.SupportedProtocol> protocols, IfSnmpCollector snmpc, boolean doesSnmp) throws SQLException {
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        LOG.debug("updateInterface: updating interface {} (targetIf={})", (Object)ifaddrString, (Object)InetAddressUtils.str((InetAddress)target));
        if (doesSnmp) {
            LOG.debug("updateInterface: the SNMP collection passed in is collected via {}", (Object)(snmpc == null ? "No SnmpCollection passed in (snmpc == null)" : InetAddressUtils.str((InetAddress)snmpc.getCollectorTargetAddress())));
        }
        boolean reparentFlag = false;
        boolean newIpIfEntry = false;
        int ifIndex = -1;
        DbIpInterfaceEntry dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifaddr);
        if (doesSnmp && snmpc != null && snmpc.hasIpAddrTable()) {
            ifIndex = snmpc.getIfIndex(ifaddr);
            LOG.debug("updateInterface: interface = {} ifIndex = {}. Checking for this address on other nodes.", (Object)ifaddrString, (Object)ifIndex);
            IpAddrTable ipAddrTable = snmpc.getIpAddrTable();
            if (ipAddrTable == null) {
                LOG.error("updateInterface: null ipAddrTable in the SNMP collection");
            } else if (s_ZERO_ZERO_ZERO_ZERO.equals(ifaddrString) || ifaddr.isLoopbackAddress()) {
                LOG.debug("updateInterface: Skipping address from snmpc ipAddrTable {}", (Object)ifaddrString);
            } else {
                LOG.debug("updateInterface: Checking address from snmpc ipAddrTable {}", (Object)ifaddrString);
                DBUtils d = new DBUtils(RescanProcessor.class);
                try {
                    PreparedStatement stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_OTHER_NODES);
                    d.watch((Object)stmt);
                    stmt.setString(1, ifaddrString);
                    stmt.setInt(2, node.getNodeId());
                    ResultSet rs = stmt.executeQuery();
                    d.watch((Object)rs);
                    while (rs.next()) {
                        DbIpInterfaceEntry[] tmpIfArray;
                        int existingNodeId = rs.getInt(1);
                        LOG.debug("updateInterface: ckecking for {} on existing nodeid {}", (Object)ifaddrString, (Object)existingNodeId);
                        DbNodeEntry suspectNodeEntry = DbNodeEntry.get(dbc, existingNodeId);
                        if (suspectNodeEntry == null || !RescanProcessor.areDbInterfacesInSnmpCollection(tmpIfArray = suspectNodeEntry.getInterfaces(dbc), snmpc)) continue;
                        for (int i = 0; i < tmpIfArray.length; ++i) {
                            InetAddress addr = tmpIfArray[i].getIfAddress();
                            int index = snmpc.getIfIndex(addr);
                            String addrString = InetAddressUtils.str((InetAddress)addr);
                            if (addrString == null || s_ZERO_ZERO_ZERO_ZERO.equals(addrString) || addr.isLoopbackAddress()) continue;
                            LOG.debug("updateInterface: reparenting interface {} under node: {} from existing node: {}", new Object[]{addrString, node.getNodeId(), existingNodeId});
                            RescanProcessor.reparentInterface(dbc, addr, index, node.getNodeId(), existingNodeId);
                            RescanProcessor.createInterfaceReparentedEvent(node, existingNodeId, addr);
                        }
                        LOG.debug("updateInterface: interface {} is added to node: {} by reparenting from existing node: {}", new Object[]{ifaddrString, node.getNodeId(), existingNodeId});
                        dbIpIfEntry = DbIpInterfaceEntry.get(dbc, node.getNodeId(), ifaddr);
                        reparentFlag = true;
                        RescanProcessor.deleteDuplicateNode(dbc, suspectNodeEntry);
                        RescanProcessor.createDuplicateNodeDeletedEvent(suspectNodeEntry);
                    }
                }
                catch (SQLException e) {
                    LOG.error("SQLException while updating interface: {} on nodeid: {}", (Object)ifaddrString, (Object)node.getNodeId());
                    throw e;
                }
                finally {
                    d.cleanUp();
                }
            }
        }
        if (dbIpIfEntry == null) {
            LOG.debug("updateInterface: interface {} ifIndex {} not in database under nodeid {}, creating new interface object.", new Object[]{ifaddr, ifIndex, node.getNodeId()});
            if (ifIndex == -1 && !doesSnmp) {
                dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr);
            } else {
                dbIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr, ifIndex);
                dbIpIfEntry.setIfIndex(ifIndex);
            }
            if (RescanProcessor.isDuplicateInterface(dbc, ifaddr, node.getNodeId())) {
                this.m_eventList.add(RescanProcessor.createDuplicateIpAddressEvent(dbIpIfEntry));
            }
            newIpIfEntry = true;
        }
        DbIpInterfaceEntry currIpIfEntry = RescanProcessor.getNewDbIpInterfaceEntry(node, snmpc, doesSnmp, ifaddr);
        if (doesSnmp && snmpc != null) {
            this.updateSnmpInfo(dbc, node, snmpc, currIpIfEntry.getIfAddress(), currIpIfEntry.getIfIndex());
        }
        this.updateInterfaceInfo(dbc, now, node, dbIpIfEntry, currIpIfEntry, newIpIfEntry, reparentFlag);
        this.updateServiceInfo(dbc, node, dbIpIfEntry, newIpIfEntry, protocols);
    }

    private static void deleteDuplicateNode(Connection dbc, DbNodeEntry duplicateNode) throws SQLException {
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            PreparedStatement ifStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_INTERFACE);
            d.watch((Object)ifStmt);
            PreparedStatement svcStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_SERVICES);
            d.watch((Object)svcStmt);
            PreparedStatement snmpStmt = dbc.prepareStatement(SQL_DB_DELETE_DUP_SNMPINTERFACE);
            d.watch((Object)snmpStmt);
            ifStmt.setInt(1, duplicateNode.getNodeId());
            svcStmt.setInt(1, duplicateNode.getNodeId());
            snmpStmt.setInt(1, duplicateNode.getNodeId());
            ifStmt.executeUpdate();
            svcStmt.executeUpdate();
            snmpStmt.executeUpdate();
            duplicateNode.setNodeType(OnmsNode.NodeType.DELETED);
            duplicateNode.store(dbc);
        }
        catch (SQLException sqlE) {
            LOG.error("deleteDuplicateNode  SQLException while deleting duplicate node: {}", (Object)duplicateNode.getNodeId());
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
    }

    private static boolean isDuplicateInterface(Connection dbc, InetAddress ifaddr, int nodeId) throws SQLException {
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            PreparedStatement stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_OTHER_NODES);
            d.watch((Object)stmt);
            stmt.setString(1, InetAddressUtils.str((InetAddress)ifaddr));
            stmt.setInt(2, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sqlE) {
            LOG.error("isDuplicateInterface: SQLException while updating interface: {} on nodeid: {}", (Object)InetAddressUtils.str((InetAddress)ifaddr), (Object)nodeId);
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInterfaceInfo(Connection dbc, Date now, DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, DbIpInterfaceEntry currIpIfEntry, boolean isNewIpEntry, boolean isReparented) throws SQLException {
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        DbIpInterfaceEntry originalIpIfEntry = DbIpInterfaceEntry.clone(dbIpIfEntry);
        dbIpIfEntry.setLastPoll(now);
        dbIpIfEntry.updateHostname(currIpIfEntry.getHostname());
        dbIpIfEntry.updateManagedState(currIpIfEntry.getManagedState());
        dbIpIfEntry.updateStatus(currIpIfEntry.getStatus());
        dbIpIfEntry.updatePrimaryState(currIpIfEntry.getPrimaryState());
        dbIpIfEntry.updateIfIndex(currIpIfEntry.getIfIndex());
        boolean ifIndexChangedFlag = dbIpIfEntry.hasIfIndexChanged();
        boolean ipHostnameChangedFlag = dbIpIfEntry.hasHostnameChanged();
        dbIpIfEntry.store(dbc);
        if (isNewIpEntry && !isReparented) {
            RescanProcessor.createNodeGainedInterfaceEvent(dbIpIfEntry);
        }
        LOG.debug("updateInterfaceInfo: ifIndex changed: {}", (Object)ifIndexChangedFlag);
        if (ifIndexChangedFlag) {
            this.m_eventList.add(RescanProcessor.createInterfaceIndexChangedEvent(dbIpIfEntry, originalIpIfEntry));
            this.m_ifIndexOnNodeChangedFlag = true;
        }
        LOG.debug("updateInterfaceInfo: hostname changed: {}", (Object)ipHostnameChangedFlag);
        if (ipHostnameChangedFlag) {
            this.m_eventList.add(RescanProcessor.createIpHostNameChangedEvent(dbIpIfEntry, originalIpIfEntry));
        }
        if (isNewIpEntry) {
            String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
            LOG.debug("updateInterfaceInfo: rebuilding PackageIpListMap for new interface {}", (Object)ifaddrString);
            PollerConfigFactory.getInstance().rebuildPackageIpListMap();
            Package ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
            boolean ipToBePolled = ipPkg != null;
            LOG.debug("updateInterfaceInfo: interface {} to be polled: {}", (Object)ifaddrString, (Object)ipToBePolled);
            if (ipToBePolled) {
                DBUtils d = new DBUtils(RescanProcessor.class);
                try {
                    PreparedStatement stmt = dbc.prepareStatement(SQL_DB_UPDATE_ISMANAGED);
                    d.watch((Object)stmt);
                    stmt.setString(1, new String(new char[]{'M'}));
                    stmt.setLong(2, dbIpIfEntry.getNodeId());
                    stmt.setString(3, ifaddrString);
                    stmt.executeUpdate();
                    LOG.debug("updateInterfaceInfo: updated managed state for new interface {} on node {} to managed", (Object)ifaddrString, (Object)dbIpIfEntry.getNodeId());
                }
                finally {
                    d.cleanUp();
                }
            }
        }
    }

    private static DbIpInterfaceEntry getNewDbIpInterfaceEntry(DbNodeEntry node, IfSnmpCollector snmpc, boolean doesSnmp, InetAddress ifaddr) {
        DbIpInterfaceEntry currIpIfEntry;
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        int ifIndex = -1;
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (doesSnmp) {
            if (snmpc != null && snmpc.hasIpAddrTable()) {
                ifIndex = snmpc.getIfIndex(ifaddr);
            }
            if (ifIndex == -1) {
                LOG.debug("updateInterfaceInfo: interface {} has no valid ifIndex. Assuming this is a lame SNMP host with no ipAddrTable", (Object)ifaddrString);
                ifIndex = -100;
            }
            currIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr, ifIndex);
        } else {
            currIpIfEntry = DbIpInterfaceEntry.create(node.getNodeId(), ifaddr);
        }
        currIpIfEntry.setHostname(ifaddr.getHostName());
        Package ipPkg = null;
        if (cFactory.isAddressUnmanaged(ifaddr)) {
            currIpIfEntry.setManagedState('U');
        } else {
            boolean ipToBePolled;
            ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
            boolean bl = ipToBePolled = ipPkg != null;
            if (ipToBePolled) {
                currIpIfEntry.setManagedState('M');
            } else {
                currIpIfEntry.setManagedState('N');
            }
            LOG.debug("updateInterfaceInfo: interface {} to be polled = {}", (Object)ifaddrString, (Object)ipToBePolled);
        }
        if (doesSnmp && snmpc != null && snmpc.hasIpAddrTable()) {
            if (ifIndex != -1) {
                if (snmpc.hasIfTable()) {
                    currIpIfEntry.setStatus(snmpc.getAdminStatus(ifIndex));
                }
            } else {
                LOG.debug("updateInterfaceInfo:  No ifIndex found for {}. Not eligible for primary SNMP interface.", (Object)ifaddrString);
            }
            currIpIfEntry.setPrimaryState('N');
        } else if (doesSnmp) {
            currIpIfEntry.setPrimaryState('N');
        }
        return currIpIfEntry;
    }

    private void updateServiceInfo(Connection dbc, DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, boolean isNewIpEntry, List<IfCollector.SupportedProtocol> protocols) throws SQLException {
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        Package ipPkg = null;
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        DbIfServiceEntry[] dbSupportedServices = dbIpIfEntry.getServices(dbc);
        int ifIndex = dbIpIfEntry.getIfIndex();
        if (LOG.isDebugEnabled()) {
            if (ifIndex == -1) {
                LOG.debug("updateServiceInfo: Retrieving interface's service list from database for host {}", (Object)dbIpIfEntry.getHostname());
            } else {
                LOG.debug("updateServiceInfo: Retrieving interface's service list from database for host {} ifindex {}", (Object)dbIpIfEntry.getHostname(), (Object)ifIndex);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateServiceInfo: Checking for new services on host {}", (Object)dbIpIfEntry.getHostname());
        }
        for (IfCollector.SupportedProtocol p : protocols) {
            Integer sid = this.m_capsdDbSyncer.getServiceId(p.getProtocolName());
            boolean found = false;
            for (int i = 0; i < dbSupportedServices.length && !found; ++i) {
                if (dbSupportedServices[i].getServiceId() != ((Number)sid).intValue()) continue;
                found = true;
                break;
            }
            if (!found) {
                DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.create(node.getNodeId(), ifaddr, sid);
                String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
                if (cFactory.isAddressUnmanaged(ifaddr)) {
                    ifSvcEntry.setStatus('U');
                } else {
                    Package package_ = ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
                    if (ipPkg == null) {
                        ifSvcEntry.setStatus('N');
                    } else if (RescanProcessor.isServicePolledLocally(ifaddrString, p.getProtocolName(), ipPkg)) {
                        ifSvcEntry.setStatus('A');
                    } else if (RescanProcessor.isServicePolled(ifaddrString, p.getProtocolName(), ipPkg)) {
                        ifSvcEntry.setStatus('X');
                    } else {
                        ifSvcEntry.setStatus('N');
                    }
                }
                if (p.getQualifiers() != null && p.getQualifiers().get("port") != null) {
                    try {
                        Integer port = (Integer)p.getQualifiers().get("port");
                        LOG.debug("updateServiceInfo: got a port qualifier: {} for service: {}", (Object)port, (Object)p.getProtocolName());
                        ifSvcEntry.setQualifier(port.toString());
                    }
                    catch (ClassCastException ccE) {
                        // empty catch block
                    }
                }
                ifSvcEntry.setSource('P');
                ifSvcEntry.setNotify('Y');
                if (ifIndex != -1) {
                    ifSvcEntry.setIfIndex(ifIndex);
                }
                ifSvcEntry.store();
                LOG.debug("updateIfServices: update service: {} for interface:{} on node:{}", new Object[]{p.getProtocolName(), ifaddrString, node.getNodeId()});
                this.m_eventList.add(RescanProcessor.createNodeGainedServiceEvent(node, dbIpIfEntry, p.getProtocolName()));
                if (!isNewIpEntry && p.getProtocolName().equalsIgnoreCase("SNMP")) {
                    this.m_eventList.add(RescanProcessor.createInterfaceSupportsSNMPEvent(dbIpIfEntry));
                }
            }
            dbSupportedServices = dbIpIfEntry.getServices(dbc);
        }
        if (this.m_forceRescan) {
            this.updateServicesOnForcedRescan(node, dbIpIfEntry, dbSupportedServices);
        }
    }

    private static boolean isServicePolled(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null) {
            if (PollerConfigFactory.getInstance().isPolled(svcName, ipPkg)) {
                return true;
            }
            if (PollerConfigFactory.getInstance().isPolled(ifAddr, svcName)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isServicePolledLocally(String ifAddr, String svcName, Package ipPkg) {
        if (ipPkg != null && !ipPkg.getRemote().booleanValue()) {
            if (PollerConfigFactory.getInstance().isPolled(svcName, ipPkg)) {
                return true;
            }
            if (PollerConfigFactory.getInstance().isPolledLocally(ifAddr, svcName)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServicesOnForcedRescan(DbNodeEntry node, DbIpInterfaceEntry dbIpIfEntry, DbIfServiceEntry[] dbSupportedServices) throws SQLException {
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        CapsdConfig cFactory = CapsdConfigFactory.getInstance();
        InetAddress ifaddr = dbIpIfEntry.getIfAddress();
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        Package ipPkg = ifaddrString == null ? null : pollerCfgFactory.getFirstPackageMatch(ifaddrString);
        boolean ipToBePolled = ipPkg != null;
        LOG.debug("updateServicesOnForcedRescan: Checking status of existing services on host {}", (Object)ifaddr);
        HashMap<Integer, String> serviceNames = new HashMap<Integer, String>();
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            Connection ctest = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)ctest);
            PreparedStatement loadStmt = ctest.prepareStatement(SQL_RETRIEVE_SERVICE_IDS);
            d.watch((Object)loadStmt);
            ResultSet rs = loadStmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String name = rs.getString(2);
                serviceNames.put(id, name);
            }
        }
        catch (Throwable t) {
            LOG.error("Error reading services table", t);
        }
        finally {
            d.cleanUp();
        }
        for (int i = 0; i < dbSupportedServices.length; ++i) {
            Integer id = dbSupportedServices[i].getServiceId();
            String sn = ((String)serviceNames.get(id)).toString();
            DbIfServiceEntry ifSvcEntry = DbIfServiceEntry.get(node.getNodeId(), ifaddr, dbSupportedServices[i].getServiceId());
            LOG.debug("updateServicesOnForcedRescan: old status for nodeId {}, ifaddr {}, serviceId {} = {}", new Object[]{node.getNodeId(), ifaddr, dbSupportedServices[i].getServiceId(), Character.valueOf(ifSvcEntry.getStatus())});
            boolean svcChangeToActive = false;
            boolean svcChangeToNotPolled = false;
            boolean svcChangeToForced = false;
            if (!cFactory.isAddressUnmanaged(ifaddr)) {
                boolean svcToBePolled = false;
                if (ipToBePolled) {
                    if (ipPkg == null) {
                        ipPkg = pollerCfgFactory.getFirstPackageMatch(ifaddrString);
                    }
                    if (ipPkg != null) {
                        LOG.debug("updateServicesOnForcedRescan: Is service to be polled for package = {}, service = {}", (Object)ipPkg.getName(), (Object)sn);
                        svcToBePolled = pollerCfgFactory.isPolled(sn, ipPkg);
                        if (!svcToBePolled) {
                            LOG.debug("updateServicesOnForcedRescan: Is service to be polled for ifaddr = {}, service = {}", (Object)ifaddrString, (Object)sn);
                            svcToBePolled = pollerCfgFactory.isPolled(ifaddrString, sn);
                        }
                        if (!svcToBePolled) {
                            LOG.debug("updateServicesOnForcedRescan: Service not to be polled");
                        }
                    } else {
                        LOG.debug("updateServicesOnForcedRescan: No poller package found");
                    }
                } else {
                    LOG.debug("updateServicesOnForcedRescan: Service not polled because interface is not polled");
                }
                if (ifSvcEntry.getStatus() == 'F') {
                    if (svcToBePolled) {
                        LOG.debug("updateServicesOnForcedRescan: status = FORCED. No action taken.");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        LOG.debug("updateServicesOnForcedRescan: status = FORCED. Changed to NOT_POLLED");
                    }
                } else if (ifSvcEntry.getStatus() == 'S') {
                    if (svcToBePolled) {
                        ifSvcEntry.updateStatus('F');
                        svcChangeToForced = true;
                        LOG.debug("updateServicesOnForcedRescan: status = SUSPEND. Changed to FORCED");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        LOG.debug("updateServicesOnForcedRescan: status = SUSPEND. Changed to NOT_POLLED");
                    }
                } else if (ifSvcEntry.getStatus() == 'R') {
                    if (svcToBePolled) {
                        ifSvcEntry.updateStatus('A');
                        svcChangeToActive = true;
                        LOG.debug("updateServicesOnForcedRescan: status = RESUME. Changed to ACTIVE");
                    } else {
                        ifSvcEntry.updateStatus('N');
                        svcChangeToNotPolled = true;
                        LOG.debug("updateServicesOnForcedRescan: status = RESUME. Changed to NOT_POLLED");
                    }
                } else if (svcToBePolled && ifSvcEntry.getStatus() != 'A') {
                    ifSvcEntry.updateStatus('A');
                    svcChangeToActive = true;
                    LOG.debug("updateServicesOnForcedRescan: New status = ACTIVE");
                } else if (!svcToBePolled && ifSvcEntry.getStatus() == 'A') {
                    ifSvcEntry.updateStatus('N');
                    svcChangeToNotPolled = true;
                    LOG.debug("updateServicesOnForcedRescan: New status = NOT_POLLED");
                } else {
                    LOG.debug("updateServicesOnForcedRescan: Status Unchanged");
                }
            }
            if (svcChangeToActive) {
                ifSvcEntry.store();
                this.m_eventList.add(RescanProcessor.createResumePollingServiceEvent(node, dbIpIfEntry, sn));
                continue;
            }
            if (!svcChangeToNotPolled && !svcChangeToForced) continue;
            ifSvcEntry.store();
            this.m_eventList.add(RescanProcessor.createSuspendPollingServiceEvent(node, dbIpIfEntry, sn));
        }
    }

    private void updateSnmpInfo(Connection dbc, DbNodeEntry node, IfSnmpCollector snmpc, InetAddress ifaddr, int ifIndex) throws SQLException {
        if (snmpc != null && !snmpc.failed() && ifIndex != -1) {
            LOG.debug("updateSnmpInfo: updating SNMP interface for nodeId/ifIndex={}/{}", (Object)node.getNodeId(), (Object)ifIndex);
            boolean newSnmpIfTableEntry = false;
            DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
            if (dbSnmpIfEntry == null) {
                LOG.debug("updateSnmpInfo: SNMP interface index {} not in database, creating new interface object.", (Object)ifIndex);
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
                newSnmpIfTableEntry = true;
            }
            DbSnmpInterfaceEntry currSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            IfTable ift = snmpc.getIfTable();
            IfTableEntry ifte = null;
            for (IfTableEntry current : ift) {
                Integer sint = current.getIfIndex();
                if (sint == null || ifIndex != sint) continue;
                ifte = current;
                break;
            }
            if (ifte == null && ifIndex == -100) {
                LOG.debug("updateSnmpInfo: interface {} appears to be a lame SNMP host", (Object)InetAddressUtils.str((InetAddress)snmpc.getCollectorTargetAddress()));
            } else if (ifte != null) {
                String ifAlias;
                Long speed;
                InetAddress[] aaddrs = snmpc.getIfAddressAndMask(ifIndex);
                if (aaddrs == null) {
                    currSnmpIfEntry.setCollect("N");
                } else {
                    currSnmpIfEntry.setCollect("C");
                    if (aaddrs[1] != null) {
                        LOG.debug("updateSnmpInfo: interface {} has netmask: {}", (Object)InetAddressUtils.str((InetAddress)aaddrs[0]), (Object)InetAddressUtils.str((InetAddress)aaddrs[1]));
                        currSnmpIfEntry.setNetmask(aaddrs[1]);
                    }
                }
                Integer sint = ifte.getIfType();
                currSnmpIfEntry.setType(sint);
                String str = ifte.getIfDescr();
                LOG.debug("updateSnmpInfo: {} has ifDescription: {}", (Object)ifaddr, (Object)str);
                if (str != null && str.length() > 0) {
                    currSnmpIfEntry.setDescription(str);
                }
                String physAddr = ifte.getPhysAddr();
                LOG.debug("updateSnmpInfo: {} has phys address: -{}-", (Object)ifaddr, (Object)physAddr);
                if (physAddr != null && physAddr.length() == 12) {
                    currSnmpIfEntry.setPhysicalAddress(physAddr);
                }
                currSnmpIfEntry.setSpeed((speed = snmpc.getInterfaceSpeed(ifIndex)) == null ? 10000000L : speed);
                sint = ifte.getIfAdminStatus();
                currSnmpIfEntry.setAdminStatus(sint == null ? 0 : sint);
                sint = ifte.getIfOperStatus();
                currSnmpIfEntry.setOperationalStatus(sint == null ? 0 : sint);
                String ifName = snmpc.getIfName(ifIndex);
                if (ifName != null && ifName.length() > 0) {
                    currSnmpIfEntry.setName(ifName);
                }
                if ((ifAlias = snmpc.getIfAlias(ifIndex)) != null) {
                    currSnmpIfEntry.setAlias(ifAlias);
                } else {
                    currSnmpIfEntry.setAlias("");
                }
            }
            dbSnmpIfEntry.updateNetmask(currSnmpIfEntry.getNetmask());
            dbSnmpIfEntry.updatePhysicalAddress(currSnmpIfEntry.getPhysicalAddress());
            dbSnmpIfEntry.updateDescription(currSnmpIfEntry.getDescription());
            dbSnmpIfEntry.updateName(currSnmpIfEntry.getName());
            dbSnmpIfEntry.updateType(currSnmpIfEntry.getType());
            dbSnmpIfEntry.updateSpeed(currSnmpIfEntry.getSpeed());
            dbSnmpIfEntry.updateAdminStatus(currSnmpIfEntry.getAdminStatus());
            dbSnmpIfEntry.updateOperationalStatus(currSnmpIfEntry.getOperationalStatus());
            dbSnmpIfEntry.updateAlias(currSnmpIfEntry.getAlias());
            dbSnmpIfEntry.updateCollect(currSnmpIfEntry.getCollect());
            if (!this.m_snmpIfTableChangedFlag && newSnmpIfTableEntry || dbSnmpIfEntry.hasTypeChanged() || dbSnmpIfEntry.hasNameChanged() || dbSnmpIfEntry.hasDescriptionChanged() || dbSnmpIfEntry.hasPhysicalAddressChanged() || dbSnmpIfEntry.hasAliasChanged()) {
                this.m_snmpIfTableChangedFlag = true;
            }
            dbSnmpIfEntry.store(dbc);
        } else if (snmpc != null && snmpc.hasIpAddrTable() && ifIndex != -1) {
            LOG.debug("updateSnmpInfo: updating SNMP interface for nodeId={}/ifIndex={}/ipAddr={} based on ipAddrTable only - No ifTable available", new Object[]{node.getNodeId(), ifIndex, ifaddr});
            DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), ifIndex);
            if (dbSnmpIfEntry == null) {
                LOG.debug("updateSnmpInfo: SNMP interface index {} not in database, creating new interface object.", (Object)ifIndex);
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            }
            DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            dbSnmpIfEntry.store(dbc);
        } else if (snmpc != null) {
            LOG.debug("updateSnmpInfo: updating SNMP interface for nodeId={}/ipAddr={} based on ip address only - No ipAddrTable available", (Object)node.getNodeId(), (Object)ifaddr);
            DbSnmpInterfaceEntry dbSnmpIfEntry = DbSnmpInterfaceEntry.get(dbc, node.getNodeId(), -100);
            if (dbSnmpIfEntry == null) {
                LOG.debug("updateSnmpInfo: SNMP interface index {} not in database, creating new interface object.", (Object)-100);
                dbSnmpIfEntry = DbSnmpInterfaceEntry.create(node.getNodeId(), -100);
            }
            DbSnmpInterfaceEntry.create(node.getNodeId(), ifIndex);
            dbSnmpIfEntry.store(dbc);
        }
    }

    private static void reparentInterface(Connection dbc, InetAddress ifAddr, int ifIndex, int newNodeId, int oldNodeId) throws SQLException {
        String ipaddr = InetAddressUtils.str((InetAddress)ifAddr);
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            ResultSet rs;
            PreparedStatement ifLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE_LOOKUP);
            d.watch((Object)ifLookupStmt);
            PreparedStatement ifDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE_DELETE);
            d.watch((Object)ifDeleteStmt);
            PreparedStatement ipInterfaceStmt = dbc.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE);
            d.watch((Object)ipInterfaceStmt);
            PreparedStatement snmpIfLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_IF_LOOKUP);
            d.watch((Object)snmpIfLookupStmt);
            PreparedStatement snmpIfDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_IF_DELETE);
            d.watch((Object)snmpIfDeleteStmt);
            PreparedStatement snmpInterfaceStmt = dbc.prepareStatement(SQL_DB_REPARENT_SNMP_INTERFACE);
            d.watch((Object)snmpInterfaceStmt);
            PreparedStatement ifServicesLookupStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES_LOOKUP);
            d.watch((Object)ifServicesLookupStmt);
            PreparedStatement ifServicesDeleteStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES_DELETE);
            d.watch((Object)ifServicesDeleteStmt);
            PreparedStatement ifServicesStmt = dbc.prepareStatement(SQL_DB_REPARENT_IF_SERVICES);
            d.watch((Object)ifServicesStmt);
            LOG.debug("reparentInterface: reparenting address/ifIndex/nodeID: {}/{}/{}", new Object[]{ipaddr, ifIndex, newNodeId});
            if (ifIndex < 1) {
                LOG.debug("reparentInterface: don't have a valid ifIndex, skipping snmpInterface table reparenting.");
            } else {
                snmpIfLookupStmt.setInt(1, newNodeId);
                snmpIfLookupStmt.setInt(2, ifIndex);
                rs = snmpIfLookupStmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    LOG.debug("reparentInterface: interface with ifindex {} already exists under new node {} in snmpinterface table, deleting from under old node {}", new Object[]{ifIndex, newNodeId, oldNodeId});
                    snmpIfDeleteStmt.setInt(1, oldNodeId);
                    snmpIfDeleteStmt.setInt(2, ifIndex);
                    snmpIfDeleteStmt.executeUpdate();
                } else {
                    LOG.debug("reparentInterface: interface with ifindex {} does not yet exist under new node {} in snmpinterface table, reparenting.", (Object)ifIndex, (Object)newNodeId);
                    snmpInterfaceStmt.setInt(1, newNodeId);
                    snmpInterfaceStmt.setInt(2, oldNodeId);
                    snmpInterfaceStmt.setInt(3, ifIndex);
                    snmpInterfaceStmt.executeUpdate();
                }
            }
            ifLookupStmt.setInt(1, newNodeId);
            ifLookupStmt.setString(2, ipaddr);
            rs = ifLookupStmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                LOG.debug("reparentInterface: interface with ifindex {} already exists under new node {} in ipinterface table, deleting from under old node {}", new Object[]{ifIndex, newNodeId, oldNodeId});
                ifDeleteStmt.setInt(1, oldNodeId);
                ifDeleteStmt.setString(2, ipaddr);
                ifDeleteStmt.executeUpdate();
            } else {
                LOG.debug("reparentInterface: interface with ifindex {} does not yet exist under new node {} in ipinterface table, reparenting.", (Object)ifIndex, (Object)newNodeId);
                ipInterfaceStmt.setInt(1, newNodeId);
                ipInterfaceStmt.setInt(2, oldNodeId);
                ipInterfaceStmt.setString(3, ipaddr);
                ipInterfaceStmt.executeUpdate();
            }
            ifServicesLookupStmt.setInt(1, newNodeId);
            ifServicesLookupStmt.setString(2, ipaddr);
            ifServicesLookupStmt.setInt(3, ifIndex);
            ResultSet rsServicesLookup = ifServicesLookupStmt.executeQuery();
            d.watch((Object)rsServicesLookup);
            if (rsServicesLookup.next()) {
                LOG.debug("reparentInterface: interface with ifindex {} already exists under new node {} in ifservices table, deleting from under old node {}", new Object[]{ifIndex, newNodeId, oldNodeId});
                ifServicesDeleteStmt.setInt(1, oldNodeId);
                ifServicesDeleteStmt.setString(2, ipaddr);
                ifServicesDeleteStmt.executeUpdate();
            } else {
                LOG.debug("reparentInterface: interface with ifindex {} does not yet exist under new node {} in ifservices table, reparenting.", (Object)ifIndex, (Object)newNodeId);
                ifServicesStmt.setInt(1, newNodeId);
                ifServicesStmt.setInt(2, oldNodeId);
                ifServicesStmt.setString(3, ipaddr);
                ifServicesStmt.executeUpdate();
            }
            LOG.debug("reparentInterface: reparented {} : ifIndex: {} : oldNodeID: {} newNodeID: {}", new Object[]{ipaddr, ifIndex, oldNodeId, newNodeId});
        }
        catch (SQLException sqlE) {
            LOG.error("SQLException while reparenting addr/ifindex/nodeid {}/{}/{}", new Object[]{ipaddr, ifIndex, oldNodeId});
            throw sqlE;
        }
        finally {
            d.cleanUp();
        }
    }

    private static List<InetAddress> buildLBSnmpAddressList(Map<String, IfCollector> collectorMap, IfSnmpCollector snmpc) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (snmpc == null) {
            LOG.debug("buildLBSnmpAddressList: no SNMP info available...");
            return addresses;
        }
        if (!snmpc.hasIfTable()) {
            LOG.debug("buildLBSnmpAddressList: no SNMP ifTable available...");
            return addresses;
        }
        for (IfCollector ifc : collectorMap.values()) {
            InetAddress ifaddr = ifc.getTarget();
            if (!addresses.contains(ifaddr) && SuspectEventProcessor.supportsSnmp(ifc.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ifaddr, snmpc) && SuspectEventProcessor.getIfType(ifaddr, snmpc) == 24) {
                LOG.debug("buildLBSnmpAddressList: adding target interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)ifaddr));
                addresses.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> entry : subTargets.entrySet()) {
                InetAddress xifaddr = entry.getKey();
                List<IfCollector.SupportedProtocol> protocols = entry.getValue();
                if (addresses.contains(xifaddr) || !SuspectEventProcessor.supportsSnmp(protocols) || !SuspectEventProcessor.hasIfIndex(xifaddr, snmpc) || SuspectEventProcessor.getIfType(xifaddr, snmpc) != 24) continue;
                LOG.debug("buildLBSnmpAddressList: adding subtarget interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)xifaddr));
                addresses.add(xifaddr);
            }
        }
        return addresses;
    }

    private static List<InetAddress> buildSnmpAddressList(Map<String, IfCollector> collectorMap, IfSnmpCollector snmpc) {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        if (snmpc == null) {
            LOG.debug("buildSnmpAddressList: no SNMP info available...");
            return addresses;
        }
        for (IfCollector ifc : collectorMap.values()) {
            InetAddress ifaddr = ifc.getTarget();
            if (!addresses.contains(ifaddr) && SuspectEventProcessor.supportsSnmp(ifc.getSupportedProtocols()) && SuspectEventProcessor.hasIfIndex(ifaddr, snmpc)) {
                LOG.debug("buildSnmpAddressList: adding target interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)ifaddr));
                addresses.add(ifaddr);
            }
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            for (Map.Entry<InetAddress, List<IfCollector.SupportedProtocol>> entry : subTargets.entrySet()) {
                InetAddress xifaddr = entry.getKey();
                List<IfCollector.SupportedProtocol> protocols = entry.getValue();
                if (addresses.contains(xifaddr) || !SuspectEventProcessor.supportsSnmp(protocols) || !SuspectEventProcessor.hasIfIndex(xifaddr, snmpc)) continue;
                LOG.debug("buildSnmpAddressList: adding subtarget interface {} temporarily marked as primary!", (Object)InetAddressUtils.str((InetAddress)xifaddr));
                addresses.add(xifaddr);
            }
        }
        return addresses;
    }

    private static InetAddress determinePrimaryIpInterface(Map<String, IfCollector> collectorMap) {
        InetAddress primaryIf = null;
        for (IfCollector ifc : collectorMap.values()) {
            InetAddress currIf = ifc.getTarget();
            if (primaryIf == null) {
                primaryIf = currIf;
                continue;
            }
            primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf, primaryIf);
            if (!ifc.hasAdditionalTargets()) continue;
            Map<InetAddress, List<IfCollector.SupportedProtocol>> subTargets = ifc.getAdditionalTargets();
            Iterator<InetAddress> i$ = subTargets.keySet().iterator();
            while (i$.hasNext()) {
                InetAddress subIf;
                currIf = subIf = i$.next();
                primaryIf = SuspectEventProcessor.compareAndSelectPrimary(currIf, primaryIf);
            }
        }
        if (LOG.isDebugEnabled()) {
            if (primaryIf != null) {
                LOG.debug("determinePrimaryIpInterface: selected primary interface: {}", (Object)InetAddressUtils.str(primaryIf));
            } else {
                LOG.debug("determinePrimaryIpInterface: no primary interface found");
            }
        }
        return primaryIf;
    }

    private static void setNodeLabelAndSmbInfo(Map<String, IfCollector> collectorMap, DbNodeEntry dbNodeEntry, DbNodeEntry currNodeEntry, InetAddress currPrimarySnmpIf) {
        boolean labelSet = false;
        InetAddress primaryIf = null;
        if (!labelSet) {
            primaryIf = currPrimarySnmpIf != null ? currPrimarySnmpIf : RescanProcessor.determinePrimaryIpInterface(collectorMap);
            if (primaryIf == null) {
                LOG.error("setNodeLabelAndSmbInfo: failed to find primary interface...");
            } else {
                String hostName = primaryIf.getHostName();
                if (!hostName.equals(InetAddressUtils.str((InetAddress)primaryIf))) {
                    labelSet = true;
                    currNodeEntry.setLabel(hostName);
                    currNodeEntry.setLabelSource(OnmsNode.NodeLabelSource.HOSTNAME);
                }
            }
        }
        IfSmbCollector savedSmbcRef = null;
        if (dbNodeEntry.getNetBIOSName() != null) {
            Collection<IfCollector> values = collectorMap.values();
            Iterator<IfCollector> iter = values.iterator();
            while (iter.hasNext() && !labelSet) {
                IfCollector ifc = iter.next();
                IfSmbCollector smbc = ifc.getSmbCollector();
                if (smbc == null || smbc.getNbtName() == null) continue;
                savedSmbcRef = smbc;
                String netbiosName = smbc.getNbtName().toUpperCase();
                if (!netbiosName.equals(dbNodeEntry.getNetBIOSName())) continue;
                labelSet = true;
                currNodeEntry.setLabel(netbiosName);
                currNodeEntry.setLabelSource(OnmsNode.NodeLabelSource.NETBIOS);
                currNodeEntry.setNetBIOSName(netbiosName);
                if (smbc.getDomainName() == null) continue;
                currNodeEntry.setDomainName(smbc.getDomainName());
            }
        } else {
            for (IfCollector ifc2 : collectorMap.values()) {
                IfSmbCollector smbc = ifc2.getSmbCollector();
                if (smbc == null || smbc.getNbtName() == null) continue;
                savedSmbcRef = smbc;
            }
        }
        if (!labelSet && savedSmbcRef != null) {
            labelSet = true;
            currNodeEntry.setLabel(savedSmbcRef.getNbtName());
            currNodeEntry.setLabelSource(OnmsNode.NodeLabelSource.NETBIOS);
            currNodeEntry.setNetBIOSName(currNodeEntry.getLabel());
            if (savedSmbcRef.getDomainName() != null) {
                currNodeEntry.setDomainName(savedSmbcRef.getDomainName());
            }
        }
        if (!labelSet && currPrimarySnmpIf != null) {
            IfCollector ifc2;
            String currPrimarySnmpAddress = InetAddressUtils.str((InetAddress)currPrimarySnmpIf);
            IfCollector ifCollector = ifc2 = currPrimarySnmpAddress == null ? null : collectorMap.get(currPrimarySnmpAddress);
            if (ifc2 == null) {
                Collection<IfCollector> collectors = collectorMap.values();
                for (IfCollector ifc2 : collectors) {
                    if (ifc2.getSnmpCollector() != null) break;
                }
            }
            if (ifc2 == null || ifc2.getSnmpCollector() == null) {
                LOG.warn("setNodeLabelAndSmbInfo: primary SNMP interface set to {} but no SNMP collector found.", (Object)currPrimarySnmpAddress);
            } else {
                IfSnmpCollector snmpc = ifc2.getSnmpCollector();
                SystemGroup sysgrp = snmpc.getSystemGroup();
                String str = sysgrp.getSysName();
                if (str != null && str.length() > 0) {
                    labelSet = true;
                    currNodeEntry.setLabel(str);
                    currNodeEntry.setLabelSource(OnmsNode.NodeLabelSource.SYSNAME);
                }
            }
        }
        if (!labelSet) {
            if (primaryIf != null) {
                currNodeEntry.setLabel(InetAddressUtils.str((InetAddress)primaryIf));
                currNodeEntry.setLabelSource(OnmsNode.NodeLabelSource.ADDRESS);
            } else {
                currNodeEntry.setLabel(dbNodeEntry.getLabel());
                currNodeEntry.setLabelSource(dbNodeEntry.getLabelSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNodeDeleted(Connection dbc, int nodeId) throws SQLException {
        boolean nodeDeleted = false;
        DBUtils d = new DBUtils(RescanProcessor.class);
        try {
            PreparedStatement stmt = dbc.prepareStatement(SQL_DB_RETRIEVE_NODE_TYPE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            rs.next();
            String nodeTypeStr = rs.getString(1);
            if (!rs.wasNull() && OnmsNode.NodeType.DELETED.toString().equals(Character.valueOf(nodeTypeStr.charAt(0)))) {
                nodeDeleted = true;
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeDeleted;
    }

    private static boolean areDbInterfacesInSnmpCollection(DbIpInterfaceEntry[] dbInterfaces, IfSnmpCollector snmpc) {
        if (dbInterfaces == null || snmpc == null) {
            LOG.error("areDbInterfacesInSnmpCollection: empty dbInterfaces or IfSnmpCollector.");
            return false;
        }
        if (!snmpc.hasIpAddrTable()) {
            LOG.error("areDbInterfacesInSnmpCollection: SNMP Collector failed.");
            return false;
        }
        IpAddrTable ipAddrTable = null;
        if (snmpc.hasIpAddrTable()) {
            ipAddrTable = snmpc.getIpAddrTable();
        }
        if (ipAddrTable == null) {
            LOG.error("areDbInterfacesInSnmpCollection: null ipAddrTable in the SNMP collection");
            return false;
        }
        List<InetAddress> ipAddrList = ipAddrTable.getIpAddresses();
        for (DbIpInterfaceEntry dbInterface : dbInterfaces) {
            InetAddress ipaddr = dbInterface.getIfAddress();
            String ipaddrString = InetAddressUtils.str((InetAddress)ipaddr);
            if (ipaddrString == null || s_ZERO_ZERO_ZERO_ZERO.equals(ipaddrString) || ipaddr.isLoopbackAddress()) continue;
            boolean found = false;
            for (InetAddress addr : ipAddrList) {
                String addrString = InetAddressUtils.str((InetAddress)addr);
                if (addrString == null || s_ZERO_ZERO_ZERO_ZERO.equals(addrString) || addr.isLoopbackAddress() || !ipaddrString.equals(addrString)) continue;
                LOG.debug("areDbInterfacesInSnmpCollection: found match for ipaddress: {}", (Object)ipaddrString);
                return true;
            }
            if (found) continue;
            LOG.debug("areDbInterfacesInSnmpCollection: ipaddress : {} not in the SNMP collection. SNMP collection may not be usable.", (Object)ipaddrString);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set<Integer> ifaddrString;
        DbNodeEntry dbNodeEntry = this.getNode();
        if (dbNodeEntry == null) {
            return;
        }
        if (dbNodeEntry.getForeignSource() != null) {
            LOG.info("Skipping rescan of node {} since it was imported with foreign source {}", (Object)this.getNodeId(), (Object)dbNodeEntry.getForeignSource());
            return;
        }
        LOG.debug("start rescanning node: {}", (Object)this.getNodeId());
        DbIpInterfaceEntry[] dbInterfaces = this.getInterfaces(dbNodeEntry);
        if (dbInterfaces == null) {
            LOG.debug("no interfaces found in the database to rescan for node: {}", (Object)this.getNodeId());
            return;
        }
        boolean doesSnmp = true;
        IpAddrTable ipAddTable = null;
        List<InetAddress> prevAddrList = null;
        boolean snmpcAgree = false;
        boolean gotSnmpc = false;
        HashMap<String, IfCollector> collectorMap = new HashMap<String, IfCollector>();
        HashMap<Set<Integer>, IfCollector> nonSnmpCollectorMap = new HashMap<Set<Integer>, IfCollector>();
        HashSet<InetAddress> probedAddrs = new HashSet<InetAddress>();
        boolean gotSnmpCollection = false;
        DbIpInterfaceEntry oldPrimarySnmpInterface = DbNodeEntry.getPrimarySnmpInterface(dbInterfaces);
        if (oldPrimarySnmpInterface != null) {
            gotSnmpCollection = this.scanPrimarySnmpInterface(oldPrimarySnmpInterface, collectorMap, probedAddrs);
        }
        if (!gotSnmpCollection) {
            for (int i = 0; i < dbInterfaces.length; ++i) {
                LOG.info("run: Running collector for interface {} of {}", (Object)i, (Object)dbInterfaces.length);
                InetAddress ifaddr = dbInterfaces[i].getIfAddress();
                ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
                if (!RescanProcessor.scannableInterface(dbInterfaces, ifaddr)) {
                    LOG.debug("run: skipping scan of address: {}", (Object)ifaddrString);
                    continue;
                }
                if (ifaddrString == null) {
                    LOG.debug("run: unable to scan inet address: {}", (Object)ifaddr);
                    continue;
                }
                LOG.debug("running collection for {}", (Object)ifaddrString);
                IfCollector collector = new IfCollector(this.m_pluginManager, ifaddr, true, probedAddrs);
                collector.run();
                IfSnmpCollector snmpc = collector.getSnmpCollector();
                if (snmpc != null) {
                    gotSnmpc = true;
                }
                if (snmpc != null && snmpc.hasIpAddrTable() && snmpc.getIfIndex(snmpc.getCollectorTargetAddress()) != -1) {
                    if (RescanProcessor.areDbInterfacesInSnmpCollection(dbInterfaces, snmpc)) {
                        collectorMap.put((String)((Object)ifaddrString), collector);
                        gotSnmpCollection = true;
                        LOG.debug("SNMP data collected via {}", ifaddrString);
                        LOG.debug("Adding {} to collectorMap for node: {}", ifaddrString, (Object)this.getNodeId());
                        snmpcAgree = false;
                        break;
                    }
                    if (ipAddTable == null) {
                        snmpcAgree = true;
                        collectorMap.put((String)((Object)ifaddrString), collector);
                        ipAddTable = snmpc.getIpAddrTable();
                        prevAddrList = ipAddTable.getIpAddresses();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SNMP data collected via {} does not agree with database.  Tentatively adding to the collectorMap and continuing", ifaddrString);
                            for (InetAddress a : prevAddrList) {
                                LOG.debug("IP address in list = {}", (Object)a);
                            }
                        }
                    } else if (ipAddTable != null && snmpcAgree) {
                        boolean listMatch;
                        ipAddTable = snmpc.getIpAddrTable();
                        List<InetAddress> addrList = ipAddTable.getIpAddresses();
                        boolean bl = listMatch = addrList.size() == prevAddrList.size() && addrList.containsAll(prevAddrList);
                        if (listMatch) {
                            LOG.debug("Current and previous address lists match");
                        } else {
                            LOG.debug("Current and previous address lists DO NOT match");
                            snmpcAgree = false;
                        }
                        collector.deleteSnmpCollector();
                    }
                    if (snmpcAgree) continue;
                    LOG.debug("SNMP data collected via {} does not agree with database or with other interface(s) on this node.", ifaddrString);
                    continue;
                }
                nonSnmpCollectorMap.put(ifaddrString, collector);
                LOG.debug("Adding {} to nonSnmpCollectorMap for node: {}", ifaddrString, (Object)this.getNodeId());
            }
        }
        if (!gotSnmpCollection && !snmpcAgree) {
            collectorMap = nonSnmpCollectorMap;
            if (nonSnmpCollectorMap.size() == 1 && gotSnmpc) {
                doesSnmp = true;
                LOG.debug("node {} appears to be a lame SNMP host... Proceeding", (Object)this.getNodeId());
            } else {
                doesSnmp = false;
                if (LOG.isDebugEnabled()) {
                    if (!gotSnmpc) {
                        LOG.debug("Could not collect SNMP data for node: {}", (Object)this.getNodeId());
                    } else {
                        LOG.debug("Not using SNMP data for node: {}.  Collection does not agree with database.", (Object)this.getNodeId());
                    }
                }
            }
        } else if (snmpcAgree) {
            LOG.debug("SNMP collection for node: {} does not agree with database, but there is no conflict among the interfaces on this node which respond to SNMP. Proceeding...", (Object)this.getNodeId());
            this.m_eventList.add(RescanProcessor.createSnmpConflictsWithDbEvent(dbNodeEntry));
        }
        DBUtils d = new DBUtils();
        boolean updateCompleted = false;
        try {
            LOG.debug("Waiting for capsd dbLock to process {}", (Object)this.getNodeId());
            ifaddrString = Capsd.getDbSyncLock();
            synchronized (ifaddrString) {
                LOG.debug("Got capsd dbLock. processing {}", (Object)this.getNodeId());
                Connection dbc = DataSourceFactory.getInstance().getConnection();
                d.watch((Object)dbc);
                if (!RescanProcessor.isNodeDeleted(dbc, this.getNodeId())) {
                    Date now = new Date();
                    this.updateInterfaces(dbc, now, dbNodeEntry, collectorMap, doesSnmp);
                    if (doesSnmp) {
                        InetAddress oldPriIf = null;
                        if (oldPrimarySnmpInterface != null) {
                            oldPriIf = oldPrimarySnmpInterface.getIfAddress();
                        }
                        InetAddress newSnmpPrimaryIf = this.updatePrimarySnmpInterface(dbc, dbNodeEntry, collectorMap, oldPriIf);
                        this.updateNode(dbc, now, dbNodeEntry, newSnmpPrimaryIf, dbInterfaces, collectorMap);
                    }
                    updateCompleted = true;
                    this.m_eventList.add(RescanProcessor.createRescanCompletedEvent(dbNodeEntry));
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Error updating records for node ID {}", (Object)this.getNodeId(), (Object)t);
        }
        finally {
            d.cleanUp();
            ifaddrString = s_queuedRescanTracker;
            synchronized (ifaddrString) {
                s_queuedRescanTracker.remove(this.getNodeId());
            }
        }
        if (updateCompleted) {
            for (Event event : this.m_eventList) {
                try {
                    EventIpcManagerFactory.getIpcManager().sendNow(event);
                }
                catch (Throwable t) {
                    LOG.warn("run: unexpected throwable exception caught while sending event", t);
                }
            }
        }
        LOG.debug("{}escan for node w/ nodeid {} completed.", (Object)(this.m_forceRescan ? "Forced r" : "R"), (Object)this.getNodeId());
    }

    protected static boolean scannableInterface(DbIpInterfaceEntry[] dbInterfaces, InetAddress ifaddr) {
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (ifaddrString == null) {
            return false;
        }
        boolean localHostAddress = ifaddr.isLoopbackAddress() && dbInterfaces.length > 1;
        boolean nonIpAddress = s_ZERO_ZERO_ZERO_ZERO.equals(ifaddrString);
        boolean scannable = !localHostAddress && !nonIpAddress;
        return scannable;
    }

    private int getNodeId() {
        return this.m_nodeId;
    }

    private boolean scanPrimarySnmpInterface(DbIpInterfaceEntry oldPrimarySnmpInterface, Map<String, IfCollector> collectorMap, Set<InetAddress> probedAddrs) {
        InetAddress ifaddr = oldPrimarySnmpInterface.getIfAddress();
        String ifaddrString = InetAddressUtils.str((InetAddress)ifaddr);
        if (ifaddrString == null) {
            LOG.info("old primary SNMP interface has an invalid address: {}", (Object)ifaddr);
            return false;
        }
        LOG.debug("running collection for DB primary SNMP interface {}", (Object)ifaddrString);
        IfCollector collector = new IfCollector(this.m_pluginManager, ifaddr, true, probedAddrs);
        collector.run();
        IfSnmpCollector snmpc = collector.getSnmpCollector();
        if (snmpc == null) {
            LOG.debug("SNMP Collector from DB primary SNMP interface is null");
            return false;
        }
        collectorMap.put(ifaddrString, collector);
        LOG.debug("SNMP data collected from DB primary SNMP interface {}", (Object)ifaddrString);
        if (!snmpc.hasIfTable()) {
            LOG.debug("SNMP Collector has no IfTable");
        }
        if (!snmpc.hasIpAddrTable() || snmpc.getIfIndex(snmpc.getCollectorTargetAddress()) == -1) {
            LOG.debug("SNMP Collector has no IpAddrTable. Assume its a lame SNMP host.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress updatePrimarySnmpInterface(Connection dbc, DbNodeEntry dbNodeEntry, Map<String, IfCollector> collectorMap, InetAddress oldPriIf) throws SQLException {
        FilterDaoFactory.getInstance().flushActiveIpAddressListCache();
        IfSnmpCollector snmpc = RescanProcessor.findSnmpCollector(collectorMap);
        List<InetAddress> snmpLBAddresses = RescanProcessor.buildLBSnmpAddressList(collectorMap, snmpc);
        List<InetAddress> snmpAddresses = RescanProcessor.buildSnmpAddressList(collectorMap, snmpc);
        for (InetAddress addr : snmpAddresses) {
            String addrString = InetAddressUtils.str((InetAddress)addr);
            if (!this.m_capsdDbSyncer.isServiceCollectionEnabled(addrString, "SNMP")) continue;
            DBUtils d = new DBUtils(RescanProcessor.class);
            try {
                PreparedStatement stmt = dbc.prepareStatement("UPDATE ipInterface SET isSnmpPrimary='S' WHERE nodeId=? AND ipAddr=? AND isManaged!='D'");
                d.watch((Object)stmt);
                stmt.setInt(1, dbNodeEntry.getNodeId());
                stmt.setString(2, addrString);
                stmt.executeUpdate();
                LOG.debug("updatePrimarySnmpInterface: updated {} to secondary.", (Object)addrString);
            }
            finally {
                d.cleanUp();
            }
        }
        InetAddress newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(snmpLBAddresses, true);
        String psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(snmpAddresses, true);
            psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(snmpLBAddresses, false);
            psiType = "DB loopback addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = this.m_capsdDbSyncer.determinePrimarySnmpInterface(snmpAddresses, false);
            psiType = "DB addresses";
        }
        if (newSnmpPrimaryIf == null) {
            newSnmpPrimaryIf = snmpc.getCollectorTargetAddress();
            psiType = "SNMP collector target address";
        }
        if (newSnmpPrimaryIf != null) {
            LOG.debug("updatePrimarySnmpInterface: primary SNMP interface is: {}, selected from {}", (Object)newSnmpPrimaryIf, (Object)psiType);
            SuspectEventProcessor.setPrimarySnmpInterface(dbc, dbNodeEntry, newSnmpPrimaryIf, oldPriIf);
        } else {
            LOG.debug("SuspectEventProcessor: Unable to determine a primary SNMP interface");
        }
        this.generateSnmpDataCollectionEvents(dbNodeEntry, oldPriIf, newSnmpPrimaryIf);
        return newSnmpPrimaryIf;
    }

    private static IfSnmpCollector findSnmpCollector(Map<String, IfCollector> collectorMap) {
        for (IfCollector collector : collectorMap.values()) {
            if (!collector.hasSnmpCollection()) continue;
            return collector.getSnmpCollector();
        }
        return null;
    }

    private DbIpInterfaceEntry[] getInterfaces(DbNodeEntry dbNodeEntry) {
        LOG.debug("retrieving managed interfaces for node: {}", (Object)this.getNodeId());
        try {
            return this.m_forceRescan ? dbNodeEntry.getInterfaces() : dbNodeEntry.getManagedInterfaces();
        }
        catch (NullPointerException npE) {
            LOG.error("RescanProcessor: Null pointer when retrieving {} interfaces for node {}", new Object[]{this.m_forceRescan ? "" : "managed", this.getNodeId(), npE});
            LOG.error("Rescan failed for node w/ nodeid {}", (Object)this.getNodeId());
        }
        catch (SQLException sqlE) {
            LOG.error("RescanProcessor: unable to load interface info for nodeId {} from the database.", (Object)this.getNodeId(), (Object)sqlE);
            LOG.error("Rescan failed for node w/ nodeid {}", (Object)this.getNodeId());
        }
        return null;
    }

    private DbNodeEntry getNode() {
        try {
            return DbNodeEntry.get(this.getNodeId());
        }
        catch (SQLException e) {
            LOG.error("RescanProcessor: unable to load node info for nodeId {} from the database.", (Object)this.getNodeId(), (Object)e);
            LOG.error("Rescan failed for node w/ nodeid {}", (Object)this.getNodeId());
            return null;
        }
    }

    private void generateSnmpDataCollectionEvents(DbNodeEntry nodeEntry, InetAddress oldPriIf, InetAddress primarySnmpIf) {
        if (oldPriIf == null && primarySnmpIf != null) {
            LOG.debug("generateSnmpDataCollectionEvents: Either SNMP support was recently enabled on this node, or node doesn't support ipAddrTable MIB.");
            this.m_eventList.add(RescanProcessor.createPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), primarySnmpIf, null));
            return;
        }
        if (primarySnmpIf != null && !oldPriIf.equals(primarySnmpIf)) {
            LOG.debug("generateSnmpDataCollectionEvents: primary SNMP interface has changed.  Was: {} Is: {}", (Object)InetAddressUtils.str((InetAddress)oldPriIf), (Object)InetAddressUtils.str((InetAddress)primarySnmpIf));
            this.m_eventList.add(RescanProcessor.createPrimarySnmpInterfaceChangedEvent(nodeEntry.getNodeId(), primarySnmpIf, oldPriIf));
            return;
        }
        if (this.m_ifIndexOnNodeChangedFlag || this.m_snmpIfTableChangedFlag) {
            LOG.debug("generateSnmpDataCollectionEvents: Generating reinitializeSnmpInterface event for interface {}", (Object)InetAddressUtils.str((InetAddress)primarySnmpIf));
            this.m_eventList.add(RescanProcessor.createReinitializePrimarySnmpInterfaceEvent(nodeEntry.getNodeId(), primarySnmpIf));
        }
    }

    private static EventBuilder eventBuilder(String uei) {
        return new EventBuilder(uei, "OpenNMS.Capsd").setHost(Capsd.getLocalHostAddress());
    }

    private static EventBuilder nodeEventBuilder(String uei, long nodeId) {
        return RescanProcessor.eventBuilder(uei).setNodeid(nodeId);
    }

    private static EventBuilder interfaceEventBuilder(String uei, long nodeId, String ipAddr) {
        return RescanProcessor.eventBuilder(uei).setNodeid(nodeId).setInterface(InetAddressUtils.addr((String)ipAddr));
    }

    private static EventBuilder serviceEventBuilder(String uei, long nodeId, String ipAddr, String svc) {
        return RescanProcessor.eventBuilder(uei).setNodeid(nodeId).setInterface(InetAddressUtils.addr((String)ipAddr)).setService(svc);
    }

    private static Event createNodeLabelChangedEvent(DbNodeEntry updatedEntry, DbNodeEntry originalEntry) {
        LOG.debug("createNodeLabelChangedEvent: nodeId: {} oldLabel: '{}' oldSource: '{}' newLabel: '{}' newLabelSource: '{}'", new Object[]{updatedEntry.getNodeId(), originalEntry.getLabel(), originalEntry.getLabelSource(), updatedEntry.getLabel(), updatedEntry.getLabelSource()});
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/nodes/nodeLabelChanged", updatedEntry.getNodeId());
        if (originalEntry.getLabel() != null) {
            bldr.addParam("oldNodeLabel", originalEntry.getLabel());
            if (originalEntry.getLabelSource() != null) {
                bldr.addParam("oldNodeLabelSource", originalEntry.getLabelSource().toString());
            }
        }
        if (updatedEntry.getLabel() != null) {
            bldr.addParam("newNodeLabel", updatedEntry.getLabel());
            if (updatedEntry.getLabelSource() != null) {
                bldr.addParam("newNodeLabelSource", updatedEntry.getLabelSource().toString());
            }
        }
        LOG.debug("createNodeLabelChangedEvent: successfully created nodeLabelChanged event for nodeid: {}", (Object)updatedEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createNodeInfoChangedEvent(DbNodeEntry updatedEntry, DbNodeEntry originalEntry) {
        LOG.debug("createNodeInfoChangedEvent: nodeId: {}", (Object)updatedEntry.getNodeId());
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/nodes/nodeInfoChanged", updatedEntry.getNodeId());
        if (updatedEntry.getSystemOID() != null) {
            bldr.addParam("nodesysoid", updatedEntry.getSystemOID());
        }
        if (updatedEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", updatedEntry.getSystemName());
        }
        if (updatedEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", updatedEntry.getSystemDescription());
        }
        if (updatedEntry.getSystemLocation() != null) {
            bldr.addParam("nodesyslocation", updatedEntry.getSystemLocation());
        }
        if (updatedEntry.getSystemContact() != null) {
            bldr.addParam("nodesyscontact", updatedEntry.getSystemContact());
        }
        if (updatedEntry.getNetBIOSName() != null) {
            bldr.addParam("nodenetbiosname", updatedEntry.getNetBIOSName());
        }
        if (updatedEntry.getDomainName() != null) {
            bldr.addParam("nodedomainname", updatedEntry.getDomainName());
        }
        if (updatedEntry.getOS() != null) {
            bldr.addParam("nodeoperatingsystem", updatedEntry.getOS());
        }
        LOG.debug("createNodeInfoChangedEvent: successfully created nodeInfoChanged event for nodeid: {}", (Object)updatedEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createPrimarySnmpInterfaceChangedEvent(int nodeId, InetAddress newPrimaryIf, InetAddress oldPrimaryIf) {
        String oldPrimaryAddr = InetAddressUtils.str((InetAddress)oldPrimaryIf);
        String newPrimaryAddr = InetAddressUtils.str((InetAddress)newPrimaryIf);
        LOG.debug("createPrimarySnmpInterfaceChangedEvent: nodeId: {} oldPrimarySnmpIf: '{}' newPrimarySnmpIf: '{}'", new Object[]{nodeId, oldPrimaryAddr, newPrimaryAddr});
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/nodes/primarySnmpInterfaceChanged", nodeId, newPrimaryAddr, "SNMP");
        if (oldPrimaryAddr != null) {
            bldr.addParam("oldPrimarySnmpAddress", oldPrimaryAddr);
        }
        if (newPrimaryAddr != null) {
            bldr.addParam("newPrimarySnmpAddress", newPrimaryAddr);
        }
        LOG.debug("createPrimarySnmpInterfaceChangedEvent: successfully created primarySnmpInterfaceChanged event for nodeid: {}", (Object)nodeId);
        return bldr.getEvent();
    }

    private static Event createInterfaceIndexChangedEvent(DbIpInterfaceEntry updatedEntry, DbIpInterfaceEntry originalEntry) {
        LOG.debug("createInterfaceIndexChangedEvent: nodeId: {} oldIfIndex: {} newIfIndex: {}", new Object[]{updatedEntry.getNodeId(), originalEntry.getIfIndex(), updatedEntry.getIfIndex()});
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/interfaceIndexChanged", updatedEntry.getNodeId(), InetAddressUtils.str((InetAddress)updatedEntry.getIfAddress()));
        bldr.addParam("oldIfIndex", originalEntry.getIfIndex());
        bldr.addParam("newIfIndex", updatedEntry.getIfIndex());
        LOG.debug("createInterfaceIndexChangedEvent: successfully created interfaceIndexChanged event for nodeid: {}", (Object)updatedEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createIpHostNameChangedEvent(DbIpInterfaceEntry updatedEntry, DbIpInterfaceEntry originalEntry) {
        LOG.debug("createIpHostNameChangedEvent: nodeId: {} oldHostName: {} newHostName: {}", new Object[]{updatedEntry.getNodeId(), originalEntry.getHostname(), updatedEntry.getHostname()});
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/interfaceIPHostNameChanged", updatedEntry.getNodeId(), InetAddressUtils.str((InetAddress)updatedEntry.getIfAddress()));
        if (originalEntry.getHostname() != null) {
            bldr.addParam("oldiphostname", originalEntry.getHostname());
        }
        if (updatedEntry.getHostname() != null) {
            bldr.addParam("iphostname", updatedEntry.getHostname());
        }
        LOG.debug("createIpHostNameChangedEvent: successfully created ipHostNameChanged event for nodeid: {}", (Object)updatedEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createInterfaceReparentedEvent(DbNodeEntry newNode, int oldNodeId, InetAddress reparentedIf) {
        String reparentedAddress = InetAddressUtils.str((InetAddress)reparentedIf);
        LOG.debug("createInterfaceReparentedEvent: ifAddr: {} oldNodeId: {} newNodeId: {}", new Object[]{reparentedAddress, oldNodeId, newNode.getNodeId()});
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/interfaceReparented", newNode.getNodeId(), reparentedAddress);
        bldr.addParam("oldNodeID", oldNodeId);
        bldr.addParam("newNodeID", newNode.getNodeId());
        bldr.addParam("iphostname", reparentedIf.getHostName());
        if (newNode.getLabel() != null) {
            bldr.addParam("nodelabel", newNode.getLabel());
            if (newNode.getLabelSource() != null) {
                bldr.addParam("nodelabelsource", newNode.getLabelSource().toString());
            }
        }
        if (newNode.getSystemName() != null) {
            bldr.addParam("nodesysname", newNode.getSystemName());
        }
        if (newNode.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", newNode.getSystemDescription());
        }
        LOG.debug("createInterfaceReparentedEvent: successfully created interfaceReparented event for nodeid/interface: {}/{}", (Object)newNode.getNodeId(), (Object)reparentedAddress);
        return bldr.getEvent();
    }

    private static Event createDuplicateNodeDeletedEvent(DbNodeEntry deletedNode) {
        LOG.debug("createDuplicateNodeDeletedEvent: delete nodeid: {}", (Object)deletedNode.getNodeId());
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/nodes/duplicateNodeDeleted", deletedNode.getNodeId());
        LOG.debug("createDuplicateNodeDeletedEvent: successfully created duplicateNodeDeleted event for nodeid: {}", (Object)deletedNode.getNodeId());
        return bldr.getEvent();
    }

    private static Event createNodeGainedInterfaceEvent(DbIpInterfaceEntry ifEntry) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        LOG.debug("createNodeGainedInterfaceEvent: nodeId: {} interface: {}", (Object)ifEntry.getNodeId(), (Object)ifAddress);
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/nodeGainedInterface", ifEntry.getNodeId(), ifAddress);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        bldr.addParam("method", "icmp");
        LOG.debug("createNodeGainedInterfaceEvent: successfully created nodeGainedInterface event for nodeid: {}", (Object)ifEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createDuplicateIpAddressEvent(DbIpInterfaceEntry ifEntry) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        LOG.debug("createDuplicateIpAddressEvent: nodeId: {} interface: {}", (Object)ifEntry.getNodeId(), (Object)ifAddress);
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/internal/capsd/duplicateIPAddress", ifEntry.getNodeId(), ifAddress);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        bldr.addParam("method", "icmp");
        LOG.debug("createDuplicateIpAddressEvent: successfully created duplicateIpAddress event for nodeid: {}", (Object)ifEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createNodeGainedServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        LOG.debug("createNodeGainedServiceEvent: nodeId: {} interface: {} service: {}", new Object[]{ifEntry.getNodeId(), ifAddress, svcName});
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/nodes/nodeGainedService", ifEntry.getNodeId(), ifAddress, svcName);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        LOG.debug("createNodeGainedServiceEvent: successfully created nodeGainedService event for nodeid: {}", (Object)ifEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createSuspendPollingServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/internal/poller/suspendPollingService", ifEntry.getNodeId(), ifAddress, svcName);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        LOG.debug("suspendPollingServiceEvent: Created suspendPollingService event for nodeid: {} interface: {} service: {}", new Object[]{ifEntry.getNodeId(), ifAddress, svcName});
        return bldr.getEvent();
    }

    private static Event createResumePollingServiceEvent(DbNodeEntry nodeEntry, DbIpInterfaceEntry ifEntry, String svcName) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        EventBuilder bldr = RescanProcessor.serviceEventBuilder("uei.opennms.org/internal/poller/resumePollingService", ifEntry.getNodeId(), ifAddress, svcName);
        bldr.addParam("iphostname", ifEntry.getHostname() == null ? "" : ifEntry.getHostname());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        LOG.debug("resumePollingServiceEvent: Created resumePollingService event for nodeid: {} interface: {} service: {}", new Object[]{ifEntry.getNodeId(), ifAddress, svcName});
        return bldr.getEvent();
    }

    private static Event createSnmpConflictsWithDbEvent(DbNodeEntry nodeEntry) {
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/internal/capsd/snmpConflictsWithDb", nodeEntry.getNodeId());
        bldr.addParam("nodelabel", nodeEntry.getLabel() == null ? "" : nodeEntry.getLabel());
        if (nodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", nodeEntry.getSystemName());
        }
        if (nodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", nodeEntry.getSystemDescription());
        }
        LOG.debug("snmpConflictsWithDbEvent: Created snmpConflictsWithDbEvent for nodeid: {}", (Object)nodeEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createRescanCompletedEvent(DbNodeEntry nodeEntry) {
        EventBuilder bldr = RescanProcessor.nodeEventBuilder("uei.opennms.org/internal/capsd/rescanCompleted", nodeEntry.getNodeId());
        bldr.addParam("nodelabel", nodeEntry.getLabel() == null ? "" : nodeEntry.getLabel());
        LOG.debug("rescanCompletedEvent: Created rescanCompletedEvent for nodeid: {}", (Object)nodeEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createInterfaceSupportsSNMPEvent(DbIpInterfaceEntry ifEntry) {
        String ifAddress = InetAddressUtils.str((InetAddress)ifEntry.getIfAddress());
        LOG.debug("createInterfaceSupportsSNMPEvent: nodeId: {} interface: {}", (Object)ifEntry.getNodeId(), (Object)ifAddress);
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/internal/capsd/interfaceSupportsSNMP", ifEntry.getNodeId(), ifAddress);
        LOG.debug("interfaceSupportsSNMPEvent: successfully created interfaceSupportsSNMPEvent event for nodeid: {}", (Object)ifEntry.getNodeId());
        return bldr.getEvent();
    }

    private static Event createReinitializePrimarySnmpInterfaceEvent(int nodeId, InetAddress primarySnmpIf) {
        String primaryAddress = InetAddressUtils.str((InetAddress)primarySnmpIf);
        LOG.debug("reinitializePrimarySnmpInterface: nodeId: {} interface: {}", (Object)nodeId, (Object)primaryAddress);
        EventBuilder bldr = RescanProcessor.interfaceEventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", nodeId, primaryAddress);
        LOG.debug("createReinitializePrimarySnmpInterfaceEvent: successfully created reinitializePrimarySnmpInterface event for interface: {}", (Object)primaryAddress);
        return bldr.getEvent();
    }

    public static synchronized void setQueuedRescansTracker(Set<Integer> queuedRescanTracker) {
        s_queuedRescanTracker = Collections.synchronizedSet(queuedRescanTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRescanQueuedForNode(Integer nodeId) {
        Set<Integer> set = s_queuedRescanTracker;
        synchronized (set) {
            return s_queuedRescanTracker.contains(nodeId);
        }
    }
}

