/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfXTable;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IfSnmpCollector
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(IfSnmpCollector.class);
    private final InetAddress m_address;
    private SystemGroup m_sysGroup;
    private IfTable m_ifTable;
    private IpAddrTable m_ipAddrTable;
    private IfXTable m_ifXTable;

    public IfSnmpCollector(InetAddress address) {
        this.m_address = address;
        this.m_sysGroup = null;
        this.m_ifTable = null;
        this.m_ifXTable = null;
        this.m_ipAddrTable = null;
    }

    public boolean failed() {
        return !this.hasSystemGroup() || !this.hasIfTable() || !this.hasIpAddrTable();
    }

    public boolean hasSystemGroup() {
        if (this.m_sysGroup == null) {
            LOG.debug("hasSystemGroup: No system group present.");
        }
        return this.m_sysGroup != null && !this.m_sysGroup.failed();
    }

    public SystemGroup getSystemGroup() {
        return this.m_sysGroup;
    }

    public boolean hasIfTable() {
        if (this.m_ifTable == null) {
            LOG.debug("hasIfTable: No interface table present.");
        }
        return this.m_ifTable != null && !this.m_ifTable.failed();
    }

    public IfTable getIfTable() {
        return this.m_ifTable;
    }

    public boolean hasIpAddrTable() {
        if (this.m_ipAddrTable == null) {
            LOG.debug("hasIpAddrTable: No IP interface address table present.");
        }
        return this.m_ipAddrTable != null && !this.m_ipAddrTable.failed();
    }

    public IpAddrTable getIpAddrTable() {
        return this.m_ipAddrTable;
    }

    public boolean hasIfXTable() {
        if (this.m_ifXTable == null) {
            LOG.debug("hasIfXTable: No interface extensions table present.");
        }
        return this.m_ifXTable != null && !this.m_ifXTable.failed();
    }

    public IfXTable getIfXTable() {
        return this.m_ifXTable;
    }

    public InetAddress getCollectorTargetAddress() {
        return this.m_address;
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        if (!this.hasIpAddrTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ipAddrTable.getIfAddressAndMask(ifIndex);
    }

    public int getAdminStatus(int ifIndex) {
        if (!this.hasIfTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ifTable.getAdminStatus(ifIndex);
    }

    public int getOperStatus(int ifIndex) {
        if (!this.hasIfTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ifTable.getOperStatus(ifIndex);
    }

    public int getIfType(int ifIndex) {
        if (!this.hasIfTable()) {
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ifTable.getIfType(ifIndex);
    }

    public int getIfIndex(InetAddress address) {
        LOG.debug("getIfIndex: retrieving ifIndex for {}", (Object)InetAddressUtils.str((InetAddress)address));
        if (!this.hasIpAddrTable()) {
            LOG.debug("getIfIndex: Illegal index, no table present.");
            throw new IndexOutOfBoundsException("Illegal Index, no table present");
        }
        return this.m_ipAddrTable.getIfIndex(address);
    }

    public String getIfName(int ifIndex) {
        String snmpIfName = null;
        if (this.hasIfXTable()) {
            snmpIfName = this.m_ifXTable.getIfName(ifIndex);
        }
        if (snmpIfName != null) {
            LOG.debug("getIfName: ifIndex {} has ifName '{}'", (Object)ifIndex, (Object)snmpIfName);
        } else {
            LOG.debug("getIfName: no ifName found for ifIndex {}", (Object)ifIndex);
        }
        return snmpIfName;
    }

    public String getIfDescr(int ifIndex) {
        String ifDescr = null;
        if (this.hasIfTable()) {
            ifDescr = this.m_ifTable.getIfDescr(ifIndex);
        }
        return ifDescr;
    }

    public Long getInterfaceSpeed(int ifIndex) {
        Long ifSpeed = null;
        try {
            if (this.hasIfXTable() && this.getIfXTable().getIfHighSpeed(ifIndex) != null && this.getIfXTable().getIfHighSpeed(ifIndex) > 4294L) {
                ifSpeed = this.getIfXTable().getIfHighSpeed(ifIndex) * 1000000L;
                LOG.debug("getInterfaceSpeed:  Using ifHighSpeed for ifIndex {}: {}", (Object)ifIndex, (Object)ifSpeed);
            } else if (this.hasIfTable()) {
                ifSpeed = this.m_ifTable.getIfSpeed(ifIndex);
                LOG.debug("getInterfaceSpeed:  Using ifSpeed for ifIndex {}: {}", (Object)ifIndex, (Object)ifSpeed);
            }
        }
        catch (Throwable e) {
            LOG.warn("getInterfaceSpeed: exception retrieving interface speed for ifIndex {}", (Object)ifIndex);
        }
        return ifSpeed;
    }

    public String getPhysAddr(int ifIndex) {
        String physAddr = null;
        if (this.hasIfTable()) {
            physAddr = this.m_ifTable.getPhysAddr(ifIndex);
        }
        return physAddr;
    }

    public String getIfAlias(int ifIndex) {
        String snmpIfAlias = null;
        if (this.hasIfXTable()) {
            snmpIfAlias = this.m_ifXTable.getIfAlias(ifIndex);
            if (LOG.isDebugEnabled()) {
                if (snmpIfAlias != null) {
                    LOG.debug("getIfAlias: ifIndex {} has ifAlias '{}'", (Object)ifIndex, (Object)snmpIfAlias);
                } else {
                    LOG.debug("getIfAlias: no ifAlias found for ifIndex {}", (Object)ifIndex);
                }
            }
        } else {
            LOG.debug("getIfAlias: no ifXTable retrieved from {}", (Object)this.m_address);
        }
        return snmpIfAlias;
    }

    @Override
    public void run() {
        this.m_sysGroup = new SystemGroup(this.m_address);
        this.m_ifTable = new IfTable(this.m_address);
        this.m_ipAddrTable = new IpAddrTable(this.m_address);
        this.m_ifXTable = new IfXTable(this.m_address);
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(this.m_address);
        LOG.debug("run: collecting for: {} with agentConfig: {}", (Object)this.m_address, (Object)agentConfig);
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"system/ifTable/ifXTable/ipAddrTable", (CollectionTracker[])new CollectionTracker[]{this.m_sysGroup, this.m_ifTable, this.m_ipAddrTable, this.m_ifXTable});
        walker.start();
        try {
            walker.waitFor(300000L);
        }
        catch (InterruptedException e) {
            this.m_sysGroup = null;
            this.m_ifTable = null;
            this.m_ipAddrTable = null;
            this.m_ifXTable = null;
            LOG.warn("IfSnmpCollector: collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (walker.failed()) {
            LOG.info("IfSnmpCollector: walker failed with error message:", (Object)walker.getErrorMessage());
        }
        if (!this.hasSystemGroup()) {
            LOG.info("IfSnmpCollector: failed to collect System group for {}", (Object)InetAddressUtils.str((InetAddress)this.m_address));
        }
        if (!this.hasIfTable()) {
            LOG.info("IfSnmpCollector: failed to collect ifTable for {}", (Object)InetAddressUtils.str((InetAddress)this.m_address));
        }
        if (!this.hasIpAddrTable()) {
            LOG.info("IfSnmpCollector: failed to collect ipAddrTable for {}", (Object)InetAddressUtils.str((InetAddress)this.m_address));
        }
        if (!this.hasIfXTable()) {
            LOG.info("IfSnmpCollector: failed to collect ifXTable for {}", (Object)InetAddressUtils.str((InetAddress)this.m_address));
        }
    }
}

