/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EventUtils.class);

    public static void addEventListener(EventListener listener, List<String> ueiList) {
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(listener, ueiList);
    }

    public static void checkEventId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasDbid()) {
            throw new InsufficientInformationException("eventID is unavailable");
        }
    }

    public static void checkInterface(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getInterface() == null) {
            throw new InsufficientInformationException("ipaddr for event is unavailable");
        }
    }

    public static boolean isNonIpInterface(String intf) {
        return intf == null || intf.length() == 0 || "0.0.0.0".equals(intf);
    }

    public static void checkInterfaceOrIfIndex(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("event is null");
        }
        if (e.getInterface() == null && !e.hasIfIndex()) {
            throw new InsufficientInformationException("Neither ipaddr nor ifIndex for the event is available");
        }
    }

    public static void checkHost(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getHost() == null || e.getHost().length() == 0) {
            throw new InsufficientInformationException("host for event is unavailable");
        }
    }

    public static void checkNodeId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasNodeid()) {
            throw new InsufficientInformationException("nodeid for event is unavailable");
        }
    }

    public static void checkService(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getService() == null || e.getService().length() == 0) {
            throw new InsufficientInformationException("service for event is unavailable");
        }
    }

    public static Event createDeleteInterfaceEvent(String source, long nodeId, String ipAddr, int ifIndex, long txNo) {
        return EventUtils.createInterfaceEventBuilder("uei.opennms.org/internal/capsd/deleteInterface", source, nodeId, ipAddr, ifIndex, txNo).getEvent();
    }

    private static EventBuilder createInterfaceEventBuilder(String uei, String source, long nodeId, String ipAddr, int ifIndex, long txNo) {
        EventBuilder bldr = new EventBuilder(uei, source);
        if (ipAddr != null && ipAddr.length() != 0) {
            bldr.setInterface(InetAddressUtils.addr((String)ipAddr));
        }
        bldr.setNodeid(nodeId);
        if (ifIndex != -1) {
            bldr.setIfIndex(ifIndex);
        }
        bldr.addParam("txno", txNo);
        return bldr;
    }

    public static Event createDeleteNodeEvent(String source, long nodeId, long txNo) {
        return EventUtils.createNodeEventBuilder("uei.opennms.org/internal/capsd/deleteNode", source, nodeId, txNo).getEvent();
    }

    private static EventBuilder createNodeEventBuilder(String uei, String source, long nodeId, long txNo) {
        EventBuilder bldr = new EventBuilder(uei, source);
        bldr.setNodeid(nodeId);
        if (txNo >= 0L) {
            bldr.addParam("txno", txNo);
        }
        return bldr;
    }

    public static Event createAssetInfoChangedEvent(String source, long nodeId, long txNo) {
        return EventUtils.createNodeEventBuilder("uei.opennms.org/nodes/assetInfoChanged", source, nodeId, txNo).getEvent();
    }

    public static Event createInterfaceDeletedEvent(String source, long nodeId, String ipAddr, long txNo) {
        return EventUtils.createInterfaceDeletedEvent(source, nodeId, ipAddr, -1, txNo);
    }

    public static Event createInterfaceDeletedEvent(String source, long nodeId, String ipAddr, int ifIndex, long txNo) {
        return EventUtils.createInterfaceEventBuilder("uei.opennms.org/nodes/interfaceDeleted", source, nodeId, ipAddr, ifIndex, txNo).getEvent();
    }

    public static Event createNodeDeletedEvent(String source, long nodeId, long txNo) {
        return EventUtils.createNodeEventBuilder("uei.opennms.org/nodes/nodeDeleted", source, nodeId, txNo).getEvent();
    }

    public static Event createServiceDeletedEvent(String source, long nodeId, String ipAddr, String service, long txNo) {
        return EventUtils.createServiceEventBuilder("uei.opennms.org/nodes/serviceDeleted", source, nodeId, ipAddr, service, txNo).getEvent();
    }

    private static EventBuilder createServiceEventBuilder(String uei, String source, long nodeId, String ipAddr, String service, long txNo) {
        EventBuilder bldr = new EventBuilder(uei, source);
        bldr.setNodeid(nodeId);
        bldr.setInterface(InetAddressUtils.addr((String)ipAddr));
        bldr.setService(service);
        bldr.addParam("txno", txNo);
        return bldr;
    }

    public static long getEventID(Event e) {
        long eventID = -1L;
        if (e.hasDbid()) {
            eventID = e.getDbid().intValue();
        }
        return eventID;
    }

    public static long getLongParm(Event e, String parmName, long defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getLongParm((Event)e, (String)parmName, (long)defaultValue);
    }

    public static int getIntParm(Event e, String parmName, int defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getIntParm((Event)e, (String)parmName, (int)defaultValue);
    }

    public static int getIntParm(Event e, String parmName) {
        return org.opennms.netmgt.model.events.EventUtils.getIntParm((Event)e, (String)parmName, (int)0);
    }

    public static long getNodeId(Event e) {
        long nodeID = -1L;
        if (e.hasNodeid()) {
            nodeID = e.getNodeid();
        }
        return nodeID;
    }

    public static String getParm(Event e, String parmName) {
        return org.opennms.netmgt.model.events.EventUtils.getParm((Event)e, (String)parmName);
    }

    public static String getParm(Event e, String parmName, String defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getParm((Event)e, (String)parmName, (String)defaultValue);
    }

    public static void requireParm(Event e, String parmName) throws InsufficientInformationException {
        for (Parm parm : e.getParmCollection()) {
            if (!parmName.equals(parm.getParmName())) continue;
            if (parm.getValue() != null && parm.getValue().getContent() != null) {
                return;
            }
            throw new InsufficientInformationException("parameter " + parmName + " required but only null valued parms available");
        }
        throw new InsufficientInformationException("parameter " + parmName + " required but was not available");
    }

    public static void sendEvent(Event newEvent, String callerUei, long txNo, boolean isXmlRpcEnabled) {
        block2: {
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
                LOG.debug("sendEvent: successfully sent event {}", (Object)newEvent);
            }
            catch (Throwable t) {
                LOG.warn("run: unexpected throwable exception caught during send to middleware", t);
                if (!isXmlRpcEnabled) break block2;
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, callerUei, "caught unexpected throwable exception.", status, "OpenNMS.Capsd");
            }
        }
    }

    public static Event createNodeAddedEvent(DbNodeEntry nodeEntry) {
        return EventUtils.createNodeAddedEvent(nodeEntry.getNodeId(), nodeEntry.getLabel(), nodeEntry.getLabelSource());
    }

    public static Event createNodeAddedEvent(int nodeId, String nodeLabel, OnmsNode.NodeLabelSource labelSource) {
        return EventUtils.createNodeAddedEvent("OpenNMS.Capsd", nodeId, nodeLabel, labelSource);
    }

    public static Event createNodeAddedEvent(String source, int nodeId, String nodeLabel, OnmsNode.NodeLabelSource labelSource) {
        EventBuilder bldr = EventUtils.createNodeEventBuilder("uei.opennms.org/nodes/nodeAdded", source, nodeId, -1L);
        bldr.setHost(Capsd.getLocalHostAddress());
        bldr.setParam("nodelabel", nodeLabel);
        if (labelSource != null) {
            bldr.setParam("nodelabelsource", labelSource.toString());
        }
        return bldr.getEvent();
    }

    public static Event createNodeGainedInterfaceEvent(DbNodeEntry nodeEntry, InetAddress ifaddr) {
        return EventUtils.createNodeGainedInterfaceEvent("OpenNMS.Capsd", nodeEntry.getNodeId(), ifaddr);
    }

    public static Event createNodeGainedInterfaceEvent(String source, int nodeId, InetAddress ifaddr) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedInterface", source);
        bldr.setNodeid((long)nodeId);
        bldr.setHost(Capsd.getLocalHostAddress());
        bldr.setInterface(ifaddr);
        bldr.addParam("iphostname", ifaddr.getHostName());
        return bldr.getEvent();
    }

    public static Event createNodeDeletedEvent(String source, int nodeId, String hostName, String nodeLabel, long txNo) {
        EventBuilder bldr = EventUtils.createNodeEventBuilder("uei.opennms.org/nodes/nodeDeleted", source, nodeId, txNo);
        if (nodeLabel != null && !"".equals(nodeLabel.trim())) {
            bldr.addParam("nodelabel", nodeLabel);
        }
        return bldr.getEvent();
    }

    public static Event createAndSendDeleteNodeEvent(String source, String nodeLabel, String hostName, long txNo) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/deleteNode", source);
        bldr.setHost(hostName);
        bldr.addParam("nodelabel", nodeLabel);
        bldr.addParam("txno", txNo);
        return bldr.getEvent();
    }

    public static Event createForceRescanEvent(String hostName, long nodeId) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/forceRescan", "OpenNMS.Capsd");
        bldr.setNodeid(nodeId);
        bldr.setHost(hostName);
        return bldr.getEvent();
    }

    public static Event createAndSendInterfaceDeletedEvent(String source, int nodeId, String ipaddr, String hostName, long txNo) {
        return EventUtils.createInterfaceEventBuilder("uei.opennms.org/nodes/interfaceDeleted", source, nodeId, ipaddr, -1, txNo).setHost(hostName).getEvent();
    }

    public static Event createNodeGainedServiceEvent(DbNodeEntry nodeEntry, InetAddress ifaddr, String service, long txNo) {
        int nodeId = nodeEntry.getNodeId();
        String nodeLabel = nodeEntry.getLabel();
        OnmsNode.NodeLabelSource labelSource = nodeEntry.getLabelSource();
        String sysName = nodeEntry.getSystemName();
        String sysDescr = nodeEntry.getSystemDescription();
        return EventUtils.createNodeGainedServiceEvent("OpenNMS.Capsd", nodeId, ifaddr, service, nodeLabel, labelSource, sysName, sysDescr);
    }

    public static Event createNodeGainedServiceEvent(String source, int nodeId, InetAddress ifaddr, String service, String nodeLabel, OnmsNode.NodeLabelSource labelSource, String sysName, String sysDescr) {
        EventBuilder bldr = EventUtils.createServiceEventBuilder("uei.opennms.org/nodes/nodeGainedService", source, nodeId, InetAddressUtils.str((InetAddress)ifaddr), service, -1L);
        bldr.setHost(Capsd.getLocalHostAddress());
        bldr.addParam("iphostname", ifaddr.getHostName());
        bldr.addParam("nodelabel", nodeLabel);
        if (labelSource != null) {
            bldr.addParam("nodelabelsource", labelSource.toString());
        }
        if (sysName != null) {
            bldr.addParam("nodesysname", sysName);
        }
        if (sysDescr != null) {
            bldr.addParam("nodesysdescription", sysDescr);
        }
        return bldr.getEvent();
    }

    public static Event createAndSendDeleteServiceEvent(String source, DbNodeEntry nodeEntry, InetAddress ifaddr, String service, String hostName, long txNo) {
        EventBuilder bldr = EventUtils.createServiceEventBuilder("uei.opennms.org/nodes/deleteService", source, nodeEntry.getNodeId(), InetAddressUtils.str((InetAddress)ifaddr), service, txNo);
        bldr.setHost(hostName);
        bldr.addParam("iphostname", ifaddr.getHostName());
        bldr.addParam("nodelabel", nodeEntry.getLabel());
        if (nodeEntry.getLabelSource() != null) {
            bldr.addParam("nodelabelsource", nodeEntry.getLabelSource().toString());
        }
        return bldr.getEvent();
    }

    public static Event createAddInterfaceEvent(String source, String nodeLabel, String ipaddr, String hostName, long txNo) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/addInterface", source);
        bldr.setInterface(InetAddressUtils.addr((String)ipaddr));
        bldr.setHost(hostName);
        bldr.addParam("nodelabel", nodeLabel);
        bldr.addParam("txno", txNo);
        return bldr.getEvent();
    }

    public static Event createAndSendDeleteInterfaceEvent(String source, String nodeLabel, String ipaddr, String hostName, long txNo) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/deleteInterface", source);
        bldr.setInterface(InetAddressUtils.addr((String)ipaddr));
        bldr.setHost(hostName);
        bldr.addParam("nodelabel", nodeLabel);
        bldr.addParam("txno", txNo);
        return bldr.getEvent();
    }

    public static Event createChangeServiceEvent(String source, String ipaddr, String service, String action, String hostName, long txNo) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/changeService", source);
        bldr.setInterface(InetAddressUtils.addr((String)ipaddr));
        bldr.setService(service);
        bldr.addParam("action", action);
        bldr.addParam("txno", txNo);
        return bldr.getEvent();
    }

    public static Event createDeleteServiceEvent(String source, long nodeId, String ipAddr, String service, long txNo) {
        return EventUtils.createServiceEventBuilder("uei.opennms.org/nodes/deleteService", source, nodeId, ipAddr, service, txNo).getEvent();
    }

    public static String toString(Event event) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Event)event);
    }

    public static String toString(Value value) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Value)value);
    }

    public static String toString(Snmp snmp) {
        return org.opennms.netmgt.model.events.EventUtils.toString((Snmp)snmp);
    }

    public static void addParam(Event event, String parmName, Object pollResultId) {
        Parm eventParm = new Parm();
        eventParm.setParmName(parmName);
        Value parmValue = new Value();
        parmValue.setContent(String.valueOf(pollResultId));
        eventParm.setValue(parmValue);
        event.addParm(eventParm);
    }
}

