/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.archive;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.TimeConverter;
import org.opennms.netmgt.archive.ArchiverException;
import org.opennms.netmgt.config.EventsArchiverConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsArchiver {
    private static final Logger LOG = LoggerFactory.getLogger(EventsArchiver.class);
    private static final String DB_SELECT_EVENTS_TO_ARCHIVE = "SELECT * FROM events WHERE (eventcreatetime < ?)";
    private static final String DB_DELETE_EVENT = "DELETE FROM events WHERE (eventID = ?)";
    private static final String EVENT_ID = "eventID";
    private static final String EVENT_LOG = "eventLog";
    private static final String EVENT_DISPLAY = "eventDisplay";
    private static final String EVENT_ACK_USER = "eventAckUser";
    private static final String MSG_YES = "Y";
    private static final String MSG_NO = "N";
    private long m_archAge;
    private String m_archSeparator;
    private Connection m_conn;
    private PreparedStatement m_eventsGetStmt;
    private PreparedStatement m_eventDeleteStmt;

    private void init() throws ArchiverException {
        long archAge;
        EventsArchiverConfigFactory eaFactory;
        try {
            EventsArchiverConfigFactory.init();
            eaFactory = EventsArchiverConfigFactory.getInstance();
        }
        catch (MarshalException ex) {
            LOG.error("MarshalException", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            LOG.error("ValidationException", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            LOG.error("IOException", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        String archAgeStr = eaFactory.getArchiveAge();
        try {
            archAge = TimeConverter.convertToMillis((String)archAgeStr);
        }
        catch (NumberFormatException nfe) {
            throw new ArchiverException("Archive age: " + archAgeStr + "- Incorrect format " + nfe.getMessage());
        }
        this.m_archAge = System.currentTimeMillis() - archAge;
        String separator = eaFactory.getSeparator();
        this.m_archSeparator = separator == null ? "#" : separator;
        if (LOG.isInfoEnabled()) {
            archAgeStr = new Date(this.m_archAge).toString();
            LOG.info("Events archive age specified = {}", (Object)archAgeStr);
            LOG.info("Events archive age in millisconds = {}", (Object)archAge);
            LOG.info("Events created before '{}' will be deleted", (Object)archAgeStr);
            LOG.info("Separator to be used in archive: {}", (Object)this.m_archSeparator);
        }
        try {
            this.m_conn = DataSourceFactory.getInstance().getConnection();
        }
        catch (SQLException e) {
            LOG.error("Exception while connecting to database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private boolean removeEvent(Integer eventID) {
        try {
            this.m_eventDeleteStmt.setInt(1, eventID);
            this.m_eventDeleteStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            LOG.error("Unable to delete event '{}': {}", (Object)eventID, (Object)sqle.getMessage());
            return false;
        }
        LOG.debug("EventID: {} removed from events table", (Object)eventID);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveEvents() {
        int archCount = 0;
        int remCount = 0;
        ResultSet eventsRS = null;
        try {
            this.m_eventsGetStmt.setTimestamp(1, new Timestamp(this.m_archAge));
            eventsRS = this.m_eventsGetStmt.executeQuery();
            int colCount = eventsRS.getMetaData().getColumnCount();
            while (eventsRS.next()) {
                boolean ret;
                Integer eventID = eventsRS.getInt(EVENT_ID);
                String eventUEI = eventsRS.getString("eventUei");
                String eventLog = eventsRS.getString(EVENT_LOG);
                String eventDisplay = eventsRS.getString(EVENT_DISPLAY);
                String eventAckUser = eventsRS.getString(EVENT_ACK_USER);
                LOG.debug("Event id: {} uei: {} log: {} display: {} eventAck: {}", new Object[]{eventID, eventUEI, eventLog, eventDisplay, eventAckUser});
                if (eventLog.equals(MSG_NO) && eventDisplay.equals(MSG_NO)) {
                    ret = this.removeEvent(eventID);
                    if (!ret) continue;
                    ++remCount;
                    continue;
                }
                if (eventLog.equals(MSG_YES) && eventDisplay.equals(MSG_NO)) {
                    ret = this.removeEvent(eventID);
                    if (!ret) continue;
                    this.sendToArchive(eventsRS, colCount);
                    LOG.debug("eventID {} archived", (Object)eventID);
                    ++archCount;
                    ++remCount;
                    continue;
                }
                if (eventLog.equals(MSG_NO) && eventDisplay.equals(MSG_YES)) {
                    if (eventAckUser == null || !(ret = this.removeEvent(eventID))) continue;
                    ++remCount;
                    continue;
                }
                if (eventAckUser == null || !(ret = this.removeEvent(eventID))) continue;
                this.sendToArchive(eventsRS, colCount);
                LOG.debug("eventID {} archived", (Object)eventID);
                ++archCount;
                ++remCount;
            }
            LOG.info("Number of events removed from the event table: {}", (Object)remCount);
            LOG.info("Number of events sent to the archive: {}", (Object)archCount);
        }
        catch (Throwable oe) {
            LOG.error("EventsArchiver: Error reading events for archival: ");
            LOG.error(oe.getMessage());
        }
        finally {
            try {
                eventsRS.close();
            }
            catch (Throwable e) {
                LOG.info("EventsArchiver: Exception while events result set: message -> {}", (Object)e.getMessage());
            }
        }
    }

    private void sendToArchive(final ResultSet eventsRS, final int colCount) {
        Logging.withPrefix((String)"events", (Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuffer outBuf = new StringBuffer();
                for (int index = 1; index <= colCount; ++index) {
                    String colValue;
                    try {
                        colValue = eventsRS.getString(index);
                    }
                    catch (SQLException sqlerr) {
                        throw new RuntimeException(sqlerr);
                    }
                    if (index == 1) {
                        outBuf.append(colValue);
                        continue;
                    }
                    outBuf.append(EventsArchiver.this.m_archSeparator + colValue);
                }
                String outBufStr = outBuf.toString();
                LOG.error(outBufStr);
            }
        });
    }

    private void close() {
        try {
            this.m_eventsGetStmt.close();
        }
        catch (SQLException e) {
            LOG.warn("Unable to close get statement", (Throwable)e);
        }
        try {
            this.m_eventDeleteStmt.close();
        }
        catch (SQLException e) {
            LOG.warn("Unable to close delete statement", (Throwable)e);
        }
        try {
            this.m_conn.close();
        }
        catch (SQLException e) {
            LOG.warn("Unable to close connection", (Throwable)e);
        }
    }

    public EventsArchiver() throws ArchiverException {
        this.init();
        try {
            this.m_eventsGetStmt = this.m_conn.prepareStatement(DB_SELECT_EVENTS_TO_ARCHIVE);
            this.m_eventDeleteStmt = this.m_conn.prepareStatement(DB_DELETE_EVENT);
        }
        catch (SQLException e) {
            LOG.error("EventsArchiver: Exception in opening the database connection or in the prepared statement for the get events", (Throwable)e);
            throw new ArchiverException("EventsArchiver: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Logging.withPrefix((String)"archiver", (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    EventsArchiver ea = new EventsArchiver();
                    ea.archiveEvents();
                    ea.close();
                }
                catch (ArchiverException ae) {
                    System.err.println(ae.getMessage());
                }
            }
        });
    }
}

