/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.Hashtable;
import org.exolab.castor.xml.ValidationException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xmlrpcd.XmlRpcNotifierTest;
import org.opennms.netmgt.xmlrpcd.XmlrpcAnticipator;
import org.opennms.netmgt.xmlrpcd.Xmlrpcd;
import org.opennms.test.ThrowableAnticipator;

public class XmlrpcdTest
extends OpenNMSTestCase {
    private static final int m_port1 = 59000;
    private static final int m_port2 = 59001;
    private Xmlrpcd m_xmlrpcd;
    private XmlrpcAnticipator m_anticipator1;
    private XmlrpcAnticipator m_anticipator2;
    StringReader m_config = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59000\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeUp\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeDown\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/interfaceUp\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/interfaceDown\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configTwo = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59000\" />\n  <xmlrpc-server url=\"http://localhost:59001\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configParallelSame = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59000\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59001\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configParallelDifferent = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59000\" />\n  <serverSubscription>baseEvents1</serverSubscription>\n </external-servers>\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59001\" />\n  <serverSubscription>baseEvents2</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents1\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n </subscription>\n <subscription name=\"baseEvents2\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configGeneric = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\" generic-msgs=\"true\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59000\" />\n  <serverSubscription>baseEvents</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n  <subscribed-event uei=\"uei.opennms.org/default/trap\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    StringReader m_configBad = new StringReader("<?xml version=\"1.0\"?>\n<xmlrpcd-configuration max-event-queue-size=\"5000\">\n <external-servers retries=\"1\" elapse-time=\"100\">\n  <xmlrpc-server url=\"http://localhost:59000\" />\n  <serverSubscription>baseEventsBlah</serverSubscription>\n </external-servers>\n <subscription name=\"baseEvents\">\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeLostService\"/>\n  <subscribed-event uei=\"uei.opennms.org/nodes/nodeRegainedService\"/>\n </subscription>\n</xmlrpcd-configuration>\n");
    ByteArrayInputStream m_serverConfig = new ByteArrayInputStream("<local-server server-name=\"nms1\" verify-server=\"false\">\n</local-server>\n".getBytes());

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_anticipator1 = new XmlrpcAnticipator(59000, false);
        OpennmsServerConfigFactory.setInstance((OpennmsServerConfigFactory)new OpennmsServerConfigFactory((InputStream)this.m_serverConfig));
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_config));
        this.m_xmlrpcd = new Xmlrpcd();
    }

    public void finishUp() {
        if (this.m_anticipator1 != null) {
            this.m_anticipator1.verifyAnticipated();
        }
        if (this.m_anticipator2 != null) {
            this.m_anticipator2.verifyAnticipated();
        }
        MockLogAppender.resetLogLevel();
        MockLogAppender.resetEvents();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.m_anticipator1 != null) {
            this.m_anticipator1.shutdown();
        }
        if (this.m_anticipator2 != null) {
            this.m_anticipator2.shutdown();
        }
        super.tearDown();
    }

    public void anticipateNotifyReceivedEvent(XmlrpcAnticipator anticipator) {
        anticipator.anticipateCall("notifyReceivedEvent", "0", "uei.opennms.org/internal/capsd/xmlrpcNotification", "test connection");
    }

    @Override
    @Test
    public void testDoNothing() {
        super.testDoNothing();
        this.finishUp();
    }

    @Test
    public void testStart() throws Exception {
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        this.finishUp();
    }

    @Test
    public void testQueueing() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        Event nodeOneEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(nodeOneEvent);
        Thread.sleep(1000L);
        this.m_anticipator1.verifyAnticipated();
        this.m_anticipator1.shutdown();
        Event nodeTwoEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 2, "192.168.1.2", "SNMP", date);
        this.getEventIpcManager().sendNow(nodeTwoEvent);
        Thread.sleep(1000L);
        this.m_anticipator1 = new XmlrpcAnticipator(59000, true);
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.anticipateServerServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        this.m_anticipator1.setupWebServer();
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    private void anticipateServerServiceCall(XmlrpcAnticipator anticipator, String method, Date date) {
        anticipator.anticipateCall(method, "Server", "192.168.1.2", "SNMP", "Not Available", "null", EventConstants.formatToString((Date)date));
    }

    private void anticipateRouterServiceCall(XmlrpcAnticipator anticipator, String method, Date date) {
        anticipator.anticipateCall(method, "Router", "192.168.1.1", "ICMP", "Not Available", "null", EventConstants.formatToString((Date)date));
    }

    @Test
    public void testSerialFailover() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configTwo));
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(59001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        Event nodeOneEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(nodeOneEvent);
        Thread.sleep(1000L);
        this.m_anticipator1.verifyAnticipated();
        this.m_anticipator1.shutdown();
        this.anticipateServerServiceCall(this.m_anticipator2, "sendServiceDownEvent", date);
        Event nodeTwoEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 2, "192.168.1.2", "SNMP", date);
        this.getEventIpcManager().sendNow(nodeTwoEvent);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testSerialFailback() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configTwo));
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(59001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        Event nodeOneEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(nodeOneEvent);
        Thread.sleep(1500L);
        this.m_anticipator1.verifyAnticipated();
        this.m_anticipator1.shutdown();
        this.anticipateServerServiceCall(this.m_anticipator2, "sendServiceDownEvent", date);
        Event nodeTwoEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 2, "192.168.1.2", "SNMP", date);
        this.getEventIpcManager().sendNow(nodeTwoEvent);
        Thread.sleep(1500L);
        this.m_anticipator2.verifyAnticipated();
        this.m_anticipator2.shutdown();
        this.m_anticipator1 = new XmlrpcAnticipator(59000);
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator1.anticipateCall("sendServiceDownEvent", "Firewall", "192.168.1.3", "Telnet", "Not Available", "null", EventConstants.formatToString((Date)date));
        Event nodeThreeEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 3, "192.168.1.3", "Telnet", date);
        this.getEventIpcManager().sendNow(nodeThreeEvent);
        Thread.sleep(1500L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    public void testMultipleServersSameEvents() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configParallelSame));
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(59001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        this.anticipateRouterServiceCall(this.m_anticipator2, "sendServiceDownEvent", date);
        Event e = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testMultipleServersDifferentEvents() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configParallelDifferent));
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_anticipator2 = new XmlrpcAnticipator(59001);
        this.anticipateNotifyReceivedEvent(this.m_anticipator2);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        Event lostEvent = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(lostEvent);
        this.anticipateServerServiceCall(this.m_anticipator2, "sendServiceUpEvent", date);
        Event regainedEvent = this.svcEvent("uei.opennms.org/nodes/nodeRegainedService", 2, "192.168.1.2", "SNMP", date);
        this.getEventIpcManager().sendNow(regainedEvent);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testEventGeneric() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configGeneric));
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("source", "the one true event source");
        t.put("nodeId", "1");
        t.put("time", EventConstants.formatToString((Date)date));
        t.put("interface", "192.168.1.1");
        t.put("nodeLabel", "Router");
        t.put("service", "ICMP");
        t.put("uei", "uei.opennms.org/nodes/nodeLostService");
        t.put("description", "\n      <p>A ICMP outage was identified on interface\n      192.168.1.1.</p> <p>A new Outage record has been\n      created and service level availability calculations will be\n      impacted until this outage is resolved.</p>\n    ");
        t.put("severity", "Minor");
        this.m_anticipator1.anticipateCall("sendEvent", t);
        Event e = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testSendTrapSimpleNonGeneric() throws Exception {
        Date date = new Date();
        String enterpriseId = ".1.3.6.4.1.1.1";
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setSource("the one true source");
        bldr.setLogMessage("");
        XmlRpcNotifierTest.addSnmpAttributes(bldr, "public", enterpriseId, 6, 2, date.getTime(), "1");
        this.getEventIpcManager().sendNow(bldr.getEvent());
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testSendTrapSimple() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configGeneric));
        Date date = new Date();
        String enterpriseId = ".1.3.6.4.1.1.1";
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        Hashtable<String, String> trapMap = XmlRpcNotifierTest.basicTrapMap(date, "public", enterpriseId, 6, 2, date.getTime(), "1");
        trapMap.put("uei", "uei.opennms.org/default/trap");
        trapMap.put("source", "the one true source");
        trapMap.put("severity", "Normal");
        this.m_anticipator1.anticipateCall("sendSnmpTrapEvent", trapMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setUei("uei.opennms.org/default/trap");
        bldr.setSource("the one true source");
        bldr.setSeverity("Normal");
        bldr.setLogMessage("");
        XmlRpcNotifierTest.addSnmpAttributes(bldr, "public", enterpriseId, 6, 2, date.getTime(), "1");
        this.getEventIpcManager().sendNow(bldr.getEvent());
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testServiceDownEvent() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceDownEvent", date);
        Event e = this.svcEvent("uei.opennms.org/nodes/nodeLostService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testServiceUpEvent() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.anticipateRouterServiceCall(this.m_anticipator1, "sendServiceUpEvent", date);
        Event e = this.svcEvent("uei.opennms.org/nodes/nodeRegainedService", 1, "192.168.1.1", "ICMP", date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testInterfaceDownEvent() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendInterfaceDownEvent", "Router", "192.168.1.1", "null", EventConstants.formatToString((Date)date));
        Event e = this.ifEvent("uei.opennms.org/nodes/interfaceDown", 1, "192.168.1.1", date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testInterfaceUpEvent() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendInterfaceUpEvent", "Router", "192.168.1.1", "null", "null", EventConstants.formatToString((Date)date));
        Event e = this.ifEvent("uei.opennms.org/nodes/interfaceUp", 1, "192.168.1.1", date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testNodeDownEvent() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendNodeDownEvent", "Router", "bar", EventConstants.formatToString((Date)date));
        Event e = this.nodeEvent("uei.opennms.org/nodes/nodeDown", 1, date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testNodeUpEvent() throws Exception {
        Date date = new Date();
        this.anticipateNotifyReceivedEvent(this.m_anticipator1);
        this.m_xmlrpcd.init();
        this.m_xmlrpcd.start();
        this.m_anticipator1.anticipateCall("sendNodeUpEvent", "Router", "bar", EventConstants.formatToString((Date)date));
        Event e = this.nodeEvent("uei.opennms.org/nodes/nodeUp", 1, date);
        this.getEventIpcManager().sendNow(e);
        Thread.sleep(1000L);
        this.m_xmlrpcd.stop();
        Thread.sleep(2000L);
        this.finishUp();
    }

    @Test
    public void testBadConfig() throws Exception {
        XmlrpcdConfigFactory.setInstance((XmlrpcdConfigFactory)new XmlrpcdConfigFactory((Reader)this.m_configBad));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new UndeclaredThrowableException((Throwable)new ValidationException()));
        try {
            this.m_xmlrpcd.init();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.finishUp();
    }

    private Event nodeEvent(String uei, int nodeid, Date date) {
        EventBuilder bldr = new EventBuilder(uei, "the one true event source", date);
        bldr.setNodeid((long)nodeid);
        bldr.setHost("bar");
        return bldr.getEvent();
    }

    private Event ifEvent(String uei, int nodeid, String ipAddr, Date date) {
        EventBuilder bldr = new EventBuilder(uei, "the one true event source", date);
        bldr.setNodeid((long)nodeid);
        bldr.setInterface(InetAddressUtils.addr((String)ipAddr));
        return bldr.getEvent();
    }

    private Event svcEvent(String uei, int nodeid, String ipAddr, String svcName, Date date) {
        EventBuilder bldr = new EventBuilder(uei, "the one true event source", date);
        bldr.setNodeid((long)nodeid);
        bldr.setInterface(InetAddressUtils.addr((String)ipAddr));
        bldr.setService(svcName);
        return bldr.getEvent();
    }
}

