/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorTestCase;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.MockCollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorAbsoluteChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ThrowableAnticipator;

public class ThresholdEvaluatorAbsoluteChangeTest
extends AbstractThresholdEvaluatorTestCase {
    @Test
    public void testConstructor() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
    }

    @Test
    public void testConstructorThresholdNull() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold argument cannot be null"));
        try {
            new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testEvaluateOnce() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
    }

    @Test
    public void testEvaluateTwiceNoTrigger() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
    }

    @Test
    public void testEvaluateTwiceTriggerLowBelow() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(-1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(8.0));
    }

    @Test
    public void testEvaluateTwiceTriggerLowEqual() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(-1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(9.0));
    }

    @Test
    public void testEvaluateTwiceNoTriggerLowAbove() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(-1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(9.5));
    }

    @Test
    public void testEvaluateTwiceTriggerHighAbove() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(12.0));
    }

    @Test
    public void testEvaluateTwiceTriggerHighEqual() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(11.0));
    }

    @Test
    public void testEvaluateTwiceNoTriggerHighBelow() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.5));
    }

    @Test
    public void testGetEventForStateNoChange() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertNull((String)"should not have created an event", (Object)evaluator.getEventForState(ThresholdEvaluatorState.Status.NO_CHANGE, new Date(), 10.0, null));
    }

    @Test
    public void testGetEventForStateTriggered() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.0);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange evaluator = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Assert.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(8.0));
        Assert.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(10.0));
        Event event = evaluator.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 10.0, null);
        Assert.assertNotNull((String)"should have created an event", (Object)event);
        Assert.assertEquals((String)"UEIs should be the same", (Object)"uei.opennms.org/threshold/absoluteChangeExceeded", (Object)event.getUei());
        Assert.assertNotNull((String)"event should have parms", (Object)event.getParmCollection());
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentAndValueNonNull(event, "instance");
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "value", "10.0");
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "previousValue", "8.0");
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "changeThreshold", "1.0");
        event = evaluator.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 10.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        Assert.assertNotNull((String)"should have created an event", (Object)event);
        Assert.assertEquals((String)"UEIs should be the same", (Object)"uei.opennms.org/threshold/absoluteChangeExceeded", (Object)event.getUei());
        Assert.assertNotNull((String)"event should have parms", (Object)event.getParmCollection());
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "instance", "testInstance");
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "value", "10.0");
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "previousValue", "8.0");
        ThresholdEvaluatorAbsoluteChangeTest.parmPresentWithValue(event, "changeThreshold", "1.0");
    }

    @Test
    public void testGetEventForStateDefaultUEIS() {
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(99.0);
        threshold.setRearm(95.0);
        threshold.setTrigger(1);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange item = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        Assert.assertEquals((String)"UEI should be the absoluteChangeThresholdTriggered", (Object)"uei.opennms.org/threshold/absoluteChangeExceeded", (Object)event.getUei());
    }

    @Test
    public void testGetEventForStateCustomUEIS() {
        String triggeredUEI = "uei.opennms.org/custom/absoluteChangeThresholdTriggered";
        Threshold threshold = new Threshold();
        threshold.setType("absoluteChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(99.0);
        threshold.setRearm(95.0);
        threshold.setTrigger(1);
        threshold.setTriggeredUEI(triggeredUEI);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange item = new ThresholdEvaluatorAbsoluteChange.ThresholdEvaluatorStateAbsoluteChange((BaseThresholdDefConfigWrapper)wrapper);
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        Assert.assertEquals((String)("UEI should be the " + triggeredUEI), (Object)triggeredUEI, (Object)event.getUei());
    }
}

