/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.dao.support.NullRrdStrategy;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class LatencyStoringServiceMonitorAdaptorTest {
    private EasyMockUtils m_mocks;
    private PollerConfig m_pollerConfig;
    private RrdStrategy<Object, Object> m_rrdStrategy;

    @Before
    public void setUp() throws Exception {
        this.m_mocks = new EasyMockUtils();
        this.m_pollerConfig = (PollerConfig)this.m_mocks.createMock(PollerConfig.class);
        this.m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);
        MockLogAppender.setupLogging();
        RrdUtils.setStrategy((RrdStrategy)new NullRrdStrategy());
        RrdUtils.setStrategy(this.m_rrdStrategy);
        System.setProperty("opennms.home", "src/test/resources");
        PollOutagesConfigFactory.init();
    }

    @After
    public void tearDown() throws Throwable {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testUpdateRrdWithLocaleThatUsesCommasForDecimals() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.FRENCH);
        NumberFormat nf = NumberFormat.getInstance();
        Assert.assertEquals((String)("ensure that the newly set default locale (" + Locale.getDefault() + ") uses ',' as the decimal marker"), (Object)"1,5", (Object)nf.format(1.5));
        LatencyStoringServiceMonitorAdaptor adaptor = new LatencyStoringServiceMonitorAdaptor(null, this.m_pollerConfig, new Package());
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        map.put("cheese", 1.5);
        EasyMock.expect((Object)this.m_pollerConfig.getStep((Package)EasyMock.isA(Package.class))).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)this.m_pollerConfig.getRRAList((Package)EasyMock.isA(Package.class))).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".rrd").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), LatencyStoringServiceMonitorAdaptorTest.isAList(RrdDataSource.class), LatencyStoringServiceMonitorAdaptorTest.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class), (Map)EasyMock.eq(null));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.endsWith((String)":1.5"));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        this.m_mocks.replayAll();
        adaptor.updateRRD("foo", InetAddress.getLocalHost(), "baz", map);
        this.m_mocks.verifyAll();
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testThresholds() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/threshold/highThresholdExceeded", "LatencyStoringServiceMonitorAdaptorTest");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"127.0.0.1"));
        bldr.setService("ICMP");
        EventAnticipator anticipator = new EventAnticipator();
        anticipator.anticipateEvent(bldr.getEvent());
        this.executeThresholdTest(anticipator);
        anticipator.verifyAnticipated();
    }

    @Test
    public void testThresholdsWithScheduledOutage() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\"?>");
        sb.append("<outages>");
        sb.append("<outage name=\"junit outage\" type=\"specific\">");
        sb.append("<time begins=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() - 3600000L)));
        sb.append("\" ends=\"");
        sb.append(formatter.format(new Date(System.currentTimeMillis() + 3600000L)));
        sb.append("\"/>");
        sb.append("<interface address=\"match-any\"/>");
        sb.append("</outage>");
        sb.append("</outages>");
        File file = new File("target/poll-outages.xml");
        FileWriter writer = new FileWriter(file);
        writer.write(sb.toString());
        writer.close();
        PollOutagesConfigFactory oldFactory = PollOutagesConfigFactory.getInstance();
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)new PollOutagesConfigFactory((Resource)new FileSystemResource(file)));
        PollOutagesConfigFactory.getInstance().afterPropertiesSet();
        EventAnticipator anticipator = new EventAnticipator();
        this.executeThresholdTest(anticipator);
        anticipator.verifyAnticipated();
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)oldFactory);
        file.delete();
    }

    private void executeThresholdTest(EventAnticipator anticipator) throws Exception {
        System.setProperty("opennms.home", "src/test/resources");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("rrd-repository", "/tmp");
        parameters.put("ds-name", "icmp");
        parameters.put("rrd-base-name", "icmp");
        parameters.put("thresholding-enabled", "true");
        FilterDao filterDao = (FilterDao)this.m_mocks.createMock(FilterDao.class);
        EasyMock.expect((Object)filterDao.getActiveIPAddressList((String)EasyMock.anyObject())).andReturn(Collections.singletonList(InetAddressUtils.addr((String)"127.0.0.1"))).anyTimes();
        filterDao.flushActiveIpAddressListCache();
        EasyMock.expectLastCall().anyTimes();
        FilterDaoFactory.setInstance((FilterDao)filterDao);
        MonitoredService svc = (MonitoredService)this.m_mocks.createMock(MonitoredService.class);
        EasyMock.expect((Object)svc.getNodeId()).andReturn((Object)1);
        EasyMock.expect((Object)svc.getIpAddr()).andReturn((Object)"127.0.0.1");
        EasyMock.expect((Object)svc.getAddress()).andReturn((Object)InetAddressUtils.addr((String)"127.0.0.1"));
        EasyMock.expect((Object)svc.getSvcName()).andReturn((Object)"ICMP");
        ServiceMonitor service = (ServiceMonitor)this.m_mocks.createMock(ServiceMonitor.class);
        PollStatus value = PollStatus.get((int)1, (Double)100.0);
        EasyMock.expect((Object)service.poll(svc, parameters)).andReturn((Object)value);
        int step = 300;
        List<String> rras = Collections.singletonList("RRA:AVERAGE:0.5:1:2016");
        Package pkg = new Package();
        Rrd rrd = new Rrd();
        rrd.setStep(Integer.valueOf(step));
        rrd.setRras(rras);
        pkg.setRrd(rrd);
        EasyMock.expect((Object)this.m_pollerConfig.getRRAList(pkg)).andReturn(rras);
        EasyMock.expect((Object)this.m_pollerConfig.getStep(pkg)).andReturn((Object)step).anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".rrd").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), LatencyStoringServiceMonitorAdaptorTest.isAList(RrdDataSource.class), LatencyStoringServiceMonitorAdaptorTest.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class), (Map)EasyMock.eq(null));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.endsWith((String)":100"));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        eventMgr.setEventAnticipator(anticipator);
        eventMgr.setSynchronous(true);
        MockEventIpcManager eventdIpcMgr = eventMgr;
        EventIpcManagerFactory.setIpcManager((EventIpcManager)eventdIpcMgr);
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface("127.0.0.1");
        network.setIfAlias("eth0");
        network.addService("ICMP");
        network.addService("SNMP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        db.update("update snmpinterface set snmpifname=?, snmpifdescr=? where id=?", new Object[]{"eth0", "eth0", 1});
        DataSourceFactory.setInstance((DataSource)db);
        this.m_mocks.replayAll();
        LatencyStoringServiceMonitorAdaptor adaptor = new LatencyStoringServiceMonitorAdaptor(service, this.m_pollerConfig, pkg);
        adaptor.poll(svc, parameters);
        this.m_mocks.verifyAll();
    }

    private static <T> List<T> isAList(Class<T> clazz) {
        return (List)EasyMock.isA(List.class);
    }
}

